/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.debug;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionIdentifier;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class DumpVariablesTask
implements CommonTaskType {
    private final CustomVariableContext customVariableContext;

    @Inject
    public DumpVariablesTask(@ComponentImport CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public TaskResult execute(@NotNull CommonTaskContext taskContext) {
        BuildLogger logger = taskContext.getBuildLogger();
        logger.addBuildLogEntry("---- DUMPING VARIABLES TO LOG --- ");
        for (VariableDefinitionContext vdc : VariableDefinitionIdentifier.ORDERING.sortedCopy(this.customVariableContext.getVariableContexts().values())) {
            String valueString = PasswordMaskingUtils.shouldBeMasked((String)vdc.getKey()) ? "**********" : vdc.getValue();
            logger.addBuildLogEntry("key: [" + vdc.getKey() + "] value: [" + valueString + "] type: " + vdc.getVariableType().name());
        }
        logger.addBuildLogEntry("---- END DUMPING VARIABLES TO LOG  --- ");
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }
}

