/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.grunt;

import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskExporter;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.GruntTask;
import com.atlassian.bamboo.specs.model.task.GruntTaskProperties;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class GruntTaskExporter
extends AbstractNodeRequiringTaskExporter<GruntTaskProperties, GruntTask> {
    @Autowired
    public GruntTaskExporter(UIConfigSupport uiConfigSupport) {
        super(GruntTaskProperties.class, uiConfigSupport);
    }

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return GruntTaskProperties.VALIDATION_CONTEXT;
    }

    @Override
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull GruntTaskProperties taskProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("gruntRuntime", taskProperties.getGruntCliExecutable());
        config.put("task", taskProperties.getTask());
        config.put("configFile", taskProperties.getGruntfile());
        return config;
    }

    @Override
    @NotNull
    protected GruntTask toSpecsEntity(@NotNull Map<String, String> taskConfiguration) {
        return new GruntTask().gruntCliExecutable(taskConfiguration.get("gruntRuntime")).task((String)taskConfiguration.getOrDefault("task", null)).gruntfile((String)taskConfiguration.getOrDefault("configFile", null));
    }

    @Override
    @NotNull
    public List<ValidationProblem> validate(@NotNull GruntTaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        if (StringUtils.isBlank((String)taskProperties.getGruntCliExecutable())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Grunt CLI executable is not defined"));
        }
        return validationProblems;
    }
}

