/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.node;

import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskExporter;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.NodeTask;
import com.atlassian.bamboo.specs.model.task.NodeTaskProperties;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeTaskExporter
extends AbstractNodeRequiringTaskExporter<NodeTaskProperties, NodeTask> {
    @Autowired
    public NodeTaskExporter(UIConfigSupport uiConfigSupport) {
        super(NodeTaskProperties.class, uiConfigSupport);
    }

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return NodeTaskProperties.VALIDATION_CONTEXT;
    }

    @Override
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull NodeTaskProperties taskProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("command", taskProperties.getScript());
        config.put("arguments", taskProperties.getArguments());
        return config;
    }

    @Override
    @NotNull
    protected NodeTask toSpecsEntity(@NotNull Map<String, String> taskConfiguration) {
        return new NodeTask().script(taskConfiguration.get("command")).arguments((String)taskConfiguration.getOrDefault("arguments", null));
    }

    @Override
    @NotNull
    public List<ValidationProblem> validate(@NotNull NodeTaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        if (StringUtils.isBlank((String)taskProperties.getScript())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Script is not defined"));
        }
        return validationProblems;
    }
}

