/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.gulp;

import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskExporter;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.GulpTask;
import com.atlassian.bamboo.specs.model.task.GulpTaskProperties;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class GulpTaskExporter
extends AbstractNodeRequiringTaskExporter<GulpTaskProperties, GulpTask> {
    @Autowired
    public GulpTaskExporter(UIConfigSupport uiConfigSupport) {
        super(GulpTaskProperties.class, uiConfigSupport);
    }

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return GulpTaskProperties.VALIDATION_CONTEXT;
    }

    @Override
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull GulpTaskProperties taskProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("gulpRuntime", taskProperties.getGulpExecutable());
        config.put("task", taskProperties.getTask());
        config.put("configFile", taskProperties.getGulpfile());
        return config;
    }

    @Override
    @NotNull
    protected GulpTask toSpecsEntity(@NotNull Map<String, String> taskConfiguration) {
        return new GulpTask().gulpExecutable(taskConfiguration.get("gulpRuntime")).task((String)taskConfiguration.getOrDefault("task", null)).gulpfile((String)taskConfiguration.getOrDefault("configFile", null));
    }

    @Override
    @NotNull
    public List<ValidationProblem> validate(@NotNull GulpTaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        if (StringUtils.isBlank((String)taskProperties.getGulpExecutable())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Gulp executable is not defined"));
        }
        return validationProblems;
    }
}

