/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks;

import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.BaseNodeTask;
import com.atlassian.bamboo.specs.model.task.BaseNodeTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNodeRequiringTaskExporter<P extends BaseNodeTaskProperties, B extends BaseNodeTask<B, P>>
implements TaskDefinitionExporter {
    private final Class<P> propertiesClass;
    private final UIConfigSupport uiConfigSupport;

    protected AbstractNodeRequiringTaskExporter(Class<P> propertiesClass, UIConfigSupport uiConfigSupport) {
        this.propertiesClass = propertiesClass;
        this.uiConfigSupport = uiConfigSupport;
    }

    @NotNull
    protected abstract ValidationContext getValidationContext();

    @NotNull
    protected abstract Map<String, String> toTaskConfiguration(@NotNull P var1);

    @NotNull
    public final Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        BaseNodeTaskProperties typedTaskProperties = (BaseNodeTaskProperties)Narrow.downTo((Object)taskProperties, this.propertiesClass);
        Preconditions.checkState((typedTaskProperties != null ? 1 : 0) != 0, (Object)("Don't know how to import task properties of type: " + taskProperties.getClass().getName()));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("runtime", typedTaskProperties.getNodeExecutable());
        config.put("environmentVariables", typedTaskProperties.getEnvironmentVariables());
        config.put("workingSubDirectory", typedTaskProperties.getWorkingSubdirectory());
        config.putAll(this.toTaskConfiguration(typedTaskProperties));
        return config;
    }

    @NotNull
    protected abstract B toSpecsEntity(@NotNull Map<String, String> var1);

    @NotNull
    public final B toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map config = taskDefinition.getConfiguration();
        return (B)this.toSpecsEntity(config).nodeExecutable((String)config.get("runtime")).environmentVariables((String)config.get("environmentVariables")).workingSubdirectory((String)config.get("workingSubDirectory"));
    }

    @NotNull
    protected abstract List<ValidationProblem> validate(@NotNull P var1);

    public final List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        BaseNodeTaskProperties typedTaskProperties = (BaseNodeTaskProperties)Narrow.downTo((Object)taskProperties, this.propertiesClass);
        if (typedTaskProperties != null) {
            String nodeExecutable = typedTaskProperties.getNodeExecutable();
            if (StringUtils.isEmpty((CharSequence)nodeExecutable)) {
                validationProblems.add(new ValidationProblem(this.getValidationContext(), "Node.js executable can't be empty"));
            } else {
                List executableLabels = this.uiConfigSupport.getExecutableLabels("node");
                if (executableLabels.stream().noneMatch(label -> label.equals(nodeExecutable))) {
                    String errorMessage = String.format("Can't find Node.js executable by label: '%s'. Available values: %s", nodeExecutable, executableLabels);
                    validationProblems.add(new ValidationProblem(this.getValidationContext(), errorMessage));
                }
            }
            validationProblems.addAll(this.validate(typedTaskProperties));
        }
        return validationProblems;
    }
}

