/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.npm;

import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskExporter;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.NpmTask;
import com.atlassian.bamboo.specs.model.task.NpmTaskProperties;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class NpmTaskExporter
extends AbstractNodeRequiringTaskExporter<NpmTaskProperties, NpmTask> {
    @Autowired
    public NpmTaskExporter(UIConfigSupport uiConfigSupport) {
        super(NpmTaskProperties.class, uiConfigSupport);
    }

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return NpmTaskProperties.VALIDATION_CONTEXT;
    }

    @Override
    @NotNull
    protected Map<String, String> toTaskConfiguration(@NotNull NpmTaskProperties taskProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("command", taskProperties.getCommand());
        config.put("isolatedCache", Boolean.toString(taskProperties.isUseIsolatedCache()));
        return config;
    }

    @Override
    @NotNull
    public NpmTask toSpecsEntity(@NotNull Map<String, String> taskConfiguration) {
        return new NpmTask().command(taskConfiguration.get("command")).useIsolatedCache(Boolean.parseBoolean(taskConfiguration.getOrDefault("isolatedCache", null)));
    }

    @Override
    @NotNull
    protected List<ValidationProblem> validate(@NotNull NpmTaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        if (StringUtils.isEmpty((CharSequence)taskProperties.getCommand())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Command can't be empty"));
        }
        return validationProblems;
    }
}

