/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.nodeunit;

import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskExporter;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.NodeunitTask;
import com.atlassian.bamboo.specs.model.task.NodeunitTaskProperties;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeunitTaskExporter
extends AbstractNodeRequiringTaskExporter<NodeunitTaskProperties, NodeunitTask> {
    @Autowired
    public NodeunitTaskExporter(UIConfigSupport uiConfigSupport) {
        super(NodeunitTaskProperties.class, uiConfigSupport);
    }

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return NodeunitTaskProperties.VALIDATION_CONTEXT;
    }

    @Override
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull NodeunitTaskProperties taskProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("nodeunitRuntime", taskProperties.getNodeunitExecutable());
        config.put("testFiles", taskProperties.getTestFilesAndDirectories());
        config.put("testResultsDir", taskProperties.getTestResultsDirectory());
        config.put("parseTestResults", Boolean.toString(taskProperties.isParseTestResults()));
        config.put("arguments", taskProperties.getArguments());
        return config;
    }

    @Override
    @NotNull
    protected NodeunitTask toSpecsEntity(@NotNull Map<String, String> taskConfiguration) {
        return new NodeunitTask().nodeunitExecutable(taskConfiguration.get("nodeunitRuntime")).testFilesAndDirectories(taskConfiguration.get("testFiles")).testResultsDirectory(taskConfiguration.get("testResultsDir")).parseTestResults(Boolean.parseBoolean(taskConfiguration.getOrDefault("parseTestResults", Boolean.toString(NodeunitTask.DEFAULT_PARSE_TEST_RESULTS)))).arguments((String)taskConfiguration.getOrDefault("arguments", null));
    }

    @Override
    @NotNull
    public List<ValidationProblem> validate(@NotNull NodeunitTaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        if (StringUtils.isBlank((String)taskProperties.getNodeunitExecutable())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Nodeunit executable is not defined"));
        }
        if (StringUtils.isBlank((String)taskProperties.getTestFilesAndDirectories())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Test files and/or directories are not defined"));
        }
        if (StringUtils.isBlank((String)taskProperties.getTestResultsDirectory())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Test results directory is not defined"));
        }
        return validationProblems;
    }
}

