/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser;

import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.MochaParserTask;
import com.atlassian.bamboo.specs.model.task.MochaParserTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MochaParserTaskExporter
implements TaskDefinitionExporter {
    @NotNull
    private ValidationContext getValidationContext() {
        return MochaParserTaskProperties.VALIDATION_CONTEXT;
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        MochaParserTaskProperties typedTaskProperties = (MochaParserTaskProperties)Narrow.downTo((Object)taskProperties, MochaParserTaskProperties.class);
        Preconditions.checkState((typedTaskProperties != null ? 1 : 0) != 0, (Object)("Don't know how to import task properties of type: " + taskProperties.getClass().getName()));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("testPattern", typedTaskProperties.getTestFilePattern());
        config.put("workingSubDirectory", typedTaskProperties.getWorkingSubdirectory());
        config.put("pickupOutdatedFiles", Boolean.toString(typedTaskProperties.isPickUpTestResultsCreatedOutsideOfThisBuild()));
        return config;
    }

    @NotNull
    public MochaParserTask toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        return new MochaParserTask().testFilePattern((String)configuration.get("testPattern")).workingSubdirectory((String)configuration.getOrDefault("workingSubDirectory", null)).pickUpTestResultsCreatedOutsideOfThisBuild(Boolean.parseBoolean(configuration.getOrDefault("pickupOutdatedFiles", null)));
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        MochaParserTaskProperties typedTaskProperties = (MochaParserTaskProperties)Narrow.downTo((Object)taskProperties, MochaParserTaskProperties.class);
        if (typedTaskProperties != null && StringUtils.isBlank((String)typedTaskProperties.getTestFilePattern())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Test file pattern is not defined"));
        }
        return validationProblems;
    }
}

