/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hipchat;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.HttpUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HipchatNotificationTransport
implements NotificationTransport {
    private static final Logger log = Logger.getLogger(HipchatNotificationTransport.class);
    private static final String HIPCHAT_API_BASE_PROPERTY = "hipchat.api.url";
    private static final String HIPCHAT_API_BASE_DEFAULT = "https://api.hipchat.com";
    private static final String HIPCHAT_API_BASE = HipchatNotificationTransport.determineHipChatApiBaseUrl();
    public static final String HIPCHAT_API_URL = HIPCHAT_API_BASE + "/v1/rooms/message?auth_token=";
    public static final String COLOR_UNKNOWN_STATE = "gray";
    public static final String COLOR_FAILED = "red";
    public static final String COLOR_SUCCESSFUL = "green";
    public static final String COLOR_IN_PROGRESS = "yellow";
    @VisibleForTesting
    final String apiToken;
    @VisibleForTesting
    final String room;
    private static final String from = "Bamboo";
    private final boolean notify;
    private final HttpClient client;
    @Nullable
    private final ResultsSummary resultsSummary;
    @Nullable
    private final DeploymentResult deploymentResult;

    public HipchatNotificationTransport(String apiToken, String room, boolean notify, @Nullable ResultsSummary resultsSummary, @Nullable DeploymentResult deploymentResult) {
        this.apiToken = apiToken;
        this.room = room;
        this.notify = notify;
        this.resultsSummary = resultsSummary;
        this.deploymentResult = deploymentResult;
        this.client = new HttpClient();
        try {
            URI uri = new URI(HIPCHAT_API_URL);
            HipchatNotificationTransport.setProxy(this.client, uri.getScheme(), uri.getHost());
        }
        catch (URISyntaxException | URIException e) {
            log.error((Object)("Unable to set up proxy settings, invalid URI encountered: " + e));
        }
    }

    public void sendNotification(Notification notification) {
        String message;
        String string = message = notification instanceof Notification.HtmlImContentProvidingNotification ? ((Notification.HtmlImContentProvidingNotification)notification).getHtmlImContent() : notification.getIMContent();
        if (!StringUtils.isEmpty((CharSequence)message)) {
            PostMethod method = this.setupPostMethod();
            method.setParameter("message", message);
            if (this.resultsSummary != null) {
                this.setMessageColor(method, this.resultsSummary);
            } else if (this.deploymentResult != null) {
                this.setMessageColor(method, this.deploymentResult);
            } else {
                this.setMessageColor(method, COLOR_UNKNOWN_STATE);
            }
            try {
                this.client.executeMethod((HttpMethod)method);
            }
            catch (IOException e) {
                log.error((Object)("Error using Hipchat API: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void setMessageColor(PostMethod method, ResultsSummary result) {
        String color = COLOR_UNKNOWN_STATE;
        if (result.getBuildState() == BuildState.FAILED) {
            color = COLOR_FAILED;
        } else if (result.getBuildState() == BuildState.SUCCESS) {
            color = COLOR_SUCCESSFUL;
        } else if (LifeCycleState.isActive((LifeCycleState)result.getLifeCycleState())) {
            color = COLOR_IN_PROGRESS;
        }
        this.setMessageColor(method, color);
    }

    private void setMessageColor(PostMethod method, DeploymentResult deploymentResult) {
        String color = COLOR_UNKNOWN_STATE;
        if (deploymentResult.getDeploymentState() == BuildState.FAILED) {
            color = COLOR_FAILED;
        } else if (deploymentResult.getDeploymentState() == BuildState.SUCCESS) {
            color = COLOR_SUCCESSFUL;
        } else if (LifeCycleState.isActive((LifeCycleState)deploymentResult.getLifeCycleState())) {
            color = COLOR_IN_PROGRESS;
        }
        this.setMessageColor(method, color);
    }

    private void setMessageColor(PostMethod method, String colour) {
        method.addParameter("color", colour);
    }

    private PostMethod setupPostMethod() {
        PostMethod m = new PostMethod(HIPCHAT_API_URL + this.apiToken);
        m.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        m.addParameter("room_id", this.room);
        m.addParameter("from", from);
        m.addParameter("notify", this.notify ? "1" : "0");
        return m;
    }

    private static void setProxy(@NotNull HttpClient client, @Nullable String scheme, @NotNull String hostname) throws URIException {
        HttpUtils.EndpointSpec proxyForScheme = HttpUtils.getProxyForScheme((String)scheme);
        if (proxyForScheme != null && !HipchatNotificationTransport.isNonProxyHost(hostname)) {
            client.getHostConfiguration().setProxy(proxyForScheme.host, proxyForScheme.port.intValue());
        }
    }

    private static boolean isNonProxyHost(String host) {
        String[] nonProxyHosts;
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (StringUtils.isBlank((CharSequence)httpNonProxyHosts)) {
            if (StringUtils.isNotBlank((CharSequence)System.getProperty("http.nonProxyHost"))) {
                log.warn((Object)"The system property http.nonProxyHost is set. You probably meant to set http.nonProxyHosts.");
            }
            return false;
        }
        for (String nonProxyHost : nonProxyHosts = httpNonProxyHosts.split("\\|")) {
            if (!(nonProxyHost.startsWith("*") ? host.endsWith(nonProxyHost.substring(1)) : host.equals(nonProxyHost))) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static String determineHipChatApiBaseUrl() {
        String apiBase = UrlUtils.stripTailingSlashes((String)System.getProperty(HIPCHAT_API_BASE_PROPERTY, HIPCHAT_API_BASE_DEFAULT));
        log.info((Object)(apiBase + " will be used for HipChat integration (if enabled)."));
        return apiBase;
    }
}

