/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hipchat;

import com.atlassian.bamboo.deployments.notification.DeploymentResultAwareNotificationRecipient;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.hipchat.HipchatNotificationTransport;
import com.atlassian.bamboo.hipchat.HipchatRecipientConfiguration;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HipchatNotificationRecipient
extends AbstractNotificationRecipient
implements DeploymentResultAwareNotificationRecipient,
NotificationRecipient.RequiresPlan,
NotificationRecipient.RequiresResultSummary,
NotificationRecipient.RequiresEvent {
    private static final Logger log = Logger.getLogger(HipchatNotificationRecipient.class);
    @VisibleForTesting
    static String API_TOKEN = "apiToken";
    @VisibleForTesting
    static String ROOM = "room";
    @VisibleForTesting
    static String NOTIFY_USERS = "notifyUsers";
    private String apiToken = null;
    private String room = null;
    private boolean notify = false;
    private TemplateRenderer templateRenderer;
    private ImmutablePlan plan;
    private ResultsSummary resultsSummary;
    private DeploymentResult deploymentResult;
    private Event event;
    private CustomVariableContext customVariableContext;

    public void populate(@NotNull Map<String, String[]> params) {
        for (String next : params.keySet()) {
            System.out.println("next = " + next);
        }
        if (params.containsKey(API_TOKEN)) {
            this.apiToken = params.get(API_TOKEN)[0];
        }
        if (params.containsKey(ROOM)) {
            this.room = params.get(ROOM)[0];
        }
        this.notify = params.containsKey(NOTIFY_USERS);
    }

    public void init(@Nullable String configurationData) {
        if (configurationData != null) {
            try {
                this.parseConfiguration(configurationData);
            }
            catch (Exception e) {
                log.info((Object)"Can't parse configuration data", (Throwable)e);
            }
        }
    }

    private void parseConfiguration(@Nullable String configurationData) {
        HipchatRecipientConfiguration config = HipchatRecipientConfiguration.parse(configurationData);
        this.apiToken = config.getApiToken();
        this.room = config.getRoom();
        this.notify = config.isNotify();
    }

    @NotNull
    public String getRecipientConfig() {
        return this.apiToken + '|' + String.valueOf(this.notify) + '|' + this.room;
    }

    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = ((NotificationRecipientModuleDescriptor)this.getModuleDescriptor()).getEditTemplate();
        return this.templateRenderer.render(editTemplateLocation, this.populateContext());
    }

    private Map<String, Object> populateContext() {
        HashMap context = Maps.newHashMap();
        if (this.apiToken != null) {
            context.put(API_TOKEN, this.apiToken);
        }
        if (this.room != null) {
            context.put(ROOM, this.room);
        }
        context.put(NOTIFY_USERS, this.notify);
        return context;
    }

    @NotNull
    public String getViewHtml() {
        String editTemplateLocation = ((NotificationRecipientModuleDescriptor)this.getModuleDescriptor()).getViewTemplate();
        return this.templateRenderer.render(editTemplateLocation, this.populateContext());
    }

    @NotNull
    public List<NotificationTransport> getTransports() {
        final ArrayList list = Lists.newArrayList();
        VariableSubstitutorFactory variableSubstitutorFactory = this.customVariableContext.getVariableSubstitutorFactory();
        VariableSubstitutor variableSubstitutor = this.plan != null ? variableSubstitutorFactory.newSubstitutorForPlan(this.plan) : variableSubstitutorFactory.newSubstitutorForGlobalContext();
        this.customVariableContext.withVariableSubstitutor(variableSubstitutor, new Runnable(){

            @Override
            public void run() {
                list.add(new HipchatNotificationTransport(HipchatNotificationRecipient.this.customVariableContext.substituteString(HipchatNotificationRecipient.this.apiToken), HipchatNotificationRecipient.this.customVariableContext.substituteString(HipchatNotificationRecipient.this.room), HipchatNotificationRecipient.this.notify, HipchatNotificationRecipient.this.resultsSummary, HipchatNotificationRecipient.this.deploymentResult));
            }
        });
        return list;
    }

    public void setEvent(@Nullable Event event) {
        this.event = event;
    }

    public void setPlan(@Nullable Plan plan) {
        this.plan = plan;
    }

    public void setPlan(@Nullable ImmutablePlan plan) {
        this.plan = plan;
    }

    public void setDeploymentResult(@Nullable DeploymentResult deploymentResult) {
        this.deploymentResult = deploymentResult;
    }

    public void setResultsSummary(@Nullable ResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

