/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.service;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.docker.RepositoryKey;
import com.atlassian.bamboo.plugins.docker.RepositoryKeys;
import com.atlassian.bamboo.plugins.docker.client.BuildConfig;
import com.atlassian.bamboo.plugins.docker.client.Docker;
import com.atlassian.bamboo.plugins.docker.config.BuildConfiguration;
import com.atlassian.bamboo.plugins.docker.service.DockerService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class BuildService
implements DockerService {
    private final Docker docker;

    public BuildService(Docker docker) {
        this.docker = docker;
    }

    @Override
    public void execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        BuildLogger logger = taskContext.getBuildLogger();
        BuildConfiguration buildConfig = BuildConfiguration.fromContext(taskContext);
        if (buildConfig.isDockerfileInline()) {
            this.writeDockerfile(buildConfig);
        }
        try {
            this.docker.build(taskContext.getWorkingDirectory(), buildConfig.getRepository(), BuildConfig.builder().nocache(buildConfig.isNocache()).build());
            logger.addBuildLogEntry(String.format("Built Docker image '%s'", buildConfig.getRepository()));
            if (buildConfig.isSave()) {
                RepositoryKey repositoryKey = RepositoryKeys.parseKey(buildConfig.getRepository());
                this.docker.save(buildConfig.getFilename(), repositoryKey.getEncodedRepositoryString());
                logger.addBuildLogEntry(String.format("Saved Docker image '%s' to file '%s'", buildConfig.getRepository(), new File(taskContext.getWorkingDirectory(), buildConfig.getFilename()).getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
    }

    private void writeDockerfile(@NotNull BuildConfiguration config) throws TaskException {
        try {
            File dockerFile = new File(config.getWorkingDirectory(), "Dockerfile");
            Files.write((CharSequence)config.getDockerfile(), (File)dockerFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TaskException("Unable to create Dockerfile", (Throwable)e);
        }
    }
}

