/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.export;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.DockerBuildImageTask;
import com.atlassian.bamboo.specs.model.task.docker.AbstractDockerTaskProperties;
import com.atlassian.bamboo.specs.model.task.docker.DockerBuildImageTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class BuildImageTaskExporter
implements TaskDefinitionExporter {
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        DockerBuildImageTaskProperties properties = (DockerBuildImageTaskProperties)Narrow.downTo((Object)taskProperties, DockerBuildImageTaskProperties.class);
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)("Don't now how to import " + taskProperties.getClass().getCanonicalName()));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"commandOption", (Object)"build");
        builder.put((Object)"repository", (Object)properties.getImageName());
        switch (properties.getDockerfileContent()) {
            case INLINE: {
                builder.put((Object)"dockerfileOption", (Object)"inline");
                builder.put((Object)"dockerfile", (Object)StringUtils.defaultString((String)properties.getDockerfile()));
                break;
            }
            case WORKING_DIR: {
                builder.put((Object)"dockerfileOption", (Object)"existing");
                break;
            }
            default: {
                throw new IllegalStateException("Couldn't handle: " + properties.getDockerfileContent());
            }
        }
        builder.put((Object)"nocache", (Object)String.valueOf(!properties.isUseCache()));
        builder.put((Object)"save", (Object)String.valueOf(properties.isSaveAsFile()));
        builder.put((Object)"filename", (Object)StringUtils.defaultString((String)properties.getImageFilename()));
        builder.put((Object)"environmentVariables", (Object)StringUtils.defaultString((String)properties.getEnvironmentVariables()));
        builder.put((Object)"workingSubDirectory", (Object)StringUtils.defaultString((String)properties.getWorkingSubdirectory()));
        return builder.build();
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        if (this.isDockerBuildTask(taskDefinition)) {
            Map config = taskDefinition.getConfiguration();
            DockerBuildImageTask dockerTask = (DockerBuildImageTask)((DockerBuildImageTask)new DockerBuildImageTask().imageName(config.getOrDefault("repository", "")).workingSubdirectory(config.getOrDefault("workingSubDirectory", ""))).environmentVariables(config.getOrDefault("environmentVariables", ""));
            switch (config.getOrDefault("dockerfileOption", "")) {
                case "inline": {
                    dockerTask.dockerfile(config.getOrDefault("dockerfile", ""));
                    break;
                }
                case "existing": {
                    dockerTask.dockerfileInWorkingDir();
                    break;
                }
                default: {
                    throw new IllegalStateException("Couldn't handle: " + config.getOrDefault("dockerfileOption", ""));
                }
            }
            boolean noCache = Boolean.parseBoolean(config.getOrDefault("nocache", "false"));
            dockerTask.useCache(!noCache);
            boolean saveAsFile = Boolean.parseBoolean(config.getOrDefault("save", "false"));
            dockerTask.saveAsFile(saveAsFile);
            dockerTask.imageFilename(config.getOrDefault("filename", ""));
            return dockerTask;
        }
        throw new IllegalArgumentException(String.format("Couldn't export task by id: %s and plugin key: %s", taskDefinition.getId(), taskDefinition.getPluginKey()));
    }

    private boolean isDockerBuildTask(@NotNull TaskDefinition taskDefinition) {
        return taskDefinition.getPluginKey().equals(AbstractDockerTaskProperties.MODULE_KEY.getCompleteModuleKey()) && "build".equals(taskDefinition.getConfiguration().get("commandOption"));
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return Collections.emptyList();
    }
}

