/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.client;

import com.atlassian.bamboo.plugins.docker.client.DataVolume;
import com.atlassian.bamboo.plugins.docker.client.PortMapping;
import com.atlassian.fugue.Option;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public class RunConfig {
    private final Option<String> command;
    private final Option<String> containerName;
    private final ImmutableList<PortMapping> ports;
    private final ImmutableList<DataVolume> volumes;
    private final Option<String> workDir;
    private final boolean detach;
    private final ImmutableMap<String, String> links;
    private final ImmutableMap<String, String> env;
    private ImmutableList<String> passedEnv;
    private final Option<String> additionalArgs;

    private RunConfig(@NotNull Builder builder) {
        this.command = builder.command;
        this.containerName = builder.containerName;
        this.ports = ImmutableList.copyOf((Collection)builder.ports);
        this.volumes = ImmutableList.copyOf((Collection)builder.volumes);
        this.workDir = builder.workDir;
        this.detach = builder.detach;
        this.links = ImmutableMap.copyOf((Map)builder.links);
        this.env = ImmutableMap.copyOf((Map)builder.env);
        this.passedEnv = ImmutableList.copyOf((Collection)builder.passedEnv);
        this.additionalArgs = builder.additionalArgs;
    }

    @NotNull
    public Option<String> getCommand() {
        return this.command;
    }

    @NotNull
    public Option<String> getContainerName() {
        return this.containerName;
    }

    @NotNull
    public List<PortMapping> getPorts() {
        return this.ports;
    }

    @NotNull
    public List<DataVolume> getVolumes() {
        return this.volumes;
    }

    @NotNull
    public Option<String> getWorkDir() {
        return this.workDir;
    }

    public boolean isDetach() {
        return this.detach;
    }

    @NotNull
    public Map<String, String> getLinks() {
        return this.links;
    }

    @NotNull
    public Map<String, String> getEnv() {
        return this.env;
    }

    @NotNull
    public List<String> getPassedEnv() {
        return this.passedEnv;
    }

    @NotNull
    public Option<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Option<String> command = Option.none();
        private Option<String> containerName = Option.none();
        private List<PortMapping> ports = Collections.emptyList();
        private List<DataVolume> volumes = Collections.emptyList();
        private Option<String> workDir = Option.none();
        private boolean detach = false;
        private Map<String, String> links = Collections.emptyMap();
        private Map<String, String> env = Collections.emptyMap();
        private List<String> passedEnv = Collections.emptyList();
        private Option<String> additionalArgs = Option.none();

        private Builder() {
        }

        @NotNull
        public Builder command(@NotNull String command) {
            this.command = Option.some((Object)command);
            return this;
        }

        @NotNull
        public Builder containerName(@NotNull String containerName) {
            this.containerName = Option.some((Object)containerName);
            return this;
        }

        @NotNull
        public Builder ports(@NotNull List<PortMapping> ports) {
            this.ports = ports;
            return this;
        }

        @NotNull
        public Builder volumes(@NotNull List<DataVolume> volumes) {
            this.volumes = volumes;
            return this;
        }

        @NotNull
        public Builder workDir(@NotNull String workDir) {
            this.workDir = Option.some((Object)workDir);
            return this;
        }

        @NotNull
        public Builder detach(boolean detach) {
            this.detach = detach;
            return this;
        }

        @NotNull
        public Builder links(@NotNull Map<String, String> links) {
            this.links = links;
            return this;
        }

        @NotNull
        public Builder env(@NotNull Map<String, String> env) {
            this.env = env;
            return this;
        }

        @NotNull
        public Builder passedEnv(List<String> dockerEnv) {
            this.passedEnv = dockerEnv;
            return this;
        }

        @NotNull
        public Builder additionalArgs(@NotNull String additionalArgs) {
            this.additionalArgs = Option.some((Object)additionalArgs);
            return this;
        }

        @NotNull
        public RunConfig build() {
            return new RunConfig(this);
        }
    }
}

