/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.client;

import com.atlassian.fugue.Option;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class AuthConfig {
    private final Option<String> registryAddress;
    private final Option<String> username;
    private final Option<String> password;
    private final Option<String> email;

    private AuthConfig(@NotNull Builder builder) {
        this.registryAddress = builder.registryAddress;
        this.username = builder.username;
        this.password = builder.password;
        this.email = builder.email;
    }

    public Option<String> getRegistryAddress() {
        return this.registryAddress;
    }

    @NotNull
    public Option<String> getUsername() {
        return this.username;
    }

    @NotNull
    public Option<String> getPassword() {
        return this.password;
    }

    @NotNull
    public Option<String> getEmail() {
        return this.email;
    }

    public boolean isAuthorisationProvided() {
        return !this.username.isEmpty();
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Option<String> registryAddress = Option.none();
        private Option<String> username = Option.none();
        private Option<String> password = Option.none();
        private Option<String> email = Option.none();

        private Builder() {
        }

        @NotNull
        public Builder registryAddress(@Nullable String registryAddress) {
            if (StringUtils.isNotBlank((CharSequence)registryAddress)) {
                this.registryAddress = Option.some((Object)registryAddress);
            }
            return this;
        }

        @NotNull
        public Builder username(@Nullable String username) {
            if (StringUtils.isNotBlank((CharSequence)username)) {
                this.username = Option.some((Object)username);
            }
            return this;
        }

        @NotNull
        public Builder password(@Nullable String password) {
            if (StringUtils.isNotBlank((CharSequence)password)) {
                this.password = Option.some((Object)password);
            }
            return this;
        }

        @NotNull
        public Builder email(@Nullable String email) {
            if (StringUtils.isNotBlank((CharSequence)email)) {
                this.email = Option.some((Object)email);
            }
            return this;
        }

        @NotNull
        public AuthConfig build() {
            return new AuthConfig(this);
        }
    }
}

