/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker;

import com.atlassian.bamboo.plugins.docker.RepositoryKey;
import com.atlassian.fugue.Option;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class RepositoryKeys {
    private static final String REGISTRY_MARKERS = ".:";

    @NotNull
    public static RepositoryKey parseKey(@NotNull String repositoryKey) {
        return new RepositoryKey.RepositoryKeyBuilder(RepositoryKeys.parseRepository(repositoryKey)).registry((String)RepositoryKeys.parseRegistry(repositoryKey).getOrNull()).namespace((String)RepositoryKeys.parseNamespace(repositoryKey).getOrNull()).tag((String)RepositoryKeys.parseTag(repositoryKey).getOrElse((Object)"latest")).build();
    }

    @NotNull
    private static Option<String> parseRegistry(@NotNull String repositoryKey) {
        if (RepositoryKeys.includesRegistry(repositoryKey)) {
            return Option.option((Object)StringUtils.substringBefore((String)repositoryKey, (String)"/"));
        }
        return Option.none();
    }

    @NotNull
    private static Option<String> parseNamespace(@NotNull String repositoryKey) {
        String namespaceRepositoryTag = RepositoryKeys.stripRegistry(repositoryKey);
        if (StringUtils.contains((CharSequence)namespaceRepositoryTag, (int)47)) {
            return Option.option((Object)StringUtils.substringBefore((String)namespaceRepositoryTag, (String)"/"));
        }
        return Option.none();
    }

    @NotNull
    private static String parseRepository(@NotNull String repositoryKey) {
        String namespaceRepositoryTag = RepositoryKeys.stripRegistry(repositoryKey);
        if (StringUtils.contains((CharSequence)namespaceRepositoryTag, (int)47)) {
            String repositoryAndTag = StringUtils.substringAfter((String)namespaceRepositoryTag, (String)"/");
            return StringUtils.substringBeforeLast((String)repositoryAndTag, (String)":");
        }
        return StringUtils.substringBeforeLast((String)namespaceRepositoryTag, (String)":");
    }

    @NotNull
    private static Option<String> parseTag(@NotNull String repositoryKey) {
        String namespaceRepositoryTag = RepositoryKeys.stripRegistry(repositoryKey);
        if (StringUtils.contains((CharSequence)namespaceRepositoryTag, (int)58)) {
            return Option.option((Object)StringUtils.substringAfterLast((String)namespaceRepositoryTag, (String)":"));
        }
        return Option.none();
    }

    @NotNull
    private static String stripRegistry(@NotNull String repositoryKey) {
        if (RepositoryKeys.includesRegistry(repositoryKey)) {
            return StringUtils.substringAfter((String)repositoryKey, (String)"/");
        }
        return repositoryKey;
    }

    private static boolean includesRegistry(@NotNull String repositoryKey) {
        if (StringUtils.contains((CharSequence)repositoryKey, (int)47)) {
            String registryOrNamespace = StringUtils.substringBefore((String)repositoryKey, (String)"/");
            return StringUtils.containsAny((CharSequence)registryOrNamespace, (CharSequence)REGISTRY_MARKERS);
        }
        return false;
    }
}

