/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.validation;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.docker.tasks.DockerTaskPredicates;
import com.atlassian.bamboo.plugins.docker.tasks.cli.DockerCliTaskConfigurator;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidator;
import com.atlassian.bamboo.task.TaskContextHelperService;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RunConfigValidator
implements ConfigValidator {
    private static final String TASK_ID = "taskId";
    private static final int MAX_PORT = 65535;
    private final I18nResolver i18nResolver;
    private final TaskContextHelperService taskContextHelper;

    public RunConfigValidator(@NotNull I18nResolver i18nResolver, @NotNull TaskContextHelperService taskContextHelper) {
        this.i18nResolver = i18nResolver;
        this.taskContextHelper = taskContextHelper;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isBlank((CharSequence)params.getString("image"))) {
            errorCollection.addError("image", this.i18nResolver.getText("docker.image.error.empty"));
        }
        if (params.getBoolean("detach")) {
            if (StringUtils.isBlank((CharSequence)params.getString("name"))) {
                errorCollection.addError("name", this.i18nResolver.getText("docker.name.error.empty"));
            } else if (!this.isNameUniqueInJob(params)) {
                errorCollection.addError("name", this.i18nResolver.getText("docker.name.error.duplicate"));
            }
            Map<String, String> hostPorts = this.getPorts(params, "hostPort_");
            Map<String, String> containerPorts = this.getPorts(params, "containerPort_");
            this.validatePorts(hostPorts, true, errorCollection);
            this.validatePorts(containerPorts, false, errorCollection);
            if (params.getBoolean("serviceWait")) {
                if (hostPorts.size() == 0) {
                    errorCollection.addError("serviceWait", this.i18nResolver.getText("docker.service.wait.error.ports"));
                }
                if (StringUtils.isBlank((CharSequence)params.getString("serviceUrlPattern"))) {
                    errorCollection.addError("serviceUrlPattern", this.i18nResolver.getText("docker.service.url.pattern.error.empty"));
                }
                if (!NumberUtils.isPositiveInteger((String)params.getString("serviceTimeout"))) {
                    errorCollection.addError("serviceTimeout", this.i18nResolver.getText("docker.service.timeout.error.invalid"));
                }
            }
        }
        this.validateVolumes(params, errorCollection);
    }

    private boolean isNameUniqueInJob(@NotNull ActionParametersMap params) {
        String name = params.getString("name");
        long taskId = params.getLong(TASK_ID, -1L);
        Predicate isDockerRunDetachedNameEqual = Predicates.and((Predicate[])new Predicate[]{DockerCliTaskConfigurator.isDockerRunDetachedTask, DockerTaskPredicates.isConfigurationFieldEqual("name", name), Predicates.not((Predicate)BambooPredicates.hasTaskDefinitionEqualId((long)taskId))});
        return Iterables.isEmpty((Iterable)Iterables.filter((Iterable)this.taskContextHelper.getTasks(params), (Predicate)isDockerRunDetachedNameEqual));
    }

    private Map<String, String> getPorts(@NotNull ActionParametersMap params, @NotNull String portPrefix) {
        ImmutableMap.Builder ports = ImmutableMap.builder();
        for (String portKey : Iterables.filter((Iterable)params.keySet(), TextPredicates.startsWith((String)portPrefix)::test)) {
            ports.put((Object)portKey, (Object)params.getString(portKey));
        }
        return ports.build();
    }

    private void validatePorts(@NotNull Map<String, String> ports, boolean optional, @NotNull ErrorCollection errorCollection) {
        HashSet<String> definedPorts = new HashSet<String>();
        for (Map.Entry<String, String> port : ports.entrySet()) {
            if (StringUtils.isBlank((CharSequence)port.getValue())) {
                if (!optional) {
                    errorCollection.addError(port.getKey(), this.i18nResolver.getText("docker.ports.container.error.empty"));
                }
            } else if (!NumberUtils.isPositiveInteger((String)port.getValue()) || Integer.parseInt(port.getValue()) > 65535) {
                errorCollection.addError(port.getKey(), this.i18nResolver.getText("docker.ports.error.invalid"));
            } else if (definedPorts.contains(port.getValue())) {
                errorCollection.addError(port.getKey(), this.i18nResolver.getText("docker.ports.error.duplicate"));
            }
            definedPorts.add(port.getValue());
        }
    }

    private Set<String> validateVolumes(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        HashSet<String> definedDataVolumes = new HashSet<String>();
        for (String key : Iterables.filter((Iterable)params.keySet(), TextPredicates.startsWith((String)"containerDataVolume_")::test)) {
            String containerDataVolume = params.getString(key);
            if (StringUtils.isBlank((CharSequence)containerDataVolume)) {
                errorCollection.addError(key, this.i18nResolver.getText("docker.volumes.containerDataVolume.error.empty"));
            } else if (definedDataVolumes.contains(containerDataVolume)) {
                errorCollection.addError(key, this.i18nResolver.getText("docker.volumes.containerDataVolume.error.duplicate"));
            }
            definedDataVolumes.add(containerDataVolume);
        }
        return definedDataVolumes;
    }
}

