/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.validation;

import com.atlassian.bamboo.plugins.docker.validation.BuildConfigValidator;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidator;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidatorFactory;
import com.atlassian.bamboo.plugins.docker.validation.PullConfigValidator;
import com.atlassian.bamboo.plugins.docker.validation.PushConfigValidator;
import com.atlassian.bamboo.plugins.docker.validation.RunConfigValidator;
import com.atlassian.bamboo.task.TaskContextHelperService;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.sal.api.message.I18nResolver;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent(value="validationFactory")
public class ConfigValidatorFactoryImpl
implements ConfigValidatorFactory {
    private final TaskContextHelperService taskContextHelper;
    private final I18nResolver i18nResolver;

    @Autowired
    public ConfigValidatorFactoryImpl(@BambooImport TaskContextHelperService taskContextHelper, @BambooImport I18nResolver i18nResolver) {
        this.taskContextHelper = taskContextHelper;
        this.i18nResolver = i18nResolver;
    }

    @Override
    @NotNull
    public ConfigValidator create(@NotNull String dockerCommandOption) {
        if ("build".equals(dockerCommandOption)) {
            return new BuildConfigValidator(this.i18nResolver);
        }
        if ("run".equals(dockerCommandOption)) {
            return new RunConfigValidator(this.i18nResolver, this.taskContextHelper);
        }
        if ("push".equals(dockerCommandOption)) {
            return new PushConfigValidator(this.i18nResolver);
        }
        if ("pull".equals(dockerCommandOption)) {
            return new PullConfigValidator(this.i18nResolver);
        }
        throw new IllegalArgumentException("No validation service for option " + dockerCommandOption);
    }
}

