/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker;

import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomBuildDataHelper {
    private static final String DEPLOYED_SERVICE_URL = "deployedServiceUrl";
    private static final String RUN_CONTAINER_NAMES = "dockerContainerNames";

    public static void setDeployedServiceUrl(@NotNull Map<String, String> customData, @NotNull String deployedServiceUrl) {
        customData.put(DEPLOYED_SERVICE_URL, deployedServiceUrl);
    }

    @Nullable
    public String getDeployedServiceURL(@NotNull Map<String, String> customData) {
        return customData.get(DEPLOYED_SERVICE_URL);
    }

    public static void registerContainer(@NotNull VariableContext variableContext, @NotNull String name) {
        Map effectiveVariables = variableContext.getEffectiveVariables();
        VariableDefinitionContext variableDefinitionContext = (VariableDefinitionContext)effectiveVariables.get(RUN_CONTAINER_NAMES);
        String currentRunContainerNames = variableDefinitionContext != null ? variableDefinitionContext.getValue() : "";
        String newRunContainerNames = StringUtils.join((Object[])new Serializable[]{currentRunContainerNames, Character.valueOf(' '), name}).trim();
        variableContext.addLocalVariable(RUN_CONTAINER_NAMES, newRunContainerNames);
    }

    @NotNull
    public static Iterable<String> getDetachedContainers(@NotNull VariableContext variableContext) {
        String containerNames;
        Map effectiveVariables = variableContext.getEffectiveVariables();
        if (effectiveVariables.containsKey(RUN_CONTAINER_NAMES) && StringUtils.isNotBlank((CharSequence)(containerNames = ((VariableDefinitionContext)effectiveVariables.get(RUN_CONTAINER_NAMES)).getValue()))) {
            return Splitter.on((char)' ').split((CharSequence)containerNames);
        }
        return Collections.emptySet();
    }
}

