/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.BambooTrustedKeyServerKeyVerifier;
import com.atlassian.bamboo.plugins.ssh.SshClientAndServerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;

public class DefaultSshClientAndServerFactory
implements SshClientAndServerFactory {
    public static final DefaultSshClientAndServerFactory INSTANCE = new DefaultSshClientAndServerFactory();
    private final ClientBuilder sshClientBuilder = ClientBuilder.builder().hostConfigEntryResolver(HostConfigEntryResolver.EMPTY).serverKeyVerifier((ServerKeyVerifier)BambooTrustedKeyServerKeyVerifier.INSTANCE);
    private final ServerBuilder sshServerBuilder = ServerBuilder.builder();
    private final long authTimeout = TimeUnit.MINUTES.toMillis(2L);
    private final long idleTimeout = TimeUnit.MINUTES.toMillis(2L);

    private DefaultSshClientAndServerFactory() {
    }

    @Override
    public SshClient createSshClient() {
        SshClient sshClient = (SshClient)this.sshClientBuilder.build();
        sshClient.getProperties().put("auth-timeout", Long.toString(this.authTimeout));
        sshClient.getProperties().put("idle-timeout", Long.toString(this.idleTimeout));
        return sshClient;
    }

    @Override
    public SshServer createSshServer() {
        return (SshServer)this.sshServerBuilder.build();
    }
}

