/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.bamboo.plugins.ssh.SshProxy;
import com.atlassian.bamboo.util.Narrow;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.jetbrains.annotations.NotNull;

class ClasspathKeyPairProvider
extends AbstractKeyPairProvider {
    private static final String PROXY_SERVER_KEY_PEM = "proxy-server-key.pem";
    private static final Logger log = Logger.getLogger(ClasspathKeyPairProvider.class);
    private final Iterable<KeyPair> keyPair = ClasspathKeyPairProvider.loadServerKey();

    ClasspathKeyPairProvider() {
    }

    public Iterable<KeyPair> loadKeys() {
        return this.keyPair;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Iterable<KeyPair> loadServerKey() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            log.error((Object)"Bouncycastle not registered, cannot read keys");
            return Collections.emptyList();
        }
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(SshProxy.class.getResourceAsStream(PROXY_SERVER_KEY_PEM)));){
            Object object = pemParser.readObject();
            PEMKeyPair pemKeyPair = (PEMKeyPair)Narrow.downTo((Object)object, PEMKeyPair.class);
            if (pemKeyPair != null) {
                Set<KeyPair> set = Collections.singleton(BouncyCastleProviderUtils.toJavaKeyPair((PEMKeyPair)pemKeyPair));
                return set;
            }
            throw new IllegalArgumentException("Don't know how to handle proxy-server-key.pem of type " + object.getClass().getCanonicalName());
        }
        catch (IOException e) {
            log.error((Object)"Cannot read host key", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

