/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.ProxyConnectionDataBuilderImpl;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfig {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Logger log = Logger.getLogger(SshConfig.class);
    public static final File SSH_DIRECTORY = new File(SystemUtils.USER_HOME, ".ssh");
    public static final File ID_RSA = new File(SSH_DIRECTORY, "id_rsa");
    public static final File ID_DSA = new File(SSH_DIRECTORY, "id_dsa");
    public static final File ID_ECDSA = new File(SSH_DIRECTORY, "id_ecdsa");
    public static final File[] KNOWN_PRIVATE_KEY_LOCATIONS = new File[]{ID_RSA, ID_DSA, ID_ECDSA};
    Collection<HostSection> hostSections = new ArrayList<HostSection>();
    private Collection<Pair<File, Long>> parsedFiles = new ArrayList<Pair<File, Long>>();

    public SshConfig(File ... sshConfigs) throws IOException {
        this.parse(sshConfigs);
    }

    public ProxyConnectionData apply(ProxyConnectionData connectionData, @Nullable String defaultUserName) throws IOException {
        Pair<File, KeyPair> privateKey;
        ProxyConnectionDataBuilderImpl newConnectionData = new ProxyConnectionDataBuilderImpl();
        boolean isPortSet = connectionData.getRemotePort() != null;
        boolean isUserSet = StringUtils.isNotBlank((CharSequence)connectionData.getRemoteUserName());
        boolean isHostnameSet = false;
        boolean isIdentityFileSet = connectionData.getKeyPair() != null;
        newConnectionData.withProxyConnectionData(connectionData);
        for (HostSection hostSection : this.hostSections) {
            if (!hostSection.doesScopeMatch(connectionData.getRemoteHost())) continue;
            String matchDescription = null;
            if (log.isDebugEnabled()) {
                matchDescription = connectionData.getRemoteHost() + " matched: " + hostSection.getPatternFromConfigFile();
            }
            for (KeywordAndArgument keywordAndArgument : hostSection.getKeywordsAndArguments()) {
                String argument = keywordAndArgument.getArgument();
                if (keywordAndArgument.isPort() && !isPortSet) {
                    newConnectionData.withRemotePort(Integer.valueOf(argument));
                    log.debug((Object)(matchDescription + ", setting port to [" + argument + "]"));
                    isPortSet = true;
                    continue;
                }
                if (keywordAndArgument.isUser() && !isUserSet) {
                    newConnectionData.withRemoteUserName(argument);
                    log.debug((Object)(matchDescription + ", setting user to [" + argument + "]"));
                    isUserSet = true;
                    continue;
                }
                if (keywordAndArgument.isHostname() && !isHostnameSet) {
                    String host = argument.replaceAll("%h", connectionData.getRemoteHost());
                    newConnectionData.withRemoteHost(host);
                    log.debug((Object)(matchDescription + ", setting host to [" + host + "]"));
                    isHostnameSet = true;
                    continue;
                }
                if (!keywordAndArgument.isIdentityFile() || isIdentityFileSet) continue;
                newConnectionData.withKeyFromFile(argument, null);
                log.debug((Object)(matchDescription + ", setting key file to [" + argument + "]"));
                isIdentityFileSet = true;
            }
        }
        if (!isUserSet) {
            newConnectionData.withRemoteUserName(defaultUserName);
        }
        if (!isPortSet) {
            newConnectionData.withRemotePort(22);
        }
        if (!isIdentityFileSet && connectionData.getKeyPair() == null && StringUtils.isEmpty((CharSequence)connectionData.getRemotePassword()) && (privateKey = this.findUserPrivateKey()) != null) {
            log.debug((Object)("No password and private key set in configuration, using private key: " + privateKey.first));
            newConnectionData.withKeyPair((KeyPair)privateKey.second);
        }
        return newConnectionData.build();
    }

    @Nullable
    private Pair<File, KeyPair> findUserPrivateKey() {
        for (File privateKeyFile : KNOWN_PRIVATE_KEY_LOCATIONS) {
            KeyPair keyPair = this.loadKey(privateKeyFile);
            if (keyPair == null) continue;
            return Pair.make((Object)privateKeyFile, (Object)keyPair);
        }
        return null;
    }

    @Nullable
    private KeyPair loadKey(@NotNull File privateKey) {
        if (!privateKey.canRead()) {
            log.warn((Object)("No read permission to: " + privateKey));
            return null;
        }
        FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(privateKey.toPath());
        Iterable availableKeyPairs = fileKeyPairProvider.loadKeys();
        return (KeyPair)Iterables.getOnlyElement((Iterable)availableKeyPairs, null);
    }

    private void parse(File ... sshConfigs) throws IOException {
        this.parsedFiles = new ArrayList<Pair<File, Long>>();
        this.hostSections = new ArrayList<HostSection>();
        for (File sshConfig : sshConfigs) {
            if (!sshConfig.canRead()) continue;
            this.parsedFiles.add((Pair<File, Long>)Pair.make((Object)sshConfig, (Object)sshConfig.lastModified()));
            this.hostSections.addAll(SshConfig.parseFile(sshConfig));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<HostSection> parseFile(File sshConfig) throws IOException {
        HostSection currentScope = new HostSection("*");
        ArrayList hostSections = Lists.newArrayList((Object[])new HostSection[]{currentScope});
        try (LineIterator lineIterator = FileUtils.lineIterator((File)sshConfig);){
            while (lineIterator.hasNext()) {
                String line = lineIterator.next().trim();
                if (StringUtils.isBlank((CharSequence)line) || line.startsWith("#")) continue;
                KeywordAndArgument keywordAndArgument = SshConfig.splitIntoKeywordArguments(line);
                if (keywordAndArgument == null) {
                    log.info((Object)("Skipping line: " + line));
                    continue;
                }
                if (keywordAndArgument.isHost()) {
                    currentScope = new HostSection(keywordAndArgument.getArgument());
                    hostSections.add(currentScope);
                    continue;
                }
                currentScope.add(keywordAndArgument);
            }
        }
        return hostSections;
    }

    @Nullable
    private static KeywordAndArgument splitIntoKeywordArguments(String line) {
        String[] keywordAndArguments = WHITESPACE.split(line, 2);
        if (keywordAndArguments.length != 2) {
            return null;
        }
        String keyword = keywordAndArguments[0];
        return new KeywordAndArgument(keyword, keywordAndArguments[1]);
    }

    public static SshConfig getDefaultSshConfig() throws IOException {
        return new SshConfig(new File(SystemUtils.getUserHome(), ".ssh/config"), new File("/etc/ssh/ssh_config"));
    }

    public Collection<Pair<File, Long>> getParsedFiles() {
        return this.parsedFiles;
    }

    static class HostSection {
        private final Pattern hostPattern;
        private final Pattern negatedHostPattern;
        private final Collection<KeywordAndArgument> keywordsAndArguments = new ArrayList<KeywordAndArgument>();
        private final String patternFromConfigFile;

        public HostSection(String arguments) {
            this.patternFromConfigFile = arguments;
            StringBuilder negatedPatterns = new StringBuilder();
            StringBuilder normalPatterns = new StringBuilder();
            Iterable patterns = Splitter.on((String)" ").split((CharSequence)arguments);
            for (String pattern : patterns) {
                if (pattern.startsWith("!")) {
                    negatedPatterns.append(pattern.substring(1)).append(" ");
                    continue;
                }
                normalPatterns.append(pattern).append(" ");
            }
            this.negatedHostPattern = this.createPattern(negatedPatterns);
            this.hostPattern = this.createPattern(normalPatterns);
        }

        private Pattern createPattern(StringBuilder pattern) {
            String negatedRegex = pattern.toString().replace(".", "\\.").replace("?", ".").replace("*", ".*").replace(" ", "|");
            return Pattern.compile(negatedRegex);
        }

        public boolean doesScopeMatch(@NotNull String destinationHost) {
            return !this.matches(this.negatedHostPattern, destinationHost) && this.matches(this.hostPattern, destinationHost);
        }

        private boolean matches(@NotNull Pattern patern, @NotNull String string) {
            return patern.matcher(string).matches();
        }

        public void add(KeywordAndArgument keywordAndArgument) {
            this.keywordsAndArguments.add(keywordAndArgument);
        }

        public Collection<KeywordAndArgument> getKeywordsAndArguments() {
            return this.keywordsAndArguments;
        }

        public String toString() {
            return this.hostPattern.toString();
        }

        public String getPatternFromConfigFile() {
            return this.patternFromConfigFile;
        }
    }

    private static class KeywordAndArgument {
        private final String keyword;
        private final String[] arguments;
        private final boolean isHost;
        private final boolean isPort;
        private final boolean isUser;
        private final boolean isHostname;
        private final boolean isIdentityFile;

        public KeywordAndArgument(String keyword, String arguments) {
            this.keyword = keyword;
            this.arguments = new String[]{arguments};
            this.isIdentityFile = this.keywordMatches("IdentityFile");
            this.isHost = KeywordAndArgument.isHost(keyword);
            this.isPort = this.keywordMatches("port");
            this.isUser = this.keywordMatches("user");
            this.isHostname = this.keywordMatches("hostname");
        }

        public String[] getArguments() {
            return this.arguments;
        }

        @Nullable
        public String getArgument() {
            if (this.arguments.length == 0) {
                return null;
            }
            if (this.arguments.length > 1) {
                throw new IllegalArgumentException("Exepcted a single argument: " + Arrays.toString(this.arguments));
            }
            return this.arguments[0];
        }

        public boolean isHost() {
            return this.isHost;
        }

        public boolean isPort() {
            return this.isPort;
        }

        public boolean isUser() {
            return this.isUser;
        }

        public boolean isHostname() {
            return this.isHostname;
        }

        public boolean isIdentityFile() {
            return this.isIdentityFile;
        }

        private boolean keywordMatches(String string) {
            return KeywordAndArgument.keywordMatches(string, this.keyword);
        }

        private static boolean keywordMatches(String keyword, @NotNull String string) {
            return string.equalsIgnoreCase(keyword);
        }

        public static boolean isHost(String keyword) {
            return KeywordAndArgument.keywordMatches(keyword, "host");
        }
    }
}

