/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.PlainTextPasswordFinder;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataBuilder;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.bamboo.ssh.ProxyException;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyConnectionDataBuilderImpl
implements ProxyConnectionDataBuilder {
    private static final Logger log = Logger.getLogger(ProxyConnectionDataBuilderImpl.class);
    private String remoteUserName;
    private KeyPair keyPair;
    private SocketAddress remoteAddress;
    private ProxyErrorReceiver proxyErrorReceiver;
    private String remotePassword;
    private String mapPathFrom;
    private String mapPathTo;
    private String connectionDescription;

    public ProxyConnectionDataBuilder withRemoteUserName(String name) {
        this.remoteUserName = name;
        return this;
    }

    public ProxyConnectionDataBuilder withKeyFromFile(String filePath, @Nullable String passphrase) throws IOException {
        return this.withKeyFromProvider((KeyPairProvider)new FileKeyPairProvider(new String[]{filePath}, (PasswordFinder)new PlainTextPasswordFinder(passphrase)));
    }

    public ProxyConnectionDataBuilder withKeyFromString(String key, @Nullable String passphrase) throws IOException {
        return this.withKeyFromReader(new CharArrayReader(key.toCharArray()), passphrase);
    }

    public ProxyConnectionDataBuilder withRemotePathMapping(@NotNull String from, @NotNull String to) throws IOException {
        this.mapPathFrom = from;
        this.mapPathTo = to;
        return this;
    }

    public ProxyConnectionDataBuilder withConnectionDescription(@Nullable String connectionDescription) {
        this.connectionDescription = connectionDescription;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConnectionDataBuilder withKeyFromReader(Reader keyReader, @Nullable String passphrase) throws IOException {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IOException("Couldn't register Bouncy Castle as a JCE provider. Private key cannot be read");
        }
        PEMReader pemReader = new PEMReader(keyReader, (PasswordFinder)new PlainTextPasswordFinder(passphrase));
        try {
            this.keyPair = (KeyPair)pemReader.readObject();
        }
        finally {
            pemReader.close();
        }
        return this;
    }

    public ProxyConnectionDataBuilder withKeyFromProvider(KeyPairProvider keyPairProvider) throws IOException {
        KeyPair dsaKeyPair = keyPairProvider.loadKey("ssh-dss");
        KeyPair rsaKeyPair = keyPairProvider.loadKey("ssh-rsa");
        this.keyPair = dsaKeyPair != null ? dsaKeyPair : rsaKeyPair;
        return this;
    }

    public ProxyConnectionDataBuilder withRemoteAddress(String host, int port) {
        this.remoteAddress = new InetSocketAddress(host, port);
        return this;
    }

    public ProxyConnectionDataBuilder withErrorReceiver(ProxyErrorReceiver receiver) {
        this.proxyErrorReceiver = receiver;
        return this;
    }

    public ProxyConnectionDataBuilder withRemotePassword(String password) {
        this.remotePassword = password;
        return this;
    }

    public ProxyConnectionData build() throws ProxyException {
        if (this.keyPair == null && this.remotePassword == null) {
            throw new ProxyException("Neither ssh private key nor remote password is set");
        }
        if (StringUtils.isBlank((String)this.remoteUserName)) {
            this.remoteUserName = System.getProperty("user.name");
        }
        return new ProxyConnectionData(){

            public String getMapPathFrom() {
                return ProxyConnectionDataBuilderImpl.this.mapPathFrom;
            }

            public String getMapPathTo() {
                return ProxyConnectionDataBuilderImpl.this.mapPathTo;
            }

            public SocketAddress getRemoteAddress() {
                return ProxyConnectionDataBuilderImpl.this.remoteAddress;
            }

            public String getRemoteUserName() {
                return ProxyConnectionDataBuilderImpl.this.remoteUserName;
            }

            public KeyPair getKeyPair() {
                return ProxyConnectionDataBuilderImpl.this.keyPair;
            }

            public String getConnectionDescription() {
                return ProxyConnectionDataBuilderImpl.this.connectionDescription;
            }

            public String getRemotePassword() {
                return ProxyConnectionDataBuilderImpl.this.remotePassword;
            }

            public void reportProxyError(String message, Throwable exception) {
                if (ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver != null) {
                    ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver.reportProxyError(message, exception);
                }
            }
        };
    }
}

