/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class InstallSshClient {
    private static final Logger log = Logger.getLogger(InstallSshClient.class);
    public static final int BUFFER_SIZE = 4096;

    public static void install(@NotNull String bambooHome) {
        try {
            InstallSshClient.installFile("ssh.sh", new File(bambooHome, "ssh/bin/ssh.sh"));
            InstallSshClient.installFile("ssh.bat", new File(bambooHome, "ssh/bin/ssh.bat"));
            InstallSshClient.installFile("META-INF/lib/bcprov-jdk15-140.jar", new File(bambooHome, "ssh/lib/bcprov-jdk15-140.jar"));
            InstallSshClient.installFile("META-INF/lib/mina-core-2.0.2.jar", new File(bambooHome, "ssh/lib/mina-core-2.0.2.jar"));
            InstallSshClient.installFile("META-INF/lib/slf4j-api-1.5.8.jar", new File(bambooHome, "ssh/lib/slf4j-api-1.5.8.jar"));
            InstallSshClient.installFile("META-INF/lib/slf4j-simple-1.4.3.jar", new File(bambooHome, "ssh/lib/slf4j-simple-1.4.3.jar"));
            InstallSshClient.installFile("META-INF/lib/sshd-core-0.6.0.jar", new File(bambooHome, "ssh/lib/sshd-core-0.6.0.jar"));
            InstallSshClient.installFile("META-INF/lib/sshd-pam-0.6.0.jar", new File(bambooHome, "ssh/lib/sshd-pam-0.6.0.jar"));
            InstallSshClient.installFile("META-INF/lib/tomcat-apr-5.5.23.jar", new File(bambooHome, "ssh/lib/tomcat-apr-5.5.23.jar"));
        }
        catch (IOException e) {
            log.warn((Object)"", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installFile(@NotNull String resourceName, @NotNull File destinationPath) throws IOException {
        ClassLoader cl = InstallSshClient.class.getClassLoader();
        if (!destinationPath.getParentFile().exists() && !destinationPath.getParentFile().mkdirs()) {
            throw new IOException("Cannot create directory " + destinationPath.getParent());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(destinationPath);
        try {
            InstallSshClient.copyStream(cl.getResourceAsStream(resourceName), fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[4096];
            int totalCopied = 0;
            while ((n = inputStream.read(buffer)) != -1) {
                int prevMbCopied = totalCopied / 1024 / 1024;
                int curMbCopied = (totalCopied += n) / 1024 / 1024;
                if (prevMbCopied != curMbCopied && curMbCopied % 2 == 0) {
                    log.info((Object)(curMbCopied + " MB transferred"));
                }
                outputStream.write(buffer, 0, n);
            }
        }
        finally {
            outputStream.close();
        }
    }
}

