/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.api.GitConstants;
import com.atlassian.bamboo.plugins.git.api.GitRef;
import com.atlassian.bamboo.plugins.git.domain.GitHash;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitBambooSpecsHandler
extends AbstractGitExecutor
implements BambooSpecsHandler {
    private static final Logger log = Logger.getLogger(GitBambooSpecsHandler.class);

    @Inject
    public GitBambooSpecsHandler(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService);
    }

    @NotNull
    public Optional<String> detectSpecRevision(@NotNull VcsRepositoryData repositoryData, @NotNull Object source) throws RepositoryException {
        GitRef ref = OptionalNarrow.downTo((Object)source, GitRef.class).orElseGet(() -> OptionalNarrow.downTo((Object)source, String.class).map(branchName -> new GitRef(StringUtils.prependIfMissing((String)branchName, (CharSequence)GitConstants.R_HEADS, (CharSequence[])new CharSequence[0]))).orElseThrow(() -> new IllegalArgumentException("Can't detect Specs revision - unknown source: " + source)));
        GitRepositoryAccessData substitutedAccessData = this.toAccessData(repositoryData);
        GitOperationHelper helper = this.createGitOperationHelper(substitutedAccessData);
        File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
        Result result = (Result)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
            try {
                return Result.result(helper.obtainLatestRevision(cacheDirectory, ref, BAMBOO_SPECS_DIRECTORY));
            }
            catch (RepositoryException e) {
                return Result.exception((Throwable)e);
            }
        });
        return ((Optional)result.getResultThrowException()).map(GitHash::getValue);
    }

    public boolean isNewer(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.toAccessData(repositoryData);
        GitOperationHelper helper = this.createGitOperationHelper(substitutedAccessData);
        Path cacheDirectory = this.getCachePath(substitutedAccessData);
        String branchName = repositoryData.getBranch().getVcsBranch().getName();
        if (rev1.equals(rev2)) {
            return false;
        }
        try {
            if (helper.isAncestor(cacheDirectory, new GitHash(rev2), new GitHash(rev1))) {
                return true;
            }
            Optional<String> actualBranch = helper.getBranchForSha(this.getCacheDirectory(substitutedAccessData), rev2, branchName);
            if (!actualBranch.isPresent() || !actualBranch.get().equals(branchName)) {
                log.info((Object)("Commit " + rev2 + " not found on branch " + branchName + ". Assuming force push."));
                return true;
            }
        }
        catch (RepositoryException e) {
            log.info((Object)("Commit " + rev2 + " not found in the repository. Assuming force push or repository reconfigured."));
            return true;
        }
        return false;
    }

    @NotNull
    public List<CommitContext> findCommitsToSpecs(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.toAccessData(repositoryData);
        GitOperationHelper helper = this.createGitOperationHelper(substitutedAccessData);
        Path cacheDirectory = this.getCachePath(substitutedAccessData);
        File cacheDirectoryAsFile = this.getCacheDirectory(substitutedAccessData);
        boolean isAncestor = false;
        try {
            isAncestor = helper.isAncestor(cacheDirectory, new GitHash(rev1), new GitHash(rev2));
        }
        catch (RepositoryException e) {
            log.info((Object)("Commit " + rev1 + " not found in the repository. Assuming force push or repository reconfigured."));
        }
        if (!isAncestor) {
            return Collections.singletonList(helper.getCommit(cacheDirectoryAsFile, rev2));
        }
        return helper.extractCommits(cacheDirectoryAsFile, rev1, rev2, BAMBOO_SPECS_DIRECTORY).getChanges();
    }

    @NotNull
    private GitOperationHelper createGitOperationHelper(@NotNull GitRepositoryAccessData substitutedAccessData) throws RepositoryException {
        return GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
    }

    @NotNull
    private GitRepositoryAccessData toAccessData(@NotNull VcsRepositoryData repositoryData) {
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext();
        return (GitRepositoryAccessData)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.getSubstitutedAccessData(repositoryData));
    }

    public boolean isWebhookRequired() {
        return true;
    }
}

