/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.branch.VcsBranchIntegrationHelper;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.MergingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.NoContextVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.StatusProvidingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.UpdatingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitWorkingCopyManager
extends AbstractGitExecutor
implements MergingVcsWorkingCopyManager,
UpdatingVcsWorkingCopyManager,
NoContextVcsWorkingCopyManager,
StatusProvidingVcsWorkingCopyManager {
    private static boolean USE_SHALLOW_CLONES = new SystemProperty(false, new String[]{"atlassian.bamboo.git.useShallowClones", "ATLASSIAN_BAMBOO_GIT_USE_SHALLOW_CLONES"}).getValue(true);
    private final BuildLoggerManager buildLoggerManager;
    private final VcsBranchIntegrationHelper branchIntegrationHelper;

    @Inject
    public GitWorkingCopyManager(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService, BuildLoggerManager buildLoggerManager, VcsBranchIntegrationHelper branchIntegrationHelper) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService);
        this.buildLoggerManager = buildLoggerManager;
        this.branchIntegrationHelper = branchIntegrationHelper;
    }

    @NotNull
    public VcsWorkingCopy getWorkingCopyInfo(@NotNull VcsRepositoryData repositoryData, @NotNull File checkoutPath) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessDataBuilder(repositoryData).build();
        GitOperationHelper gitOperationHelper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        String currentRevision = gitOperationHelper.getCurrentRevision(checkoutPath);
        boolean isClean = gitOperationHelper.isClean(checkoutPath);
        return new VcsWorkingCopy(repositoryData.getId(), checkoutPath, currentRevision, !isClean);
    }

    @NotNull
    public VcsWorkingCopy retrieveSourceCode(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData targetRevision, @NotNull File targetPath) throws RepositoryException {
        return this.checkout(commonContext, repositoryData, targetRevision, targetPath, false);
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevision(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        return this.checkout(commonContext, repositoryData, null, targetPath, false);
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevision(@NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        return this.checkout(null, repositoryData, null, targetPath, false);
    }

    @NotNull
    public VcsWorkingCopy checkoutAndMerge(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull VcsBranch targetBranch, @NotNull PlanVcsRevisionData revisionOnTarget, @NotNull VcsBranch sourceBranch, final @NotNull PlanVcsRevisionData sourceRevision, @NotNull File targetPath) throws RepositoryException {
        GitOperationHelper connector;
        block7: {
            PlanVcsRevisionData tmp = new PlanVcsRevisionData(revisionOnTarget.getVcsRevisionKey(), revisionOnTarget.getCustomXmlData(), targetBranch);
            VcsWorkingCopy wcAfterCheckout = this.checkout(commonContext, vcsRepositoryData, tmp, targetPath, true);
            final BuildLogger buildLogger = this.buildLoggerManager.getLogger(commonContext.getResultKey());
            GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessDataBuilder(vcsRepositoryData).branch((VcsBranch)new VcsBranchImpl(this.substituteString(sourceBranch.getName()))).useShallowClones(false).build();
            connector = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver, this.trustedKeyHelper);
            final File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
            final HashAndSource hashAndSource = HashAndSource.hashAndBranch(sourceRevision.getVcsRevisionKey(), substitutedAccessData.getVcsBranch().getName());
            try {
                if (this.isOnLocalAgent() || substitutedAccessData.isUseRemoteAgentCache()) {
                    GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                connector.fetch(cacheDirectory, hashAndSource, false);
                                connector.checkRevisionExistsInCacheRepository(cacheDirectory, sourceRevision.getVcsRevisionKey());
                            }
                            catch (CancelException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                GitWorkingCopyManager.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
                                buildLogger.addBuildLogEntry(GitWorkingCopyManager.this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                                connector.fetch(cacheDirectory, hashAndSource, false);
                                buildLogger.addBuildLogEntry(GitWorkingCopyManager.this.i18nResolver.getText("repository.git.messages.rsRecover.fetchingCacheCompleted", new Serializable[]{cacheDirectory}));
                            }
                            return null;
                        }
                    });
                    break block7;
                }
                try {
                    connector.fetch(targetPath, hashAndSource, false);
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.rethrowOrRemoveDirectory(e, buildLogger, targetPath, "repository.git.messages.rsRecover.failedToFetchWorkingDir");
                    buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{targetPath}));
                    connector.fetch(targetPath, hashAndSource, false);
                }
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.runtimeException"), (Throwable)e);
            }
        }
        Pair<Boolean, String> result = connector.mergeAndReturnHead(targetPath, revisionOnTarget.getVcsRevisionKey(), sourceRevision.getVcsRevisionKey(), this.branchIntegrationHelper.getCommitterName(), this.branchIntegrationHelper.getCommitterEmail());
        return new VcsWorkingCopy(vcsRepositoryData.getId(), targetPath, (String)result.getSecond(), ((Boolean)result.getFirst()).booleanValue());
    }

    public boolean canDoMerge() {
        return GitOperationHelperFactory.isNativeGitEnabled(this);
    }

    @NotNull
    public Set<Requirement> getMergingRequirements() {
        return Sets.newHashSet((Object[])new Requirement[]{new RequirementImpl("system.git.executable", true, ".*", true)});
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private VcsWorkingCopy checkout(@Nullable CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @Nullable PlanVcsRevisionData planVcsRevisionData, @NotNull File sourceDirectory, boolean needsDeepClone) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private BuildLogger getBuildLogger(@Nullable CommonContext commonContext) {
        return commonContext != null ? this.buildLoggerManager.getLogger(commonContext.getResultKey()) : new NullBuildLogger();
    }

    public void stageChanges(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData repositoryData, @NotNull Collection<String> pathsToAdd) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        helper.stageChanges(workingCopy.getPath(), pathsToAdd);
    }

    @NotNull
    public VcsWorkingCopy commitLocal(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull String commitMessage) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        String commitHash = helper.commit(workingCopy.getPath(), commitMessage, this.branchIntegrationHelper.getCommitterName(), this.branchIntegrationHelper.getCommitterEmail());
        return new VcsWorkingCopy(workingCopy.getRepositoryId(), workingCopy.getPath(), commitHash);
    }

    @NotNull
    public VcsWorkingCopy updateRemote(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData vcsRepositoryData, @Nullable String commitMessage) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        helper.pushRevision(workingCopy.getPath(), workingCopy.getCurrentRevisionKey());
        return workingCopy;
    }

    private boolean isOnLocalAgent() {
        return AgentTypeHolder.get() == AgentType.LOCAL;
    }

    private /* synthetic */ String lambda$checkout$0(GitOperationHelper helper, File cacheDirectory, HashAndSource hashAndSource, BuildLogger buildLogger, @NotNull File sourceDirectory, String previousRevision) throws Exception {
        try {
            helper.fetch(cacheDirectory, hashAndSource, false);
            helper.checkRevisionExistsInCacheRepository(cacheDirectory, hashAndSource.getHash());
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
            helper.fetch(cacheDirectory, hashAndSource, false);
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.fetchingCacheCompleted", new Serializable[]{cacheDirectory}));
        }
        try {
            return helper.checkout(cacheDirectory, sourceDirectory, hashAndSource.getHash(), previousRevision);
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            this.rethrowOrRemoveDirectory(e, buildLogger, sourceDirectory, "repository.git.messages.rsRecover.failedToCheckout");
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{sourceDirectory}));
            String returnRevision = helper.checkout(cacheDirectory, sourceDirectory, hashAndSource.getHash(), null);
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.checkoutCompleted"));
            return returnRevision;
        }
    }
}

