/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.branch.VcsBranchIntegrationHelper;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitHubRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitRepositoryFacade;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.AdvancedConfigurationAwareRepository;
import com.atlassian.bamboo.repository.BranchInformationProvider;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.DeploymentAwareRepository;
import com.atlassian.bamboo.repository.PushCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.UniqueRevisionIdRepository;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubRepository
extends AbstractStandaloneRepository
implements AdvancedConfigurationAwareRepository,
BranchInformationProvider,
BranchMergingAwareRepository,
CachingAwareRepository,
CustomSourceDirectoryAwareRepository,
CustomVariableProviderRepository,
DeploymentAwareRepository,
GitRepositoryFacade,
PushCapableRepository,
UniqueRevisionIdRepository {
    private static final Logger log = Logger.getLogger(GitHubRepository.class);
    private GitRepository gitRepository = new GitRepository();
    private GitHubRepositoryAccessData accessData = new GitHubRepositoryAccessData();
    private I18nResolver i18nResolver;

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        super.setBuildDirectoryManager(buildDirectoryManager);
        this.getGitRepository().setBuildDirectoryManager(buildDirectoryManager);
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        super.setBuildLoggerManager(buildLoggerManager);
        this.getGitRepository().setBuildLoggerManager(buildLoggerManager);
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.getGitRepository().setI18nResolver(i18nResolver);
    }

    public void setTrustedKeyHelper(TrustedKeyHelper trustedKeyHelper) {
        this.getGitRepository().setTrustedKeyHelper(trustedKeyHelper);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        super.setCustomVariableContext(customVariableContext);
        this.getGitRepository().setCustomVariableContext(customVariableContext);
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.getGitRepository().setCapabilityContext(capabilityContext);
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.getGitRepository().setSshProxyService(sshProxyService);
    }

    public void setBranchIntegrationHelper(VcsBranchIntegrationHelper branchIntegrationHelper) {
        this.getGitRepository().setBranchIntegrationHelper(branchIntegrationHelper);
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        super.setTemplateRenderer(templateRenderer);
        this.getGitRepository().setTemplateRenderer(templateRenderer);
    }

    @NotNull
    public String getName() {
        return "GitHub";
    }

    public String getHost() {
        return null;
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitHubRepository) {
            GitHubRepository ghRepo = (GitHubRepository)repository;
            return !new EqualsBuilder().append((Object)this.getRepository(), (Object)ghRepo.getRepository()).append((Object)this.getBranch(), (Object)ghRepo.getBranch()).isEquals();
        }
        return true;
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty("repository.github.commandTimeout", (Object)String.valueOf(180));
        buildConfiguration.clearTree("repository.github.verbose.logs");
        buildConfiguration.clearTree("repository.github.fetch.whole.repository");
        buildConfiguration.clearTree("repository.github.lfs");
        buildConfiguration.setProperty("repository.github.useShallowClones", (Object)true);
        buildConfiguration.setProperty("repository.github.useRemoteAgentCache", (Object)false);
        buildConfiguration.clearTree("repository.github.useSubmodules");
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty("repository.github.username", (Object)buildConfiguration.getString("repository.github.username", "").trim());
        if (buildConfiguration.getBoolean("temporary.github.password.change")) {
            buildConfiguration.setProperty("repository.github.password", (Object)buildConfiguration.getString("repository.github.temporary.password"));
        }
        buildConfiguration.setProperty("repository.github.repository", (Object)buildConfiguration.getString("repository.github.repository", "").trim());
        buildConfiguration.setProperty("repository.github.branch", (Object)buildConfiguration.getString("repository.github.branch", "").trim());
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        GitHubRepositoryAccessData accessData = GitHubRepositoryAccessData.builder(this.getAccessData()).repository(config.getString("repository.github.repository")).username(config.getString("repository.github.username")).password(config.getString("repository.github.password")).branch((VcsBranch)new VcsBranchImpl(config.getString("repository.github.branch"))).useShallowClones(config.getBoolean("repository.github.useShallowClones")).useRemoteAgentCache(config.getBoolean("repository.github.useRemoteAgentCache", false)).useSubmodules(config.getBoolean("repository.github.useSubmodules")).commandTimeout(config.getInt("repository.github.commandTimeout", 180)).verboseLogs(config.getBoolean("repository.github.verbose.logs", false)).shouldFetchAllRefs(config.getBoolean("repository.github.fetch.whole.repository", false)).lfs(config.getBoolean("repository.github.lfs", false)).build();
        this.setAccessData(accessData);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty("repository.github.username", (Object)this.getUsername());
        configuration.setProperty("repository.github.password", (Object)this.getPassword());
        configuration.setProperty("repository.github.repository", (Object)this.getRepository());
        configuration.setProperty("repository.github.branch", (Object)this.getBranch());
        configuration.setProperty("repository.github.useShallowClones", (Object)this.isUseShallowClones());
        configuration.setProperty("repository.github.useRemoteAgentCache", (Object)this.isUseRemoteAgentCache());
        configuration.setProperty("repository.github.useSubmodules", (Object)this.isUseSubmodules());
        configuration.setProperty("repository.github.commandTimeout", (Object)this.getCommandTimeout());
        configuration.setProperty("repository.github.verbose.logs", (Object)this.getVerboseLogs());
        configuration.setProperty("repository.github.fetch.whole.repository", (Object)this.accessData.shouldFetchAllRefs());
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        if (StringUtils.isBlank((CharSequence)buildConfiguration.getString("repository.github.repository"))) {
            errorCollection.addError("repository.github.repository", this.i18nResolver.getText("repository.github.error.missingRepository"));
        }
        return errorCollection;
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        return this.getGitRepository().collectChangesForRevision(planKey, targetRevision);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.getGitRepository().collectChangesSinceLastBuild(planKey, lastVcsRevisionKey);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevision) throws RepositoryException {
        return this.getGitRepository().retrieveSourceCode(buildContext, vcsRevision, this.getSourceCodeDirectory(buildContext.getPlanResultKey().getPlanKey()));
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws RepositoryException {
        return this.getGitRepository().retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory, int depth) throws RepositoryException {
        return this.getGitRepository().retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory, depth);
    }

    public String getUsername() {
        return this.accessData.getUsername();
    }

    public String getRepository() {
        return this.accessData.getRepository();
    }

    public String getBranch() {
        return this.accessData.getVcsBranch().getName();
    }

    public boolean isUseShallowClones() {
        return this.accessData.isUseShallowClones();
    }

    public boolean isUseRemoteAgentCache() {
        return this.accessData.isUseRemoteAgentCache();
    }

    public String getPassword() {
        return this.accessData.getPassword();
    }

    public boolean isUseSubmodules() {
        return this.accessData.isUseSubmodules();
    }

    public int getCommandTimeout() {
        return this.accessData.getCommandTimeout();
    }

    public boolean getVerboseLogs() {
        return this.accessData.isVerboseLogs();
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@Nullable String context) throws RepositoryException {
        return this.getGitRepository().getOpenBranches(context);
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return this.accessData.getVcsBranch();
    }

    public void setVcsBranch(@NotNull VcsBranch vcsBranch) {
        this.setAccessData(GitHubRepositoryAccessData.builder(this.accessData).branch(vcsBranch).build());
    }

    public CacheId getCacheId(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        switch (cachableOperation) {
            case BRANCH_DETECTION: {
                return new CacheId((Repository)this, new String[]{this.getGitRepository().getAccessData().getRepositoryUrl()});
            }
        }
        return null;
    }

    public boolean isCachingSupportedFor(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return cachableOperation == CachingAwareRepository.CachableOperation.BRANCH_DETECTION;
    }

    public CommitContext getLastCommit() throws RepositoryException {
        return this.getGitRepository().getLastCommit();
    }

    public CommitContext getFirstCommit() throws RepositoryException {
        return this.getGitRepository().getFirstCommit();
    }

    public boolean mergeWorkspaceWith(@NotNull BuildContext buildContext, @NotNull File file, @NotNull String s) throws RepositoryException {
        return this.getGitRepository().mergeWorkspaceWith(buildContext, file, s);
    }

    public boolean isMergingSupported() {
        return this.getGitRepository().isMergingSupported();
    }

    public void pushRevision(@NotNull File file, @Nullable String s) throws RepositoryException {
        this.getGitRepository().pushRevision(file, s);
    }

    @NotNull
    public String commit(@NotNull File file, @NotNull String s) throws RepositoryException {
        return this.getGitRepository().commit(file, s);
    }

    public String getOptionDescription() {
        String capabilitiesLink = RequestCacheThreadLocal.getContextPath() + "/admin/agent/configureSharedLocalCapabilities.action";
        return this.i18nResolver.getText("repository.git.description", new Serializable[]{this.getGitRepository().getGitCapability(), capabilitiesLink});
    }

    public GitHubRepositoryAccessData getAccessData() {
        return this.accessData;
    }

    public void setAccessData(GitHubRepositoryAccessData gitHubAccessData) {
        this.accessData = gitHubAccessData;
        this.getGitRepository().setAccessData(GitRepositoryAccessData.builder(this.getGitRepository().getAccessData()).repositoryUrl("https://github.com/" + gitHubAccessData.getRepository() + ".git").username(gitHubAccessData.getUsername()).password(gitHubAccessData.getPassword()).branch(gitHubAccessData.getVcsBranch()).sshKey(null).sshPassphrase(null).authenticationType(GitAuthenticationType.PASSWORD).useShallowClones(gitHubAccessData.isUseShallowClones()).useSubmodules(gitHubAccessData.isUseSubmodules()).useRemoteAgentCache(gitHubAccessData.isUseRemoteAgentCache()).commandTimeout(gitHubAccessData.getCommandTimeout()).verboseLogs(gitHubAccessData.isVerboseLogs()).lfs(gitHubAccessData.isLfs()).shouldFetchAllRefs(gitHubAccessData.shouldFetchAllRefs()).build());
    }

    @Override
    public GitRepository getGitRepository() {
        return this.gitRepository;
    }

    public boolean usePollingForBranchDetection() {
        return true;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        return this.getGitRepository().getCustomVariables();
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables() {
        return this.getGitRepository().getPlanRepositoryVariables();
    }
}

