/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.plugins.git.AncestryPathOutputHandler;
import com.atlassian.bamboo.plugins.git.CommitOutputHandler;
import com.atlassian.bamboo.plugins.git.GitCommandBuilder;
import com.atlassian.bamboo.plugins.git.GitCommandException;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.api.GitRef;
import com.atlassian.bamboo.plugins.git.domain.GitHash;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.process.BambooProcessHandler;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyDTO;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.bamboo.ssh.UntrustedKeyException;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.util.SharedTemporaryFiles;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.LineOutputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitCommandProcessor
implements Serializable,
ProxyErrorReceiver {
    private static final Logger log = Logger.getLogger(GitCommandProcessor.class);
    static final String GIT_OUTPUT_ENCODING = "UTF-8";
    private static final String ENCODING_OPTION = "--encoding=UTF-8";
    private static final Pattern GIT_VERSION_PATTERN = Pattern.compile("^git version (.*)");
    static final String SHA_REGEX = "[0-9a-f]{40}";
    private static final Pattern LS_REMOTE_LINE_PATTERN = Pattern.compile("^([0-9a-f]{40})\\s+(.*)");
    private static final String SSH_IGNORE_HOST_KEY_OPTIONS = "-o StrictHostKeyChecking=no -o BatchMode=yes -o UserKnownHostsFile=/dev/null";
    private static final String SSH_OPTIONS = "-o StrictHostKeyChecking=yes -o BatchMode=yes -o UserKnownHostsFile=%s";
    private static final String SSH_WIN = "@ssh %s %%*\r\n";
    private static final String SSH_UNIX = "#!/bin/sh\nexec ssh %s $@\n";
    private static final String REMOTE_ORIGIN = "refs/remotes/origin/";
    private static final Duration LFS_INFO_THRESHOLD = Duration.ofMinutes(1L);
    private static final Duration LFS_WARN_THRESHOLD = Duration.ofMinutes(5L);
    private static final Duration LFS_ERROR_THRESHOLD = Duration.ofMinutes(20L);
    private final String gitExecutable;
    private final BuildLogger buildLogger;
    private final TrustedKeyHelper trustedKeyHelper;
    private final String passwordToObfuscate;
    private final int commandTimeoutInMinutes;
    private final boolean maxVerboseOutput;
    private String proxyErrorMessage;
    private Throwable proxyException;
    private String sshCommand;
    private static final LoadingCache<GitExistencePair, String> GIT_EXISTENCE_CHECK_RESULT = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<GitExistencePair, String>(){

        public String load(GitExistencePair input) throws Exception {
            GitCommandProcessor gitCommandProcessor = input.gitCommandProcessor;
            File workingDirectory = input.workingDirectory;
            GitCommandBuilder commandBuilder = gitCommandProcessor.createLocalCommandBuilder("version");
            GitStringOutputHandler outputHandler = new GitStringOutputHandler();
            int exitCode = gitCommandProcessor.runCommand(commandBuilder, workingDirectory, outputHandler);
            String output = outputHandler.getOutput();
            Matcher matcher = GIT_VERSION_PATTERN.matcher(output);
            if (!matcher.find()) {
                throw new GitCommandException("Unable to parse git command output: " + exitCode, null, output, "", null);
            }
            return matcher.group();
        }
    });

    public GitCommandProcessor(@NotNull String gitExecutable, @NotNull BuildLogger buildLogger, @Nullable String passwordToObfuscate, int commandTimeoutInMinutes, boolean maxVerboseOutput, @NotNull TrustedKeyHelper trustedKeyHelper) {
        this.gitExecutable = gitExecutable;
        this.buildLogger = buildLogger;
        this.passwordToObfuscate = passwordToObfuscate;
        Preconditions.checkArgument((commandTimeoutInMinutes > 0 ? 1 : 0) != 0, (Object)"Command timeout must be greater than 0");
        this.commandTimeoutInMinutes = commandTimeoutInMinutes;
        this.maxVerboseOutput = maxVerboseOutput;
        this.trustedKeyHelper = trustedKeyHelper;
    }

    private String getDefaultSshWrapperScriptContent(boolean proxied) {
        return SystemUtils.IS_OS_WINDOWS ? this.getSshWin(proxied) : this.getSshUnix(proxied);
    }

    private String getSshUnix(boolean proxied) {
        if (!proxied && this.trustedKeyHelper.isCustomAcceptedSshHostKeysEnabled()) {
            return String.format(SSH_UNIX, String.format(SSH_OPTIONS, this.trustedKeyHelper.getCustomAcceptedSshHostKeysFile().getAbsolutePath()));
        }
        return String.format(SSH_UNIX, SSH_IGNORE_HOST_KEY_OPTIONS);
    }

    private String getSshWin(boolean proxied) {
        if (!proxied && this.trustedKeyHelper.isCustomAcceptedSshHostKeysEnabled()) {
            return String.format(SSH_WIN, String.format(SSH_OPTIONS, this.trustedKeyHelper.getCustomAcceptedSshHostKeysFile().getAbsolutePath()));
        }
        return String.format(SSH_WIN, SSH_IGNORE_HOST_KEY_OPTIONS);
    }

    private String getCustomisedSshWrapperScriptContent(boolean proxied) {
        String sshHostKeyOptions = !proxied && this.trustedKeyHelper.isCustomAcceptedSshHostKeysEnabled() ? String.format(SSH_OPTIONS, this.trustedKeyHelper.getCustomAcceptedSshHostKeysFile().getAbsolutePath()) : SSH_IGNORE_HOST_KEY_OPTIONS;
        return SystemUtils.IS_OS_WINDOWS ? "@\"" + this.sshCommand + "\" " + sshHostKeyOptions + " %*\r\n" : "#!/bin/sh\n\"" + this.sshCommand + "\" " + sshHostKeyOptions + " $@\n";
    }

    private String getSshScriptToRun(String scriptContent) {
        try {
            boolean tmpDirHasSpaceInName = SystemUtils.getJavaIoTmpDir().getAbsolutePath().contains(" ");
            SharedTemporaryFiles.FileSpecBuilder specBuilder = SharedTemporaryFiles.builder((String)scriptContent).setPrefix("bamboo-ssh.").setSuffix(BambooFilenameUtils.getScriptSuffix()).setExecutable(true).setPrefer83PathsOnWindows(tmpDirHasSpaceInName);
            File sshScript = SharedTemporaryFiles.create((SharedTemporaryFiles.SharedTemporaryFileSpec)specBuilder.build());
            return sshScript.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkGitExistenceInSystem(@NotNull File workingDirectory) throws RepositoryException {
        boolean gitDependsOnWorkingDirectory = this.gitExecutable.trim().startsWith(".");
        File directory = gitDependsOnWorkingDirectory ? workingDirectory : new File("/");
        GitExistencePair cacheKey = new GitExistencePair(directory, this.gitExecutable, this);
        try {
            GIT_EXISTENCE_CHECK_RESULT.get((Object)cacheKey);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            RepositoryException re = (RepositoryException)((Object)Narrow.to((Object)cause, RepositoryException.class));
            if (re != null) {
                throw re;
            }
            throw new RepositoryException(cause);
        }
    }

    public void runInitCommand(@NotNull File workingDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("init");
        this.runCommand(commandBuilder, workingDirectory);
    }

    public boolean isAncestor(Path gitWorkspace, GitHash rev1, GitHash rev2) throws RepositoryException {
        if (rev1.equals(rev2)) {
            return false;
        }
        GitCommandBuilder gitMergeBaseIsAncestor = this.createLocalCommandBuilder("merge-base", "--is-ancestor", rev1.getValue(), rev2.getValue()).throwOnNonZeroExit(false);
        int rc = this.runCommand(gitMergeBaseIsAncestor, gitWorkspace);
        if (rc == 0 || rc == 1) {
            return rc == 0;
        }
        throw new RepositoryException("Unable to check ancestry between " + rev1 + " and " + rev2 + " in " + gitWorkspace);
    }

    public List<String> runStatusCommand(@NotNull File workingDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("status", "--porcelain", "--untracked-files=no");
        LineOutputHandlerImpl gitOutputHandler = new LineOutputHandlerImpl();
        this.runCommand(commandBuilder, workingDirectory, gitOutputHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("git status output: " + gitOutputHandler.getStdout()));
        }
        return gitOutputHandler.getLines();
    }

    public void runFetchCommand(@NotNull File workingDirectory, @NotNull GitRepositoryAccessData accessData, String refSpec, boolean useShallow) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createRemoteCommandBuilder(accessData, "fetch", accessData.getRepositoryUrl(), refSpec, "--update-head-ok");
        if (useShallow) {
            commandBuilder.shallowClone();
        }
        File shallowFile = new File(new File(workingDirectory, ".git"), "shallow");
        if (!useShallow && shallowFile.exists()) {
            log.info((Object)String.format("Detected that the directory needs to be converted to a full clone: %s, branch: %s, working dir: %s", accessData.getRepositoryUrl(), accessData.getVcsBranch().getName(), workingDirectory.getAbsolutePath()));
            commandBuilder.append("--depth=99999999");
        }
        if (accessData.isVerboseLogs()) {
            commandBuilder.verbose(true);
            commandBuilder.append("--progress");
        }
        this.runCommand(commandBuilder, workingDirectory, new LoggingOutputHandler(this.buildLogger), PasswordMaskingUtils.getPasswordFromUrl((String)accessData.getRepositoryUrl()));
        File fetchHeadFile = new File(new File(workingDirectory, ".git"), "FETCH_HEAD");
        try {
            if (!fetchHeadFile.exists() || StringUtils.isBlank((CharSequence)FileUtils.readFileToString((File)fetchHeadFile))) {
                throw new RepositoryException("fatal: FETCH_HEAD is empty after fetch.");
            }
        }
        catch (IOException e) {
            throw new RepositoryException("fatal: Error reading FETCH_HEAD file");
        }
    }

    public void runCloneCommand(@NotNull File workingDirectory, @NotNull File cacheDirectory, @NotNull GitRepositoryAccessData accessData) throws RepositoryException {
        boolean useShallowClone = accessData.isUseShallowClones();
        boolean verboseLogs = accessData.isVerboseLogs();
        GitCommandBuilder commandBuilder = this.createRemoteCommandBuilder(accessData, "clone", accessData.getRepositoryUrl()).append("--reference").append(cacheDirectory.getAbsolutePath());
        this.skipLfsFilter(commandBuilder);
        commandBuilder.destination(workingDirectory.getAbsolutePath());
        if (useShallowClone) {
            commandBuilder.shallowClone();
        }
        if (verboseLogs) {
            commandBuilder.verbose(true);
            commandBuilder.append("--progress");
        }
        this.runCommand(commandBuilder, workingDirectory);
    }

    public void runLocalCloneCommand(@NotNull File workingDirectory, File cacheDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("clone", cacheDirectory.getAbsolutePath()).append("--shared").append("--no-checkout").destination(workingDirectory.getAbsolutePath());
        this.skipLfsFilter(commandBuilder);
        this.runCommand(commandBuilder, workingDirectory);
    }

    private void skipLfsFilter(GitCommandBuilder commandBuilder) {
        commandBuilder.append("-c filter.lfs.smudge=").append("-c filter.lfs.required=false");
    }

    public void runLocalFetchCommand(@NotNull File workingDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("fetch");
        this.runCommand(commandBuilder, workingDirectory);
    }

    public void runCheckoutCommand(@NotNull File workingDirectory, String revision, String configuredBranchName, boolean withLfs) throws RepositoryException {
        Pair<String, Boolean> possibleBranch = this.getPossibleBranchNameForCheckout(workingDirectory, revision, configuredBranchName);
        String destination = revision;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)possibleBranch.getFirst()))) {
            destination = (String)possibleBranch.getFirst();
        }
        this.runCheckoutCommandForBranchOrRevision(workingDirectory, destination, !withLfs);
        if (((Boolean)possibleBranch.getSecond()).booleanValue()) {
            GitCommandBuilder gitResetBuilder = this.createLocalCommandBuilder("reset", "--hard", revision);
            this.runCommand(gitResetBuilder, workingDirectory);
        }
    }

    public void runCheckoutCommandForBranchOrRevision(@NotNull File workingDirectory, String destination, boolean disableLfs) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("checkout", "-f", destination);
        if (disableLfs) {
            commandBuilder.env((Map<String, String>)ImmutableMap.of((Object)"GIT_LFS_SKIP_SMUDGE", (Object)"1"));
        }
        this.runCommand(commandBuilder, workingDirectory);
    }

    public void runLfsLogCommand(File workingDirectory) throws RepositoryException {
        this.runCommand(this.createLocalCommandBuilder("lfs", "logs", "last"), workingDirectory);
    }

    public void runSubmoduleUpdateCommand(@NotNull File workingDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("submodule", "update", "--init", "--recursive");
        this.runCommand(commandBuilder, workingDirectory);
    }

    @NotNull
    public String getShaOf(@NotNull File workingDirectory, @NotNull String refOrBranchOrHash) throws RepositoryException {
        Optional<GitHash> shaOf = this.getShaOf(workingDirectory, refOrBranchOrHash, null);
        return shaOf.isPresent() ? shaOf.get().getValue() : "";
    }

    public Optional<GitHash> getShaOf(@NotNull Path workingDirectory, @NotNull String refOrBranchOrHash) throws RepositoryException {
        return this.getShaOf(workingDirectory.toFile(), refOrBranchOrHash, null);
    }

    public Optional<GitHash> getShaOf(@NotNull File workingDirectory, @NotNull String refOrBranchOrHash, @Nullable String path) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("log", "-1", ENCODING_OPTION, "--format=%H");
        commandBuilder.append(refOrBranchOrHash);
        if (path != null) {
            commandBuilder.append("--").append(path);
        }
        GitStringOutputHandler outputHandler = new GitStringOutputHandler(GIT_OUTPUT_ENCODING);
        this.runCommand(commandBuilder, workingDirectory, outputHandler);
        String hash = StringUtils.trimToNull((String)outputHandler.getOutput());
        return hash != null ? Optional.of(new GitHash(hash)) : Optional.empty();
    }

    private boolean isMatchingLocalRef(String refString, String branchName) {
        return refString.startsWith("refs/heads/") && StringUtils.removeStart((String)refString, (String)"refs/heads/").equals(branchName);
    }

    private boolean isMatchingRemoteRef(String refString, String branchName) {
        return refString.startsWith(REMOTE_ORIGIN) && StringUtils.removeStart((String)refString, (String)REMOTE_ORIGIN).equals(branchName);
    }

    public Pair<String, Boolean> getPossibleBranchNameForCheckout(File workingDirectory, String revision, String configuredBranchName) throws RepositoryException {
        String branchName = StringUtils.isBlank((CharSequence)configuredBranchName) ? "master" : configuredBranchName;
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("show-ref", branchName).throwOnNonZeroExit(false);
        LineOutputHandlerImpl outputHandler = new LineOutputHandlerImpl();
        this.runCommand(commandBuilder, workingDirectory, outputHandler);
        List<String> lines = outputHandler.getLines();
        if (log.isDebugEnabled()) {
            log.debug((Object)"--- Full output: ---\n");
            for (String line : lines) {
                log.debug((Object)line);
            }
            log.debug((Object)"--- End of output: ---\n");
        }
        boolean remoteRefFound = false;
        boolean localWithDifferentRef = false;
        for (String line : lines) {
            Iterable splitLine = Splitter.on((char)' ').trimResults().split((CharSequence)line.trim());
            String sha = (String)Iterables.getFirst((Iterable)splitLine, null);
            String refString = (String)Iterables.getLast((Iterable)splitLine, null);
            if (this.isMatchingLocalRef(refString, branchName)) {
                if (revision.equals(sha)) {
                    return Pair.make((Object)branchName, (Object)false);
                }
                localWithDifferentRef = true;
                continue;
            }
            if (!this.isMatchingRemoteRef(refString, branchName) || !revision.equals(sha)) continue;
            remoteRefFound = true;
        }
        if (remoteRefFound) {
            return Pair.make((Object)branchName, (Object)localWithDifferentRef);
        }
        return Pair.make((Object)"", (Object)false);
    }

    @NotNull
    public ImmutableMap<String, String> getRemoteRefs(@NotNull GitRepositoryAccessData accessData) throws RepositoryException {
        LineOutputHandlerImpl goh = new LineOutputHandlerImpl();
        Stopwatch stopwatch = Stopwatch.createStarted();
        GitCommandBuilder commandBuilder = this.createRemoteCommandBuilder(accessData, "ls-remote", accessData.getRepositoryUrl());
        String passwordFromUrl = PasswordMaskingUtils.getPasswordFromUrl((String)accessData.getRepositoryUrl());
        this.runCommand(commandBuilder, SystemUtils.getJavaIoTmpDir(), goh, passwordFromUrl);
        Duration infoThreshold = Duration.ofSeconds(10L);
        Duration warnThreshold = Duration.ofSeconds(20L);
        Duration errorThreshold = Duration.ofSeconds(30L);
        BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (Duration)infoThreshold, (Duration)warnThreshold, (Duration)errorThreshold, (String)("ls-remote " + PasswordMaskingUtils.mask((String)accessData.getRepositoryUrl(), (String)passwordFromUrl)));
        ImmutableMap<String, String> result = GitCommandProcessor.parseLsRemoteOutput(goh);
        return result;
    }

    @NotNull
    public Optional<String> getBranchForSha(@NotNull File workingDirectory, String revision, String configuredBranch) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("branch", "-a", "--contains", revision);
        LineOutputHandlerImpl outputHandler = new LineOutputHandlerImpl();
        this.runCommand(commandBuilder, workingDirectory, outputHandler);
        String anyBranch = null;
        for (String branch : outputHandler.getLines()) {
            Iterable tokens = Splitter.on((String)" ").omitEmptyStrings().trimResults().split((CharSequence)branch);
            anyBranch = (String)Iterables.getLast((Iterable)tokens);
            if (!StringUtils.equals((CharSequence)anyBranch, (CharSequence)configuredBranch)) continue;
            return Optional.of(anyBranch);
        }
        return Optional.ofNullable(anyBranch);
    }

    @NotNull
    static ImmutableMap<String, String> parseLsRemoteOutput(LineOutputHandlerImpl goh) {
        ImmutableMap.Builder refs = ImmutableMap.builder();
        for (String ref : goh.getLines()) {
            Matcher matcher;
            log.trace((Object)('[' + ref + ']'));
            if (ref.contains("^{}") || !(matcher = LS_REMOTE_LINE_PATTERN.matcher(ref)).matches()) continue;
            refs.put((Object)matcher.group(2), (Object)matcher.group(1));
        }
        return refs.build();
    }

    public void setOrigin(@NotNull String originUrl, @NotNull File workingDirectory) throws RepositoryException {
        this.runCommand(this.createLocalCommandBuilder("remote", "set-url", "origin", originUrl), workingDirectory);
    }

    public void runLfsPullCommand(File workingDirectory) throws RepositoryException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.runCommand(this.createLocalCommandBuilder("lfs", "pull"), workingDirectory);
        BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (Duration)LFS_INFO_THRESHOLD, (Duration)LFS_WARN_THRESHOLD, (Duration)LFS_ERROR_THRESHOLD, (String)"git lfs pull");
    }

    public void runLfsFetchCommand(@NotNull GitRepositoryAccessData repositoryAccessData, @NotNull File workingDirectory, @NotNull GitRef resolvedRef, @NotNull HashAndSource hashAndSource) throws RepositoryException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        GitCommandBuilder remoteCommandBuilder = this.createRemoteCommandBuilder(repositoryAccessData, "lfs", "fetch", repositoryAccessData.getRepositoryUrl());
        if (!resolvedRef.getValue().contains("*")) {
            remoteCommandBuilder.append(resolvedRef.getValue());
        } else if (!StringUtils.isBlank((CharSequence)hashAndSource.getHash())) {
            remoteCommandBuilder.append(hashAndSource.getHash());
        } else if (!StringUtils.isBlank((CharSequence)hashAndSource.getBranch())) {
            remoteCommandBuilder.append(hashAndSource.getBranch());
        }
        this.runCommand(remoteCommandBuilder, workingDirectory);
        BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (Duration)LFS_INFO_THRESHOLD, (Duration)LFS_WARN_THRESHOLD, (Duration)LFS_ERROR_THRESHOLD, (String)"git lfs fetch");
    }

    public void addOrigin(@NotNull String originUrl, @NotNull File workingDirectory) throws RepositoryException {
        this.runCommand(this.createLocalCommandBuilder("remote", "add", "origin", originUrl), workingDirectory);
    }

    public void setOriginToLocalDirectory(@NotNull File cacheDirectory, @NotNull File workingDirectory) throws RepositoryException {
        this.setOrigin("file://" + cacheDirectory.getAbsolutePath(), workingDirectory);
    }

    public GitCommandBuilder createLocalCommandBuilder(String ... commands) {
        return new GitCommandBuilder(commands).executable(this.gitExecutable);
    }

    public GitCommandBuilder createRemoteCommandBuilder(GitRepositoryAccessData gitRepositoryAccessData, String ... commands) {
        return new GitCommandBuilder(commands).executable(this.gitExecutable).proxied(gitRepositoryAccessData.isProxied()).sshCommand(this.getSshScriptToRun(StringUtils.isBlank((CharSequence)this.sshCommand) ? this.getDefaultSshWrapperScriptContent(gitRepositoryAccessData.isProxied()) : this.getCustomisedSshWrapperScriptContent(gitRepositoryAccessData.isProxied())));
    }

    public void reportProxyError(String message, Throwable exception) {
        this.proxyErrorMessage = message;
        this.proxyException = exception;
    }

    public int runCommand(@NotNull GitCommandBuilder commandBuilder, @NotNull File workingDirectory) throws RepositoryException {
        return this.runCommand(commandBuilder, workingDirectory, new LoggingOutputHandler(this.buildLogger));
    }

    private int runCommand(@NotNull GitCommandBuilder commandBuilder, @NotNull Path workingDirectory) throws RepositoryException {
        return this.runCommand(commandBuilder, workingDirectory.toFile(), new LoggingOutputHandler(this.buildLogger));
    }

    public int runCommand(@NotNull GitCommandBuilder commandBuilder, @NotNull File workingDirectory, @NotNull GitOutputHandler outputHandler) throws RepositoryException {
        return this.runCommand(commandBuilder, workingDirectory, outputHandler, null);
    }

    private int runCommand(@NotNull GitCommandBuilder commandBuilder, @NotNull File workingDirectory, @NotNull GitOutputHandler outputHandler, @Nullable String additionalPasswordToObfuscate) throws RepositoryException {
        Throwable cause;
        ArrayList passwordsToObfuscate = Lists.newArrayList((Object[])new String[]{this.passwordToObfuscate, additionalPasswordToObfuscate});
        workingDirectory.mkdirs();
        BambooProcessHandler handler = new BambooProcessHandler((OutputHandler)outputHandler, (OutputHandler)outputHandler);
        List<String> commandArgs = commandBuilder.build();
        String maskedCommandLine = PasswordMaskingUtils.mask((String)BambooStringUtils.toCommandLineString(commandArgs), (Iterable)passwordsToObfuscate);
        if (this.maxVerboseOutput || log.isDebugEnabled()) {
            if (this.maxVerboseOutput) {
                this.buildLogger.addBuildLogEntry(maskedCommandLine);
            }
            log.debug((Object)("Running in " + workingDirectory + ": [" + maskedCommandLine + "]"));
        }
        ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder().command(commandArgs, workingDirectory).handler((ProcessHandler)handler).executionTimeout(TimeUnit.MINUTES.toMillis(this.commandTimeoutInMinutes)).idleTimeout(TimeUnit.MINUTES.toMillis(this.commandTimeoutInMinutes)).env(commandBuilder.getEnv());
        ExternalProcess process = externalProcessBuilder.build();
        process.execute();
        if (handler.succeeded()) {
            return handler.getExitCode();
        }
        if (process.isTimedOut()) {
            handler.complete(handler.getExitCode(), true, handler.getException());
        }
        String maskedOutput = PasswordMaskingUtils.mask((String)outputHandler.getStdout(), (Iterable)passwordsToObfuscate);
        String message = "command " + maskedCommandLine + " failed with code " + handler.getExitCode() + ". Working directory was [" + workingDirectory + "].";
        if (handler.isCanceled()) {
            throw new CancelException("Command was canceled: " + message);
        }
        Throwable throwable = cause = this.proxyException != null ? this.proxyException : handler.getException();
        if (cause instanceof UntrustedKeyException) {
            throw new HostKeyVerificationException(message, cause, maskedOutput, this.proxyErrorMessage != null ? PasswordMaskingUtils.mask((String)this.proxyErrorMessage, (Iterable)passwordsToObfuscate) : maskedOutput, (List)passwordsToObfuscate, ((UntrustedKeyException)cause).getTrustedKey());
        }
        if (maskedOutput.contains("Host key verification failed.")) {
            throw new HostKeyVerificationException(message, cause, maskedOutput, this.proxyErrorMessage != null ? PasswordMaskingUtils.mask((String)this.proxyErrorMessage, (Iterable)passwordsToObfuscate) : maskedOutput, (List)passwordsToObfuscate, TrustedKeyDTO.from((String)((String)this.retrieveHostCertificate((GitCommandBuilder)commandBuilder).first)));
        }
        if (commandBuilder.isThrowOnNonZeroExit() || cause != null) {
            throw new GitCommandException(message, cause, maskedOutput, this.proxyErrorMessage != null ? PasswordMaskingUtils.mask((String)this.proxyErrorMessage, (Iterable)passwordsToObfuscate) : maskedOutput, this.passwordToObfuscate);
        }
        return handler.getExitCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, String> retrieveHostCertificate(@NotNull GitCommandBuilder commandBuilder) {
        SecureTemporaryFiles.FileSpecBuilder TEMPORARY_FILE_SPEC = SecureTemporaryFiles.builder().setPrefix("gitKnownHost").setSuffix(".tmp").useShortDirectoryName().failWhenPermissionsNotSet();
        File tmpFile = null;
        try {
            tmpFile = SecureTemporaryFiles.create((SecureTemporaryFiles.TemporaryFileSpec)TEMPORARY_FILE_SPEC.build());
            String scriptContent = StringUtils.isBlank((CharSequence)this.sshCommand) ? this.getDefaultSshWrapperScriptContent(commandBuilder.isProxied()) : this.getCustomisedSshWrapperScriptContent(commandBuilder.isProxied());
            String retrieveCertificateSshCommand = scriptContent.replaceAll("-o UserKnownHostsFile=\\S*", "-o UserKnownHostsFile=" + tmpFile.getCanonicalPath()).replaceAll("-o StrictHostKeyChecking=\\S*", "-o StrictHostKeyChecking=no");
            commandBuilder.sshCommand(this.getSshScriptToRun(retrieveCertificateSshCommand));
            List<String> certificateCommandArgs = commandBuilder.build();
            BambooProcessHandler certHandler = new BambooProcessHandler((OutputHandler)new StringOutputHandler(), (OutputHandler)new StringOutputHandler());
            ExternalProcess certProcess = this.buildGitExternalProcess(certificateCommandArgs, tmpFile.getParentFile(), (PluggableProcessHandler)certHandler, commandBuilder.getEnv());
            certProcess.execute();
            if (certHandler.succeeded()) {
                String publicKey = FileUtils.readFileToString((File)tmpFile);
                Pair pair = Pair.make((Object)publicKey, (Object)("SSH host public key: " + System.lineSeparator() + publicKey));
                return pair;
            }
        }
        catch (IOException e) {
            log.warn((Object)"Couldn't create tmp file for known hosts", (Throwable)e);
        }
        finally {
            BambooFiles.deleteQuietly((Path)BambooPathUtils.toPath((File)tmpFile));
        }
        return Pair.make((Object)"", (Object)"");
    }

    private ExternalProcess buildGitExternalProcess(@NotNull List<String> commandArgs, @NotNull File workingDirectory, @NotNull PluggableProcessHandler handler, @Nullable Map<String, String> env) {
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().command(commandArgs, workingDirectory).executionTimeout(TimeUnit.MINUTES.toMillis(this.commandTimeoutInMinutes)).idleTimeout(TimeUnit.MINUTES.toMillis(this.commandTimeoutInMinutes)).handler((ProcessHandler)handler);
        if (env != null) {
            processBuilder.env(env);
        }
        return processBuilder.build();
    }

    public void runMergeCommand(@NotNull GitCommandBuilder commandBuilder, @NotNull File workspaceDir) throws RepositoryException {
        LoggingOutputHandler mergeOutputHandler = new LoggingOutputHandler(this.buildLogger);
        this.runCommand(commandBuilder, workspaceDir, mergeOutputHandler);
        log.debug((Object)mergeOutputHandler.getStdout());
    }

    @NotNull
    public CommitContext extractCommit(File directory, String targetRevision) throws RepositoryException {
        CommitOutputHandler coh = new CommitOutputHandler(Collections.emptySet());
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("log", "-1", ENCODING_OPTION, "--format=[d31bfa5_BAM_hash]%H%n[d31bfa5_BAM_author_name]%aN%n[d31bfa5_BAM_author_email]%ae%n[d31bfa5_BAM_timestamp]%ct%n[d31bfa5_BAM_commit_message]%s%n%b[d31bfa5_BAM_commit_message_end]%n[d31bfa5_BAM_file_list]", targetRevision);
        this.runCommand(commandBuilder, directory, coh);
        List<CommitContext> commits = coh.getExtractedCommits();
        if (commits.isEmpty()) {
            throw new RepositoryException("Could not find commit with revision " + targetRevision);
        }
        return commits.get(0);
    }

    public Pair<List<CommitContext>, Integer> runLogCommand(File cacheDirectory, @NotNull String lastVcsRevisionKey, String targetRevision, @NotNull Set<String> shallows, int maxCommits, @Nullable String path) throws RepositoryException {
        String ancestryPathQuery = null;
        GitCommandBuilder commandBuilder = this.createLocalCommandBuilder("log", "-p", "--name-only", ENCODING_OPTION, "--format=[d31bfa5_BAM_hash]%H%n[d31bfa5_BAM_author_name]%aN%n[d31bfa5_BAM_author_email]%ae%n[d31bfa5_BAM_timestamp]%ct%n[d31bfa5_BAM_commit_message]%s%n%b[d31bfa5_BAM_commit_message_end]%n[d31bfa5_BAM_file_list]");
        if (lastVcsRevisionKey.equals(targetRevision)) {
            commandBuilder.append(targetRevision).append("-1");
        } else {
            ancestryPathQuery = lastVcsRevisionKey + ".." + targetRevision;
            commandBuilder.append(ancestryPathQuery);
        }
        if (path != null) {
            commandBuilder.append("--").append(path);
        }
        log.debug((Object)("Extracting commits between [" + lastVcsRevisionKey + "] and [" + targetRevision + ']'));
        CommitOutputHandler coh = new CommitOutputHandler(shallows, maxCommits);
        this.runCommand(commandBuilder, cacheDirectory, coh);
        if (ancestryPathQuery != null) {
            try {
                AncestryPathOutputHandler ancestryPathOutputHandler = new AncestryPathOutputHandler(maxCommits);
                GitCommandBuilder ancestryPathCommandBuilder = this.createLocalCommandBuilder("log", "--format=%H", "--ancestry-path", ancestryPathQuery);
                this.runCommand(ancestryPathCommandBuilder, cacheDirectory, ancestryPathOutputHandler);
                for (Commit commit : Narrow.iterableDownTo(coh.getExtractedCommits(), Commit.class)) {
                    commit.setForeignCommit(!ancestryPathOutputHandler.getCommitsOnAncestryPath().contains(commit.getChangeSetId()));
                }
            }
            catch (RepositoryException re) {
                log.debug((Object)"git log --ancestry-path failed", (Throwable)re);
            }
        }
        return Pair.make(coh.getExtractedCommits(), (Object)coh.getSkippedCommitCount());
    }

    public void setSshCommand(String sshCommand) {
        this.sshCommand = sshCommand;
    }

    static class LoggingOutputHandler
    extends LineOutputHandler
    implements GitOutputHandler {
        final BuildLogger buildLogger;
        final StringBuffer stringBuffer;

        public LoggingOutputHandler(@NotNull BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
            this.stringBuffer = new StringBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processLine(int i, String s) {
            this.buildLogger.addBuildLogEntry(s);
            StringBuffer stringBuffer = this.stringBuffer;
            synchronized (stringBuffer) {
                if (this.stringBuffer.length() != 0) {
                    this.stringBuffer.append("\n");
                }
                this.stringBuffer.append(s);
            }
        }

        @Override
        public String getStdout() {
            return this.stringBuffer.toString();
        }
    }

    static class LineOutputHandlerImpl
    extends LineOutputHandler
    implements GitOutputHandler {
        private final List<String> lines = Collections.synchronizedList(new LinkedList());
        private final Joiner stdoutJoiner;

        public LineOutputHandlerImpl() {
            this(Joiner.on((String)"\n"));
        }

        public LineOutputHandlerImpl(@NotNull Joiner stdoutJoiner) {
            this.stdoutJoiner = stdoutJoiner;
        }

        protected void processLine(int i, String s) {
            this.lines.add(s);
        }

        @NotNull
        public List<String> getLines() {
            return this.lines;
        }

        @Override
        public String getStdout() {
            return this.stdoutJoiner.join(this.lines.stream().filter(StringUtils::isNotEmpty).iterator());
        }
    }

    static class GitStringOutputHandler
    extends StringOutputHandler
    implements GitOutputHandler {
        public GitStringOutputHandler(String encoding) {
            super(encoding);
        }

        @Deprecated
        public GitStringOutputHandler() {
        }

        @Override
        public String getStdout() {
            return this.getOutput();
        }
    }

    static interface GitOutputHandler
    extends OutputHandler {
        public String getStdout();
    }

    private static final class GitExistencePair {
        public final File workingDirectory;
        private final String gitExecutableName;
        public final GitCommandProcessor gitCommandProcessor;

        public GitExistencePair(File workingDirectory, String gitExecutableName, GitCommandProcessor gitCommandProcessor) {
            this.workingDirectory = workingDirectory;
            this.gitExecutableName = gitExecutableName;
            this.gitCommandProcessor = gitCommandProcessor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GitExistencePair that = (GitExistencePair)o;
            if (!this.gitExecutableName.equals(that.gitExecutableName)) {
                return false;
            }
            return this.workingDirectory.equals(that.workingDirectory);
        }

        public int hashCode() {
            int result = this.workingDirectory.hashCode();
            result = 31 * result + this.gitExecutableName.hashCode();
            return result;
        }
    }
}

