/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.api;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.api.GitRef;
import com.atlassian.bamboo.plugins.git.domain.GitHash;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooSpecsHandlerForGit
extends AbstractGitExecutor
implements BambooSpecsHandler {
    private static final Logger log = Logger.getLogger(BambooSpecsHandlerForGit.class);

    public Optional<String> detectSpecRevision(@NotNull VcsRepositoryData repositoryData, Object source) throws RepositoryException {
        GitRef ref = (GitRef)source;
        GitRepositoryAccessData substitutedAccessData = this.toAccessData(repositoryData);
        GitOperationHelper helper = this.createGitOperationHelper(substitutedAccessData);
        File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
        Result result = (Result)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
            try {
                Optional<GitHash> gitHash = helper.obtainLatestRevision(cacheDirectory, ref, BAMBOO_SPECS_DIRECTORY);
                if (!gitHash.isPresent()) {
                    gitHash = helper.obtainLatestRevision(cacheDirectory, ref, BITBUCKET_PIPELINES_YML);
                }
                return Result.result(gitHash);
            }
            catch (RepositoryException e) {
                return Result.exception((Throwable)e);
            }
        });
        return ((Optional)result.getResultThrowException()).map(GitHash::getValue);
    }

    public boolean isNewer(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.toAccessData(repositoryData);
        GitOperationHelper helper = this.createGitOperationHelper(substitutedAccessData);
        Path cacheDirectory = this.getCachePath(substitutedAccessData);
        String branchName = repositoryData.getBranch().getVcsBranch().getName();
        try {
            if (helper.isAncestor(cacheDirectory, new GitHash(rev2), new GitHash(rev1))) {
                return true;
            }
            Optional<String> actualBranch = helper.getBranchForSha(this.getCacheDirectory(substitutedAccessData), rev2, branchName);
            if (!actualBranch.isPresent() || !actualBranch.get().equals(branchName)) {
                log.info((Object)("Commit " + rev2 + " not found on branch " + branchName + ". Assuming force push."));
                return true;
            }
        }
        catch (RepositoryException e) {
            log.info((Object)("Commit " + rev2 + " not found in the repository. Assuming force push or repository reconfigured."));
            return true;
        }
        return false;
    }

    public List<CommitContext> findCommitsToSpecs(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.toAccessData(repositoryData);
        GitOperationHelper helper = this.createGitOperationHelper(substitutedAccessData);
        Path cacheDirectory = this.getCachePath(substitutedAccessData);
        File cacheDirectoryAsFile = this.getCacheDirectory(substitutedAccessData);
        if (!helper.isAncestor(cacheDirectory, new GitHash(rev1), new GitHash(rev2))) {
            return Collections.singletonList(helper.getCommit(cacheDirectoryAsFile, rev2));
        }
        return helper.extractCommits(cacheDirectoryAsFile, rev1, rev2, BAMBOO_SPECS_DIRECTORY).getChanges();
    }

    @NotNull
    private GitOperationHelper createGitOperationHelper(GitRepositoryAccessData substitutedAccessData) throws RepositoryException {
        return GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
    }

    private GitRepositoryAccessData toAccessData(@NotNull VcsRepositoryData repositoryData) {
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext();
        return (GitRepositoryAccessData)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.getSubstitutedAccessData(repositoryData));
    }
}

