/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github.exporter;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.repository.git.UserPasswordAuthentication;
import com.atlassian.bamboo.specs.builders.repository.github.GitHubRepository;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.UserPasswordAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.github.GitHubRepositoryProperties;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.export.DefaultVcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubConfigurationExporter
implements VcsRepositoryDataExporter<GitHubRepository, GitHubRepositoryProperties> {
    private static final Logger log = Logger.getLogger(GitHubConfigurationExporter.class);

    @NotNull
    public GitHubRepository getEntityPropertiesBuilder(@NotNull VcsRepositoryData repositoryData) {
        return new GitHubRepository();
    }

    @NotNull
    public GitHubRepository appendLocationData(@NotNull GitHubRepository builder, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        Map configuration = vcsLocationDefinition.getConfiguration();
        int commandTimeout = configuration.containsKey("repository.github.commandTimeout") ? Integer.valueOf((String)configuration.get("repository.github.commandTimeout")) : 180;
        builder.repository((String)configuration.get("repository.github.repository")).shallowClonesEnabled(Boolean.valueOf((String)configuration.get("repository.github.useShallowClones")).booleanValue()).submodulesEnabled(Boolean.valueOf((String)configuration.get("repository.github.useSubmodules")).booleanValue()).remoteAgentCacheEnabled(Boolean.valueOf((String)configuration.get("repository.github.useRemoteAgentCache")).booleanValue()).commandTimeout(Duration.ofMinutes(commandTimeout)).verboseLogs(Boolean.valueOf((String)configuration.get("repository.github.verbose.logs")).booleanValue()).fetchWholeRepository(Boolean.valueOf((String)configuration.get("repository.github.fetch.whole.repository")).booleanValue()).lfsEnabled(Boolean.valueOf((String)configuration.get("repository.github.lfs")).booleanValue()).baseUrl(configuration.getOrDefault("https://github.com/", "https://github.com"));
        String username = (String)configuration.get("repository.github.username");
        UserPasswordAuthentication userPasswordAuthentication = new UserPasswordAuthentication(username).password((String)configuration.get("repository.github.password"));
        builder.authentication(userPasswordAuthentication);
        return builder;
    }

    @NotNull
    public GitHubRepository appendBranchData(@NotNull GitHubRepository builder, @NotNull VcsBranchDefinition vcsBranchDefinition) {
        return builder.branch((String)vcsBranchDefinition.getConfiguration().get("repository.github.branch"));
    }

    @NotNull
    public GitHubRepository appendChangeDetectionOptions(@NotNull GitHubRepository builder, @NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        builder.changeDetection(DefaultVcsRepositoryDataExporter.exportStandardChangeDetectionOptions((VcsChangeDetectionOptions)changeDetectionOptions));
        return builder;
    }

    @NotNull
    public GitHubRepository appendBranchDetectionOptions(@NotNull GitHubRepository builder, @NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return builder;
    }

    @Nullable
    public Map<String, String> importLocationData(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsLocationDefinition existingData) {
        if (repositoryProperties.getRepository() != null) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("repository.github.repository", repositoryProperties.getRepository());
            configuration.put("repository.github.useShallowClones", Boolean.toString(repositoryProperties.isUseShallowClones()));
            configuration.put("repository.github.useRemoteAgentCache", Boolean.toString(repositoryProperties.isUseRemoteAgentCache()));
            configuration.put("repository.github.useSubmodules", Boolean.toString(repositoryProperties.isUseSubmodules()));
            configuration.put("repository.github.commandTimeout", Long.toString(repositoryProperties.getCommandTimeout().toMinutes()));
            configuration.put("repository.github.verbose.logs", Boolean.toString(repositoryProperties.isVerboseLogs()));
            configuration.put("repository.github.fetch.whole.repository", Boolean.toString(repositoryProperties.isFetchWholeRepository()));
            configuration.put("repository.github.lfs", Boolean.toString(repositoryProperties.isUseLfs()));
            configuration.put("https://github.com/", repositoryProperties.getBaseUrl());
            AuthenticationProperties authenticationProperties = repositoryProperties.getAuthenticationProperties();
            if (authenticationProperties != null) {
                if (authenticationProperties instanceof UserPasswordAuthenticationProperties) {
                    UserPasswordAuthenticationProperties userPasswordAuthenticationProperties = (UserPasswordAuthenticationProperties)Narrow.to((Object)authenticationProperties, UserPasswordAuthenticationProperties.class);
                    configuration.put("repository.github.username", userPasswordAuthenticationProperties.getUsername());
                    configuration.put("repository.github.password", StringUtils.defaultString((String)userPasswordAuthenticationProperties.getPassword()));
                }
            } else {
                throw new PropertiesValidationException(new ValidationProblem("GitHub authentication data not defined"));
            }
            return configuration;
        }
        if (!repositoryProperties.hasParent()) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem("GitHub server data not defined or incomplete")));
        }
        return null;
    }

    @Nullable
    public Map<String, String> importBranchData(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsBranchDefinition existingData) {
        if (repositoryProperties.getBranch() != null) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("repository.github.branch", repositoryProperties.getBranch());
            return configuration;
        }
        if (!repositoryProperties.hasParent()) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem("GitHub branch not defined")));
        }
        return null;
    }

    @Nullable
    public Map<String, String> importChangeDetectionOptions(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsChangeDetectionOptions existingData) {
        return DefaultVcsRepositoryDataExporter.importStandardChangeDetectionOptions((VcsRepositoryProperties)repositoryProperties, (VcsChangeDetectionProperties)repositoryProperties.getVcsChangeDetection());
    }

    @Nullable
    public Map<String, String> importBranchDetectionOptions(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsBranchDetectionOptions existingData) {
        return null;
    }
}

