/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.rest.resource;

import com.atlassian.bamboo.plugins.git.GitHubAccessor;
import com.atlassian.bamboo.plugins.git.GitHubRepository;
import com.atlassian.bamboo.plugins.git.github.api.rest.entity.GitHubBranchEntity;
import com.atlassian.bamboo.plugins.git.github.api.rest.entity.GitHubRepositoryEntity;
import com.atlassian.bamboo.plugins.git.rest.entity.ListBranchesResponse;
import com.atlassian.bamboo.plugins.git.rest.entity.ListRepositoriesResponse;
import com.atlassian.bamboo.plugins.git.rest.entity.RestRequest;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.rest.entity.RestResponse;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.sal.api.message.I18nResolver;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Path(value="gh")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
public class GitHubResource {
    private static final Logger log = Logger.getLogger(GitHubResource.class);
    private final I18nResolver i18nResolver;
    private final RepositoryDefinitionManager repositoryDefinitionManager;

    public GitHubResource(I18nResolver i18nResolver, RepositoryDefinitionManager repositoryDefinitionManager) {
        this.i18nResolver = i18nResolver;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @POST
    @Path(value="repositories/{username}")
    public Response getAvailableRepositories(@Context UriInfo uriInfo, @PathParam(value="username") String username, RestRequest request) {
        if (request.getRepositoryId() > 0L && StringUtils.isBlank((CharSequence)request.getPassword())) {
            request.setPassword(this.getRepositoryPassword(request.getRepositoryId()));
        }
        RestResponse.Builder builder = RestResponse.builder();
        try {
            GitHubAccessor gitHubAccessor = new GitHubAccessor(username, request.getPassword());
            ListRepositoriesResponse response = (ListRepositoriesResponse)builder.build(ListRepositoriesResponse.class);
            List repositories = BambooIterables.stream(gitHubAccessor.getAccessibleRepositories()).map(GitHubRepositoryEntity::new).collect(Collectors.toList());
            response.setRepositories((List<GitHubRepositoryEntity>)GitHubRepositoryEntity.orderingByFullName().immutableSortedCopy(repositories));
            return Response.ok((Object)((Object)response)).build();
        }
        catch (GitHubAccessor.GitHubException | IOException e) {
            log.warn((Object)this.i18nResolver.getText("repository.github.ajaxError"), (Throwable)e);
            builder.error(this.i18nResolver.getText("repository.github.ajaxError") + e.toString());
            return Response.ok((Object)builder.build(RestResponse.class)).build();
        }
    }

    @POST
    @Path(value="repositories/{owner}/{name}/branches")
    public Response getBranches(@Context UriInfo uriInfo, @PathParam(value="owner") String owner, @PathParam(value="name") String name, RestRequest request) {
        if (request.getRepositoryId() > 0L) {
            if (StringUtils.isBlank((CharSequence)request.getUsername())) {
                Pair<String, String> userNameAndPassword = this.getRepositoryUsernameAndPassword(request.getRepositoryId());
                request.setUsername((String)userNameAndPassword.getFirst());
                request.setPassword((String)userNameAndPassword.getSecond());
            } else if (StringUtils.isBlank((CharSequence)request.getPassword())) {
                request.setPassword(this.getRepositoryPassword(request.getRepositoryId()));
            }
        }
        RestResponse.Builder builder = RestResponse.builder();
        try {
            GitHubAccessor gitHubAccessor = new GitHubAccessor(request.getUsername(), request.getPassword());
            ListBranchesResponse response = (ListBranchesResponse)builder.build(ListBranchesResponse.class);
            List branches = BambooIterables.stream(gitHubAccessor.getBranches(String.format("%s/%s", owner, name))).map(GitHubBranchEntity::new).collect(Collectors.toList());
            response.setBranches((List<GitHubBranchEntity>)GitHubBranchEntity.orderingByName().immutableSortedCopy(branches));
            return Response.ok((Object)((Object)response)).build();
        }
        catch (GitHubAccessor.GitHubException | IOException e) {
            log.warn((Object)this.i18nResolver.getText("repository.github.ajaxError"), (Throwable)e);
            builder.error(this.i18nResolver.getText("repository.github.ajaxError") + e.toString());
            return Response.ok((Object)builder.build(RestResponse.class)).build();
        }
    }

    @Nullable
    private String getRepositoryPassword(long repositoryId) {
        VcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(repositoryId);
        if (vcsRepositoryData != null) {
            if (vcsRepositoryData.isLegacyRepository()) {
                RepositoryDataImpl repositoryData = new RepositoryDataImpl(vcsRepositoryData);
                Repository repository = repositoryData.getRepository();
                GitHubRepository ghRepository = (GitHubRepository)Narrow.to((Object)repository, GitHubRepository.class);
                if (ghRepository != null) {
                    return ghRepository.getPassword();
                }
            } else {
                return (String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.github.password");
            }
        }
        return null;
    }

    @Nullable
    private Pair<String, String> getRepositoryUsernameAndPassword(long repositoryId) {
        VcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(repositoryId);
        if (vcsRepositoryData != null) {
            if (vcsRepositoryData.isLegacyRepository()) {
                RepositoryDataImpl repositoryData = new RepositoryDataImpl(vcsRepositoryData);
                Repository repository = repositoryData.getRepository();
                GitHubRepository ghRepository = (GitHubRepository)Narrow.to((Object)repository, GitHubRepository.class);
                if (ghRepository != null) {
                    return Pair.make((Object)ghRepository.getUsername(), (Object)ghRepository.getPassword());
                }
            } else {
                return Pair.make(vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.github.username"), vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.github.password"));
            }
        }
        return null;
    }
}

