/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import org.jetbrains.annotations.Nullable;

class GitCommandException
extends RepositoryException {
    private final String stdout;
    private final String stderr;
    private final String passwordToObfuscate;

    public GitCommandException(String message, @Nullable Throwable cause, String stdout, String stderr, @Nullable String passwordToObfuscate) {
        super(message, cause);
        this.stdout = stdout;
        this.stderr = stderr;
        this.passwordToObfuscate = passwordToObfuscate;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        sb.append(", stderr:\n").append(this.stderr);
        if (!this.stdout.equals(this.stderr)) {
            sb.append("\nstdout:\n").append(this.stdout);
        }
        return PasswordMaskingUtils.mask((String)sb.toString(), (String)this.passwordToObfuscate);
    }
}

