/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchIntegrationHelper;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitHubRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitRepositoryFacade;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.AdvancedConfigurationAwareRepository;
import com.atlassian.bamboo.repository.BranchInformationProvider;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.DeploymentAwareRepository;
import com.atlassian.bamboo.repository.PushCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.UniqueRevisionIdRepository;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubRepository
extends AbstractStandaloneRepository
implements AdvancedConfigurationAwareRepository,
BranchInformationProvider,
BranchMergingAwareRepository,
CachingAwareRepository,
CustomSourceDirectoryAwareRepository,
CustomVariableProviderRepository,
DeploymentAwareRepository,
GitRepositoryFacade,
PushCapableRepository,
UniqueRevisionIdRepository {
    private static final Logger log = Logger.getLogger(GitHubRepository.class);
    private static final String REPOSITORY_GITHUB_USERNAME = "repository.github.username";
    private static final String REPOSITORY_GITHUB_PASSWORD = "repository.github.password";
    private static final String REPOSITORY_GITHUB_REPOSITORY = "repository.github.repository";
    private static final String REPOSITORY_GITHUB_BRANCH = "repository.github.branch";
    private static final String REPOSITORY_GITHUB_USE_SHALLOW_CLONES = "repository.github.useShallowClones";
    private static final String REPOSITORY_GITHUB_USE_SUBMODULES = "repository.github.useSubmodules";
    private static final String REPOSITORY_GITHUB_USE_REMOTE_AGENT_CACHE = "repository.github.useRemoteAgentCache";
    private static final String REPOSITORY_GITHUB_COMMAND_TIMEOUT = "repository.github.commandTimeout";
    private static final String REPOSITORY_GITHUB_VERBOSE_LOGS = "repository.github.verbose.logs";
    private static final String REPOSITORY_GITHUB_FETCH_WHOLE_REPOSITORY = "repository.github.fetch.whole.repository";
    private static final String REPOSITORY_GITHUB_TEMPORARY_PASSWORD = "repository.github.temporary.password";
    private static final String TEMPORARY_GITHUB_PASSWORD_CHANGE = "temporary.github.password.change";
    private static final String REPOSITORY_GITHUB_ERROR_MISSING_REPOSITORY = "repository.github.error.missingRepository";
    private GitRepository gitRepository = new GitRepository();
    private GitHubRepositoryAccessData accessData = new GitHubRepositoryAccessData();
    private I18nResolver i18nResolver;
    private EncryptionService encryptionService;

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        super.setBuildDirectoryManager(buildDirectoryManager);
        this.getGitRepository().setBuildDirectoryManager(buildDirectoryManager);
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        super.setBuildLoggerManager(buildLoggerManager);
        this.getGitRepository().setBuildLoggerManager(buildLoggerManager);
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.getGitRepository().setI18nResolver(i18nResolver);
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
        this.getGitRepository().setEncryptionService(encryptionService);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        super.setCustomVariableContext(customVariableContext);
        this.getGitRepository().setCustomVariableContext(customVariableContext);
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.getGitRepository().setCapabilityContext(capabilityContext);
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.getGitRepository().setSshProxyService(sshProxyService);
    }

    public void setBranchIntegrationHelper(BranchIntegrationHelper branchIntegrationHelper) {
        this.getGitRepository().setBranchIntegrationHelper(branchIntegrationHelper);
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        super.setTemplateRenderer(templateRenderer);
        this.getGitRepository().setTemplateRenderer(templateRenderer);
    }

    @NotNull
    public String getName() {
        return "GitHub";
    }

    public String getHost() {
        return null;
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitHubRepository) {
            GitHubRepository ghRepo = (GitHubRepository)repository;
            return !new EqualsBuilder().append((Object)this.getRepository(), (Object)ghRepo.getRepository()).append((Object)this.getBranch(), (Object)ghRepo.getBranch()).isEquals();
        }
        return true;
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GITHUB_COMMAND_TIMEOUT, (Object)String.valueOf(180));
        buildConfiguration.clearTree(REPOSITORY_GITHUB_VERBOSE_LOGS);
        buildConfiguration.clearTree(REPOSITORY_GITHUB_FETCH_WHOLE_REPOSITORY);
        buildConfiguration.setProperty(REPOSITORY_GITHUB_USE_SHALLOW_CLONES, (Object)true);
        buildConfiguration.setProperty(REPOSITORY_GITHUB_USE_REMOTE_AGENT_CACHE, (Object)false);
        buildConfiguration.clearTree(REPOSITORY_GITHUB_USE_SUBMODULES);
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GITHUB_USERNAME, (Object)buildConfiguration.getString(REPOSITORY_GITHUB_USERNAME, "").trim());
        if (buildConfiguration.getBoolean(TEMPORARY_GITHUB_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GITHUB_PASSWORD, (Object)this.encryptionService.encrypt(buildConfiguration.getString(REPOSITORY_GITHUB_TEMPORARY_PASSWORD)));
        }
        buildConfiguration.setProperty(REPOSITORY_GITHUB_REPOSITORY, (Object)buildConfiguration.getString(REPOSITORY_GITHUB_REPOSITORY, "").trim());
        buildConfiguration.setProperty(REPOSITORY_GITHUB_BRANCH, (Object)buildConfiguration.getString(REPOSITORY_GITHUB_BRANCH, "").trim());
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        GitHubRepositoryAccessData accessData = GitHubRepositoryAccessData.builder(this.getAccessData()).repository(config.getString(REPOSITORY_GITHUB_REPOSITORY)).username(config.getString(REPOSITORY_GITHUB_USERNAME)).password(config.getString(REPOSITORY_GITHUB_PASSWORD)).branch((VcsBranch)new VcsBranchImpl(config.getString(REPOSITORY_GITHUB_BRANCH))).useShallowClones(config.getBoolean(REPOSITORY_GITHUB_USE_SHALLOW_CLONES)).useRemoteAgentCache(config.getBoolean(REPOSITORY_GITHUB_USE_REMOTE_AGENT_CACHE, false)).useSubmodules(config.getBoolean(REPOSITORY_GITHUB_USE_SUBMODULES)).commandTimeout(config.getInt(REPOSITORY_GITHUB_COMMAND_TIMEOUT, 180)).verboseLogs(config.getBoolean(REPOSITORY_GITHUB_VERBOSE_LOGS, false)).refSpecOverride(config.getBoolean(REPOSITORY_GITHUB_FETCH_WHOLE_REPOSITORY, false) ? "refs/heads/*" : null).build();
        this.setAccessData(accessData);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_GITHUB_USERNAME, (Object)this.getUsername());
        configuration.setProperty(REPOSITORY_GITHUB_PASSWORD, (Object)this.getEncryptedPassword());
        configuration.setProperty(REPOSITORY_GITHUB_REPOSITORY, (Object)this.getRepository());
        configuration.setProperty(REPOSITORY_GITHUB_BRANCH, (Object)this.getBranch());
        configuration.setProperty(REPOSITORY_GITHUB_USE_SHALLOW_CLONES, (Object)this.isUseShallowClones());
        configuration.setProperty(REPOSITORY_GITHUB_USE_REMOTE_AGENT_CACHE, (Object)this.isUseRemoteAgentCache());
        configuration.setProperty(REPOSITORY_GITHUB_USE_SUBMODULES, (Object)this.isUseSubmodules());
        configuration.setProperty(REPOSITORY_GITHUB_COMMAND_TIMEOUT, (Object)this.getCommandTimeout());
        configuration.setProperty(REPOSITORY_GITHUB_VERBOSE_LOGS, (Object)this.getVerboseLogs());
        configuration.setProperty(REPOSITORY_GITHUB_FETCH_WHOLE_REPOSITORY, (Object)(this.accessData.getRefSpecOverride() != null ? 1 : 0));
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        if (StringUtils.isBlank((String)buildConfiguration.getString(REPOSITORY_GITHUB_REPOSITORY))) {
            errorCollection.addError(REPOSITORY_GITHUB_REPOSITORY, this.i18nResolver.getText(REPOSITORY_GITHUB_ERROR_MISSING_REPOSITORY));
        }
        return errorCollection;
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        return this.getGitRepository().collectChangesForRevision(planKey, targetRevision);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.getGitRepository().collectChangesSinceLastBuild(planKey, lastVcsRevisionKey);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevision) throws RepositoryException {
        return this.getGitRepository().retrieveSourceCode(buildContext, vcsRevision, this.getSourceCodeDirectory(buildContext.getPlanResultKey().getPlanKey()));
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws RepositoryException {
        return this.getGitRepository().retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory, int depth) throws RepositoryException {
        return this.getGitRepository().retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory, depth);
    }

    public String getUsername() {
        return this.accessData.getUsername();
    }

    public String getRepository() {
        return this.accessData.getRepository();
    }

    public String getBranch() {
        return this.accessData.getVcsBranch().getName();
    }

    public boolean isUseShallowClones() {
        return this.accessData.isUseShallowClones();
    }

    public boolean isUseRemoteAgentCache() {
        return this.accessData.isUseRemoteAgentCache();
    }

    public String getEncryptedPassword() {
        return this.accessData.getPassword();
    }

    public boolean isUseSubmodules() {
        return this.accessData.isUseSubmodules();
    }

    public int getCommandTimeout() {
        return this.accessData.getCommandTimeout();
    }

    public boolean getVerboseLogs() {
        return this.accessData.isVerboseLogs();
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@Nullable String context) throws RepositoryException {
        return this.getGitRepository().getOpenBranches(context);
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return this.accessData.getVcsBranch();
    }

    public void setVcsBranch(@NotNull VcsBranch vcsBranch) {
        this.setAccessData(GitHubRepositoryAccessData.builder(this.accessData).branch(vcsBranch).build());
    }

    public CacheId getCacheId(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        switch (cachableOperation) {
            case BRANCH_DETECTION: {
                return new CacheId((Repository)this, new String[]{this.getGitRepository().getAccessData().getRepositoryUrl()});
            }
        }
        return null;
    }

    public boolean isCachingSupportedFor(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return cachableOperation == CachingAwareRepository.CachableOperation.BRANCH_DETECTION;
    }

    public CommitContext getLastCommit() throws RepositoryException {
        return this.getGitRepository().getLastCommit();
    }

    public CommitContext getFirstCommit() throws RepositoryException {
        return this.getGitRepository().getFirstCommit();
    }

    public boolean mergeWorkspaceWith(@NotNull BuildContext buildContext, @NotNull File file, @NotNull String s) throws RepositoryException {
        return this.getGitRepository().mergeWorkspaceWith(buildContext, file, s);
    }

    public boolean isMergingSupported() {
        return this.getGitRepository().isMergingSupported();
    }

    public void pushRevision(@NotNull File file, @Nullable String s) throws RepositoryException {
        this.getGitRepository().pushRevision(file, s);
    }

    @NotNull
    public String commit(@NotNull File file, @NotNull String s) throws RepositoryException {
        return this.getGitRepository().commit(file, s);
    }

    public String getOptionDescription() {
        String capabilitiesLink = RequestCacheThreadLocal.getContextPath() + "/admin/agent/configureSharedLocalCapabilities.action";
        return this.i18nResolver.getText("repository.git.description", new Serializable[]{this.getGitRepository().getGitCapability(), capabilitiesLink});
    }

    public GitHubRepositoryAccessData getAccessData() {
        return this.accessData;
    }

    public void setAccessData(GitHubRepositoryAccessData gitHubAccessData) {
        this.accessData = gitHubAccessData;
        this.getGitRepository().setAccessData(GitRepositoryAccessData.builder(this.getGitRepository().getAccessData()).repositoryUrl("https://github.com/" + gitHubAccessData.getRepository() + ".git").username(gitHubAccessData.getUsername()).password(gitHubAccessData.getPassword()).branch(gitHubAccessData.getVcsBranch()).sshKey(null).sshPassphrase(null).authenticationType(GitAuthenticationType.PASSWORD).useShallowClones(gitHubAccessData.isUseShallowClones()).useSubmodules(gitHubAccessData.isUseSubmodules()).useRemoteAgentCache(gitHubAccessData.isUseRemoteAgentCache()).commandTimeout(gitHubAccessData.getCommandTimeout()).verboseLogs(gitHubAccessData.isVerboseLogs()).refSpecOverride(gitHubAccessData.getRefSpecOverride()).build());
    }

    @Override
    public GitRepository getGitRepository() {
        return this.gitRepository;
    }

    public boolean usePollingForBranchDetection() {
        return true;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        return this.getGitRepository().getCustomVariables();
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables() {
        return this.getGitRepository().getPlanRepositoryVariables();
    }
}

