/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.ssh.ProxyRegistrationInfo;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRepositoryAccessData
implements Serializable {
    private String repositoryUrl;
    private VcsBranch branch;
    private String username;
    private String password;
    private String sshKey;
    private String sshPassphrase;
    private GitAuthenticationType authenticationType;
    private boolean useShallowClones;
    private boolean useRemoteAgentCache;
    private boolean useSubmodules;
    private int commandTimeout;
    private boolean verboseLogs;
    private Long sharedCredentialsId;
    private String refSpecOverride;
    private transient ProxyRegistrationInfo proxyRegistrationInfo;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NotNull GitRepositoryAccessData accessData) {
        return new Builder().clone(accessData);
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public VcsBranch getVcsBranch() {
        return this.branch;
    }

    public String getUsername() {
        return this.username;
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSshKey() {
        return this.sshKey;
    }

    public String getSshPassphrase() {
        return this.sshPassphrase;
    }

    public GitAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    public boolean isUseRemoteAgentCache() {
        return this.useRemoteAgentCache;
    }

    public boolean isUseSubmodules() {
        return this.useSubmodules;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public ProxyRegistrationInfo getProxyRegistrationInfo() {
        return this.proxyRegistrationInfo;
    }

    public void setProxyRegistrationInfo(ProxyRegistrationInfo proxyRegistrationInfo) {
        this.proxyRegistrationInfo = proxyRegistrationInfo;
    }

    @Nullable
    public Long getSharedCredentialsId() {
        return this.sharedCredentialsId;
    }

    public void setSharedCredentialsId(Long sharedCredentialsId) {
        this.sharedCredentialsId = sharedCredentialsId;
    }

    @Nullable
    public String getRefSpecOverride() {
        return this.refSpecOverride;
    }

    public static final class Builder {
        private String repositoryUrl;
        private VcsBranch branch;
        private String username;
        private String password;
        private String sshKey;
        private String sshPassphrase;
        private GitAuthenticationType authenticationType;
        private boolean useShallowClones;
        private boolean useRemoteAgentCache;
        private boolean useSubmodules;
        private int commandTimeout;
        private boolean verboseLogs;
        private Long sharedCredentialsId;
        private String refSpecOverride;

        public Builder clone(GitRepositoryAccessData gitRepositoryAccessData) {
            this.repositoryUrl = gitRepositoryAccessData.repositoryUrl;
            this.branch = gitRepositoryAccessData.branch;
            this.username = gitRepositoryAccessData.username;
            this.password = gitRepositoryAccessData.password;
            this.sshKey = gitRepositoryAccessData.sshKey;
            this.sshPassphrase = gitRepositoryAccessData.sshPassphrase;
            this.authenticationType = gitRepositoryAccessData.authenticationType;
            this.useShallowClones = gitRepositoryAccessData.useShallowClones;
            this.useSubmodules = gitRepositoryAccessData.useSubmodules;
            this.useRemoteAgentCache = gitRepositoryAccessData.useRemoteAgentCache;
            this.commandTimeout = gitRepositoryAccessData.commandTimeout;
            this.verboseLogs = gitRepositoryAccessData.verboseLogs;
            this.sharedCredentialsId = gitRepositoryAccessData.sharedCredentialsId;
            this.refSpecOverride = gitRepositoryAccessData.refSpecOverride;
            return this;
        }

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public Builder branch(VcsBranch branch) {
            this.branch = branch;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        public Builder sshPassphrase(String sshPassphrase) {
            this.sshPassphrase = sshPassphrase;
            return this;
        }

        public Builder authenticationType(GitAuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public Builder useShallowClones(boolean useShallowClones) {
            this.useShallowClones = useShallowClones;
            return this;
        }

        public Builder useRemoteAgentCache(boolean useRemoteAgentCache) {
            this.useRemoteAgentCache = useRemoteAgentCache;
            return this;
        }

        public Builder useSubmodules(boolean useSubmodules) {
            this.useSubmodules = useSubmodules;
            return this;
        }

        public Builder commandTimeout(int commandTimeout) {
            this.commandTimeout = commandTimeout;
            return this;
        }

        public Builder verboseLogs(boolean verboseLogs) {
            this.verboseLogs = verboseLogs;
            return this;
        }

        public Builder sharedCredentialsId(@Nullable Long sharedCredentialsId) {
            this.sharedCredentialsId = sharedCredentialsId;
            return this;
        }

        public Builder refSpecOverride(String refSpecOverride) {
            this.refSpecOverride = refSpecOverride;
            return this;
        }

        public GitRepositoryAccessData build() {
            GitRepositoryAccessData data = new GitRepositoryAccessData();
            data.repositoryUrl = this.repositoryUrl;
            data.branch = this.branch;
            data.username = this.username;
            data.password = this.password;
            data.sshKey = this.sshKey;
            data.sshPassphrase = this.sshPassphrase;
            data.authenticationType = this.authenticationType;
            data.useShallowClones = this.useShallowClones;
            data.useRemoteAgentCache = this.useRemoteAgentCache;
            data.useSubmodules = this.useSubmodules;
            data.commandTimeout = this.commandTimeout;
            data.verboseLogs = this.verboseLogs;
            data.sharedCredentialsId = this.sharedCredentialsId;
            data.refSpecOverride = this.refSpecOverride;
            return data;
        }
    }
}

