/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitCacheDirectoryUtils;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitRepositoryFacade;
import com.atlassian.bamboo.plugins.git.messages.DeleteSpecifiedGitCacheDirectoriesOnAgentMessage;
import com.atlassian.bamboo.plugins.git.messages.DeleteUnusedGitCacheDirectoriesOnAgentMessage;
import com.atlassian.bamboo.repository.CacheDescription;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.v2.build.agent.AgentCommandSender;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.xwork.ValidationAware;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCacheHandler {
    private CachedPlanManager cachedPlanManager;
    private BuildDirectoryManager buildDirectoryManager;
    private GitCacheDirectoryUtils gitCacheDirectoryUtils;
    private I18nResolver i18nResolver;
    private AgentManager agentManager;
    private AgentCommandSender agentCommandSender;

    @NotNull
    public Collection<CacheDescription> getCacheDescriptions() {
        ArrayList cacheDescriptions = Lists.newArrayList();
        HashMultimap plans = HashMultimap.create();
        HashMap repositories = Maps.newHashMap();
        for (ImmutableChain plan : this.cachedPlanManager.getPlans(ImmutableChain.class)) {
            for (GitRepository gitRepository : (Iterable)GitRepositoryFacade.GIT_REPOSITORIES_OF_PLAN.apply((Object)plan)) {
                File cacheDir = gitRepository.getCacheDirectory();
                plans.put((Object)cacheDir, (Object)plan);
                if (repositories.containsKey(cacheDir)) continue;
                repositories.put(cacheDir, gitRepository);
            }
        }
        for (File cacheDir : repositories.keySet()) {
            cacheDescriptions.add(GitCacheHandler.createCacheDescription((GitRepository)repositories.get(cacheDir), cacheDir, plans.get((Object)cacheDir)));
        }
        Set<File> unusedDirs = this.findUnusedCaches(plans.keySet());
        for (File unusedDir : unusedDirs) {
            String description = "Descriptions for unused caches is unsupported";
            CacheDescription.FileBased cacheDescription = new CacheDescription.FileBased(unusedDir, "Descriptions for unused caches is unsupported", Collections.emptyList());
            cacheDescriptions.add(cacheDescription);
        }
        return cacheDescriptions;
    }

    @NotNull
    private static CacheDescription createCacheDescription(@NotNull GitRepository repository, @NotNull File cacheDir, @NotNull Collection<ImmutablePlan> usingPlans) {
        GitRepositoryAccessData accessData = repository.getSubstitutedAccessData();
        StringBuilder sb = new StringBuilder();
        sb.append("URL: '").append(accessData.getRepositoryUrl()).append('\'');
        if (accessData.getUsername() != null) {
            sb.append(", Username: '").append(accessData.getUsername()).append('\'');
        }
        ArrayList<String> features = new ArrayList<String>(2);
        if (accessData.isUseRemoteAgentCache()) {
            features.add("remote agent caching");
        }
        if (!features.isEmpty()) {
            sb.append(" (").append(StringUtils.join(features, (String)", ")).append(")");
        }
        String description = sb.toString();
        return new CacheDescription.FileBased(cacheDir, description, usingPlans);
    }

    public void deleteCaches(@NotNull Collection<String> keys, @NotNull ValidationAware feedback) {
        if (keys.isEmpty()) {
            feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.nothingToDelete"));
            return;
        }
        File cacheRootDir = this.getCacheRootDir();
        for (String key : keys) {
            Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((String)key), (Object)"directory traversal blocked");
            File cacheCandidate = new File(cacheRootDir, key);
            if (cacheCandidate.exists()) {
                try {
                    FileUtils.deleteDirectory((File)cacheCandidate);
                    feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.success", new Serializable[]{key}));
                }
                catch (IOException e) {
                    feedback.addActionError(this.i18nResolver.getText("manageCaches.delete.git.failed", new Serializable[]{key, e.getLocalizedMessage()}));
                }
                continue;
            }
            feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.skipped", new Serializable[]{key}));
        }
        DeleteSpecifiedGitCacheDirectoriesOnAgentMessage message = new DeleteSpecifiedGitCacheDirectoriesOnAgentMessage(keys, this.gitCacheDirectoryUtils);
        Collection<String> agentNames = this.sendMessageToRemoteAgents(message);
        if (!agentNames.isEmpty()) {
            String names = StringUtils.join(agentNames, (String)", ");
            feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.scheduling.deleteSpecific", new Serializable[]{names}));
        }
    }

    public void deleteUnusedCaches(@NotNull ValidationAware feedback) {
        Iterable gitRepositories = Iterables.concat((Iterable)Iterables.transform((Iterable)this.cachedPlanManager.getPlans(ImmutableChain.class), GitRepositoryFacade.GIT_REPOSITORIES_OF_PLAN));
        Iterable cacheDirectories = Iterables.transform((Iterable)gitRepositories, (Function)new Function<GitRepository, File>(){

            public File apply(@Nullable GitRepository input) {
                return input.getCacheDirectory();
            }
        });
        ImmutableSet usedCaches = ImmutableSet.copyOf((Iterable)cacheDirectories);
        Set<File> unusedCacheDirs = this.findUnusedCaches((Set<File>)usedCaches);
        for (File unusedCacheDir : unusedCacheDirs) {
            String sha = unusedCacheDir.getName();
            try {
                FileUtils.deleteDirectory((File)unusedCacheDir);
                feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.unused.success", new Serializable[]{sha}));
            }
            catch (IOException e) {
                feedback.addActionError(this.i18nResolver.getText("manageCaches.delete.git.unused.failed", new Serializable[]{sha, e.getLocalizedMessage()}));
            }
        }
        Collection usedSHAs = Collections2.transform((Collection)usedCaches, (Function)new Function<File, String>(){

            public String apply(File from) {
                return from.getName();
            }
        });
        DeleteUnusedGitCacheDirectoriesOnAgentMessage message = new DeleteUnusedGitCacheDirectoriesOnAgentMessage(usedSHAs, this.gitCacheDirectoryUtils);
        Collection<String> agentNames = this.sendMessageToRemoteAgents(message);
        if (!agentNames.isEmpty()) {
            String names = StringUtils.join(agentNames, (String)", ");
            feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.scheduling.deleteUnused", new Serializable[]{names}));
        }
    }

    @NotNull
    private Collection<String> sendMessageToRemoteAgents(final RemoteBambooMessage message) {
        final ArrayList agentNames = Lists.newArrayList();
        for (final BuildAgent buildAgent : Iterables.filter((Iterable)this.agentManager.getAllAgents(), (Predicate)BambooPredicates.buildAgentIsActive())) {
            buildAgent.accept(new BuildAgent.BuildAgentVisitor(){

                public void visitLocal(LocalBuildAgent localBuildAgent) {
                }

                public void visitRemote(BuildAgent remoteBuildAgent) {
                    agentNames.add(buildAgent.getName());
                    GitCacheHandler.this.agentCommandSender.send(message, Long.valueOf(buildAgent.getId()));
                }
            });
        }
        return agentNames;
    }

    @NotNull
    private Set<File> findUnusedCaches(@NotNull Set<File> usedCaches) {
        Object[] cacheDirs = this.getCacheRootDir().listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        return ArrayUtils.isEmpty((Object[])cacheDirs) ? Collections.emptySet() : Sets.difference((Set)ImmutableSet.copyOf((Object[])cacheDirs), usedCaches);
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setAgentCommandSender(AgentCommandSender agentCommandSender) {
        this.agentCommandSender = agentCommandSender;
    }

    public void setGitCacheDirectoryUtils(GitCacheDirectoryUtils gitCacheDirectoryUtils) {
        this.gitCacheDirectoryUtils = gitCacheDirectoryUtils;
    }

    @NotNull
    private File getCacheRootDir() {
        return GitCacheDirectory.getCacheDirectoryRoot(this.buildDirectoryManager.getBaseBuildWorkingDirectory());
    }
}

