/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.rest.utils.Get;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class GitHubAccessor {
    private static final Logger log = Logger.getLogger(GitHubAccessor.class);
    static final String GITHUB_API_BASE_URL = new SystemProperty(false, new String[]{"atlassian.bamboo.github.api.base.url", "ATLASSIAN_BAMBOO_GITHUB_API_BASE_URL"}).getValue("https://api.github.com/");
    private static final String JSON_ERROR_MESSAGE_FIELD = "message";
    private final String username;
    private final String password;
    private final boolean onlyPublic;

    public GitHubAccessor(String username, String password) {
        this.username = username;
        this.password = password;
        this.onlyPublic = StringUtils.isBlank((String)password);
    }

    public Iterable<String> getAccessibleRepositories() throws IOException, GitHubException {
        Iterable<String> userRepos = this.getUserRepositories();
        ArrayList orgRepos = Lists.newArrayList();
        for (String org : this.getUserOrganisations()) {
            Iterables.addAll((Collection)orgRepos, this.getOrganisationRepositories(org));
        }
        return Iterables.concat(userRepos, (Iterable)orgRepos);
    }

    public Map<String, Iterable<String>> getAccessibleRepositoriesAndBranches() throws IOException, GitHubException {
        Iterable<String> accessibleRepositories = this.getAccessibleRepositories();
        LinkedHashMap accessibleRepositoriesAndBranches = Maps.newLinkedHashMap();
        for (String accessibleRepository : accessibleRepositories) {
            accessibleRepositoriesAndBranches.put(accessibleRepository, this.getBranches(accessibleRepository));
        }
        return accessibleRepositoriesAndBranches;
    }

    public Iterable<String> getBranches(String userRepo) throws IOException, GitHubException {
        JSONArray repoJson = this.getJSONArrayResponseFromUrl("repos/" + userRepo + "/branches");
        return this.foldArrayAndSort(repoJson, "name");
    }

    public Iterable<String> getUserOrganisations() throws IOException, GitHubException {
        JSONArray repoJson = this.getJSONArrayResponseFromUrl(this.getEndPointForCurrentCredentials("orgs"));
        return this.foldArrayAndSort(repoJson, "login");
    }

    private String getEndPointForCurrentCredentials(String endPath) {
        return this.onlyPublic ? "users/" + this.username + "/" + endPath : "user/" + endPath;
    }

    public Iterable<String> getUserRepositories() throws IOException, GitHubException {
        return this.getRepositories(this.getEndPointForCurrentCredentials("repos"));
    }

    public Iterable<String> getOrganisationRepositories(String org) throws IOException, GitHubException {
        return this.getRepositories("orgs/" + org + "/repos");
    }

    private Iterable<String> getRepositories(String endpoint) throws IOException, GitHubException {
        JSONArray json = this.getJSONArrayResponseFromUrl(endpoint);
        return this.foldArrayAndSort(json, "full_name");
    }

    private JSONArray getJSONArrayResponseFromUrl(String url) throws IOException, GitHubException {
        String stringFromUrl = this.getStringFromUrl(GITHUB_API_BASE_URL + url);
        try {
            return new JSONArray(stringFromUrl);
        }
        catch (JSONException e) {
            JSONObject jsonObject = this.createQuietly(stringFromUrl);
            if (jsonObject != null && jsonObject.has(JSON_ERROR_MESSAGE_FIELD)) {
                throw new GitHubException(this.getStringQuietly(jsonObject));
            }
            throw new GitHubException(e);
        }
    }

    @Nullable
    private String getStringQuietly(JSONObject jsonObject) {
        try {
            return jsonObject.getString(JSON_ERROR_MESSAGE_FIELD);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Nullable
    private JSONObject createQuietly(String stringFromUrl) {
        try {
            return new JSONObject(stringFromUrl);
        }
        catch (JSONException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromUrl(String url) throws IOException {
        Get call = new Get(url);
        if (!this.onlyPublic) {
            call.setBasicCredentials(this.username, this.password);
        }
        try {
            String response;
            call.execute();
            String string = response = IOUtils.toString((InputStream)call.getResponseAsStream());
            return string;
        }
        finally {
            call.release();
        }
    }

    private List<String> foldArrayAndSort(JSONArray repoJson, String field) throws GitHubException {
        return Ordering.natural().sortedCopy(this.foldArray(repoJson, field));
    }

    private Iterable<String> foldArray(JSONArray jsonArray, String field) throws GitHubException {
        try {
            ArrayList repositories = Lists.newArrayList();
            for (int index = 0; index < jsonArray.length(); ++index) {
                JSONObject jsonRepository = jsonArray.getJSONObject(index);
                String repository = jsonRepository.getString(field);
                repositories.add(repository);
            }
            return repositories;
        }
        catch (JSONException e) {
            throw new GitHubException(e);
        }
    }

    public static class GitHubException
    extends Exception {
        public GitHubException(String message) {
            super(message);
        }

        public GitHubException(JSONException e) {
            super((Throwable)e);
        }

        public boolean isAuthError() {
            return this.getMessage().equalsIgnoreCase("Bad credentials");
        }
    }
}

