/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.git.AbstractGitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCommandBuilder;
import com.atlassian.bamboo.plugins.git.GitCommandProcessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.ScpAwareUri;
import com.atlassian.bamboo.plugins.git.UriUtils;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataBuilder;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.bamboo.ssh.ProxyException;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.util.CallableResultCache;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeGitOperationHelper
extends AbstractGitOperationHelper
implements GitOperationHelper {
    private static final Logger log = Logger.getLogger(NativeGitOperationHelper.class);
    private static final String FAKE_ORIGIN = "file://nothing";
    protected SshProxyService sshProxyService;
    GitCommandProcessor gitCommandProcessor;
    private static final CallableResultCache<ImmutableMap<String, String>> GET_REMOTE_REFS_CACHE = CallableResultCache.buildAlwaysInvalidating((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).recordStats(), (CacheAwareness.CacheInfo[])new CacheAwareness.CacheInfo[]{CacheAwareness.BRANCH_DETECTION, CacheAwareness.CHANGE_DETECTION});

    public NativeGitOperationHelper(@NotNull GitRepository repository, @NotNull GitRepositoryAccessData accessData, @NotNull SshProxyService sshProxyService, @NotNull BuildLogger buildLogger, @NotNull I18nResolver i18nResolver, @NotNull TrustedKeyHelper trustedKeyHelper) throws RepositoryException {
        super(accessData, buildLogger, i18nResolver, trustedKeyHelper);
        this.sshProxyService = sshProxyService;
        String passwordToObfuscate = accessData.getPassword();
        if (StringUtils.isEmpty((CharSequence)passwordToObfuscate)) {
            try {
                passwordToObfuscate = new URIish(accessData.getRepositoryUrl()).getPass();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.gitCommandProcessor = new GitCommandProcessor(repository.getGitCapability(), buildLogger, passwordToObfuscate, accessData.getCommandTimeout(), accessData.isVerboseLogs(), trustedKeyHelper);
        this.gitCommandProcessor.checkGitExistenceInSystem(repository.getWorkingDirectory());
        this.gitCommandProcessor.setSshCommand(repository.getSshCapability());
    }

    public NativeGitOperationHelper(@NotNull AbstractGitExecutor repository, @NotNull GitRepositoryAccessData accessData, @NotNull SshProxyService sshProxyService, @NotNull BuildLogger buildLogger, @NotNull I18nResolver i18nResolver, @NotNull TrustedKeyHelper trustedKeyHelper) throws RepositoryException {
        super(accessData, buildLogger, i18nResolver, trustedKeyHelper);
        this.sshProxyService = sshProxyService;
        String passwordToObfuscate = accessData.getPassword();
        if (StringUtils.isEmpty((CharSequence)passwordToObfuscate)) {
            try {
                passwordToObfuscate = new URIish(accessData.getRepositoryUrl()).getPass();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.gitCommandProcessor = new GitCommandProcessor(repository.getGitCapability(), buildLogger, passwordToObfuscate, accessData.getCommandTimeout(), accessData.isVerboseLogs(), trustedKeyHelper);
        this.gitCommandProcessor.checkGitExistenceInSystem(repository.getWorkingDirectory(accessData));
        this.gitCommandProcessor.setSshCommand(repository.getSshCapability());
    }

    @Override
    public void pushRevision(@NotNull File sourceDirectory, @NotNull String revision) throws RepositoryException {
        Pair<String, Boolean> possibleBranch = this.gitCommandProcessor.getPossibleBranchNameForCheckout(sourceDirectory, revision, this.accessData.getVcsBranch().getName());
        if (((Boolean)possibleBranch.getSecond()).booleanValue() || StringUtils.isBlank((CharSequence)((CharSequence)possibleBranch.getFirst()))) {
            throw new RepositoryException("Can't guess branch name for revision " + revision + " when trying to perform push.");
        }
        GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createRemoteCommandBuilder(proxiedAccessData, "push", proxiedAccessData.getRepositoryUrl(), (String)possibleBranch.getFirst());
        if (proxiedAccessData.isVerboseLogs()) {
            commandBuilder.verbose(true);
        }
        this.gitCommandProcessor.runCommand(commandBuilder, sourceDirectory);
    }

    @Override
    public String commit(@NotNull File sourceDirectory, @NotNull String message, @NotNull String committerName, @NotNull String comitterEmail) throws RepositoryException {
        if (!this.containsSomethingToCommit(sourceDirectory)) {
            log.debug((Object)"Nothing to commit");
            return this.getCurrentRevision(sourceDirectory);
        }
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createLocalCommandBuilder("commit", "--all", "-m", message).env((Map<String, String>)this.identificationVariables(committerName, comitterEmail));
        if (this.accessData.isVerboseLogs()) {
            commandBuilder.verbose(true);
        }
        this.gitCommandProcessor.runCommand(commandBuilder, sourceDirectory);
        return this.getCurrentRevision(sourceDirectory);
    }

    public ImmutableMap<String, String> identificationVariables(@NotNull String name, @NotNull String email) {
        return ImmutableMap.of((Object)"GIT_COMMITTER_NAME", (Object)name, (Object)"GIT_COMMITTER_EMAIL", (Object)email, (Object)"GIT_AUTHOR_NAME", (Object)name, (Object)"GIT_AUTHOR_EMAIL", (Object)email);
    }

    @VisibleForTesting
    protected GitRepositoryAccessData adjustRepositoryAccess(@NotNull GitRepositoryAccessData accessData) throws RepositoryException {
        boolean needsProxy;
        boolean sshKeypair = accessData.getAuthenticationType() == GitAuthenticationType.SSH_KEYPAIR;
        boolean sshWithPassword = UriUtils.requiresSshTransport(accessData.getRepositoryUrl()) && accessData.getAuthenticationType() == GitAuthenticationType.PASSWORD;
        boolean bl = needsProxy = sshKeypair || sshWithPassword;
        if (needsProxy) {
            GitRepositoryAccessData.Builder proxyAccessDataBuilder = GitRepositoryAccessData.builder(accessData);
            GitRepositoryAccessData proxyAccessData = proxyAccessDataBuilder.proxied(true).build();
            ScpAwareUri repositoryUri = ScpAwareUri.create(accessData.getRepositoryUrl());
            if (UriUtils.requiresSshTransport(repositoryUri)) {
                try {
                    String username = UriUtils.extractUsername(accessData.getRepositoryUrl());
                    if (username != null) {
                        proxyAccessData.setUsername(username);
                    }
                    ProxyConnectionDataBuilder proxyConnectionDataBuilder = this.sshProxyService.createProxyConnectionDataBuilder().withRemoteHost(repositoryUri.getHost()).withRemotePort(repositoryUri.getPort() == -1 ? null : Integer.valueOf(repositoryUri.getPort())).withRemoteUserName((String)StringUtils.defaultIfEmpty((CharSequence)proxyAccessData.getUsername(), (CharSequence)repositoryUri.getUserInfo())).withErrorReceiver((ProxyErrorReceiver)this.gitCommandProcessor);
                    if (repositoryUri.isRelativePath()) {
                        proxyConnectionDataBuilder.withRemotePathMapping(repositoryUri.getAbsolutePath(), repositoryUri.getRawPath());
                    }
                    switch (accessData.getAuthenticationType()) {
                        case SSH_KEYPAIR: {
                            proxyConnectionDataBuilder.withKeyFromString(proxyAccessData.getSshKey(), proxyAccessData.getSshPassphrase());
                            break;
                        }
                        case PASSWORD: {
                            proxyConnectionDataBuilder.withRemotePassword(StringUtils.defaultString((String)proxyAccessData.getPassword()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Proxy does not know how to handle " + (Object)((Object)accessData.getAuthenticationType()));
                        }
                    }
                    ProxyConnectionData connectionData = proxyConnectionDataBuilder.build();
                    proxyAccessData.setProxyRegistrationInfo(this.sshProxyService.register(connectionData));
                    URI repositoryViaProxy = UriUtils.getUriViaProxy(proxyAccessData, repositoryUri);
                    proxyAccessData.setRepositoryUrl(repositoryViaProxy.toString());
                }
                catch (IOException e) {
                    if (e.getMessage().contains("exception using cipher - please check password and data.")) {
                        throw new RepositoryException(this.buildLogger.addErrorLogEntry("Encryption exception - please check ssh keyfile passphrase."), (Throwable)e);
                    }
                    throw new RepositoryException("Cannot decode connection params", (Throwable)e);
                }
                catch (ProxyException e) {
                    throw new RepositoryException("Cannot create SSH proxy", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    throw new RepositoryException("Remote repository URL invalid", (Throwable)e);
                }
                return proxyAccessData;
            }
        } else {
            GitRepositoryAccessData credentialsAwareAccessData = GitRepositoryAccessData.builder(accessData).build();
            String repositoryUrl = this.getUrlWithNormalisedCredentials(credentialsAwareAccessData);
            credentialsAwareAccessData.setRepositoryUrl(repositoryUrl);
            return credentialsAwareAccessData;
        }
        return accessData;
    }

    @Override
    public boolean merge(@NotNull File workspaceDir, @NotNull String targetRevision, @NotNull String committerName, @NotNull String committerEmail) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createLocalCommandBuilder("merge", "--no-commit", targetRevision).env((Map<String, String>)this.identificationVariables(committerName, committerEmail));
        String headRevisionBeforeMerge = this.getCurrentRevision(workspaceDir);
        this.gitCommandProcessor.runMergeCommand(commandBuilder, workspaceDir);
        if (this.containsSomethingToCommit(workspaceDir)) {
            return true;
        }
        String headRevisionAfterMerge = this.getCurrentRevision(workspaceDir);
        log.debug((Object)("Revision before merge: " + headRevisionBeforeMerge + ", after merge: " + headRevisionAfterMerge));
        return !headRevisionAfterMerge.equals(headRevisionBeforeMerge);
    }

    @Override
    public Pair<Boolean, String> mergeAndReturnHead(@NotNull File workspaceDir, @NotNull String currentRevision, @NotNull String targetRevision, @NotNull String committerName, @NotNull String committerEmail) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createLocalCommandBuilder("merge", "--no-commit", targetRevision).env((Map<String, String>)this.identificationVariables(committerName, committerEmail));
        String headRevisionBeforeMerge = this.getCurrentRevision(workspaceDir);
        this.gitCommandProcessor.runMergeCommand(commandBuilder, workspaceDir);
        if (this.containsSomethingToCommit(workspaceDir)) {
            return Pair.make((Object)true, (Object)currentRevision);
        }
        String headRevisionAfterMerge = this.getCurrentRevision(workspaceDir);
        log.debug((Object)("Revision before merge: " + headRevisionBeforeMerge + ", after merge: " + headRevisionAfterMerge));
        return Pair.make((Object)false, (Object)headRevisionAfterMerge);
    }

    private boolean containsSomethingToCommit(@NotNull File workspaceDir) throws RepositoryException {
        boolean hasModifiedFiles;
        String mergeHead = this.getShaOfRefIfExists(workspaceDir, "MERGE_HEAD");
        if (mergeHead != null) {
            log.debug((Object)"Has modified index");
            return true;
        }
        List<String> strings = this.gitCommandProcessor.runStatusCommand(workspaceDir);
        boolean bl = hasModifiedFiles = !strings.isEmpty();
        if (hasModifiedFiles) {
            log.debug((Object)"Has modified files");
        }
        return hasModifiedFiles;
    }

    @NotNull
    private String getUrlWithNormalisedCredentials(GitRepositoryAccessData repositoryAccessData) {
        try {
            URIish repositoryLocation = new URIish(repositoryAccessData.getRepositoryUrl());
            URIish normalisedUri = UriUtils.normaliseRepositoryLocation(repositoryAccessData.getUsername(), repositoryAccessData.getPassword(), repositoryLocation, false);
            return normalisedUri.toPrivateString();
        }
        catch (URISyntaxException e) {
            String message = "Cannot parse remote URI: " + repositoryAccessData.getRepositoryUrl();
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void createLocalRepository(File sourceDirectory, @Nullable File cacheDirectory, boolean lfs) throws RepositoryException {
        File gitDirectory;
        if (!sourceDirectory.exists()) {
            log.debug((Object)("Creating local repository " + sourceDirectory));
            boolean success = sourceDirectory.mkdirs();
            if (!success) {
                throw new IllegalStateException("Can't create local repository folder " + sourceDirectory);
            }
        }
        if (!(gitDirectory = new File(sourceDirectory, ".git")).exists()) {
            this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.creatingGitRepository", new Serializable[]{gitDirectory}));
            if (cacheDirectory == null) {
                this.gitCommandProcessor.runInitCommand(sourceDirectory);
                this.gitCommandProcessor.addOrigin(FAKE_ORIGIN, sourceDirectory);
            } else {
                this.gitCommandProcessor.runLocalCloneCommand(sourceDirectory, cacheDirectory);
            }
        } else if (cacheDirectory != null) {
            if (lfs) {
                if (this.isEmpty(sourceDirectory)) {
                    try {
                        this.gitCommandProcessor.runCloneCommand(sourceDirectory, cacheDirectory, this.accessData);
                    }
                    catch (RepositoryException e) {
                        this.gitCommandProcessor.runLfsLogCommand(sourceDirectory);
                        throw e;
                    }
                } else {
                    this.gitCommandProcessor.runLocalFetchCommand(sourceDirectory);
                }
            } else {
                this.gitCommandProcessor.setOriginToLocalDirectory(cacheDirectory, sourceDirectory);
                this.gitCommandProcessor.runLocalFetchCommand(sourceDirectory);
            }
        }
    }

    private boolean isEmpty(File directory) {
        String[] list = directory.list();
        return list == null || list.length == 0;
    }

    protected void closeProxy(@NotNull GitRepositoryAccessData accessData) {
        this.sshProxyService.unregister(accessData.getProxyRegistrationInfo());
    }

    @Override
    @NotNull
    public String checkout(@Nullable File cacheDirectory, @NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String ignored) throws RepositoryException {
        this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.checkingOutRevision", new Serializable[]{targetRevision}));
        GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
        try {
            this.createLocalRepository(sourceDirectory, cacheDirectory, this.accessData.isLfs());
            File lck = new File(sourceDirectory, "index.lock");
            BambooPathUtils.deleteQuietly((Path)lck.toPath());
            this.gitCommandProcessor.runCheckoutCommand(sourceDirectory, targetRevision, this.accessData.getVcsBranch().getName(), this.accessData.isLfs());
            if (this.accessData.isUseSubmodules() || this.accessData.isLfs()) {
                this.gitCommandProcessor.setOrigin(proxiedAccessData.getRepositoryUrl(), sourceDirectory);
            }
            if (this.accessData.isUseSubmodules()) {
                this.gitCommandProcessor.runSubmoduleUpdateCommand(sourceDirectory);
            }
            if (this.accessData.isLfs()) {
                try {
                    this.gitCommandProcessor.runLfsPullCommand(sourceDirectory);
                }
                catch (RepositoryException e) {
                    this.gitCommandProcessor.runLfsLogCommand(sourceDirectory);
                    throw e;
                }
            }
            String string = targetRevision;
            return string;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.checkoutFailed", new Serializable[]{targetRevision})) + e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeProxy(proxiedAccessData);
            if (cacheDirectory != null) {
                this.gitCommandProcessor.setOriginToLocalDirectory(cacheDirectory, sourceDirectory);
            } else {
                this.gitCommandProcessor.setOrigin(FAKE_ORIGIN, sourceDirectory);
            }
        }
    }

    @Override
    public void fetch(@NotNull File sourceDirectory, @NotNull String targetBranchOrRevision, boolean useShallow) throws RepositoryException {
        this.fetch(sourceDirectory, HashAndSource.hashAndBranch(targetBranchOrRevision, targetBranchOrRevision), useShallow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(@NotNull File sourceDirectory, @NotNull HashAndSource hashAndSource, boolean useShallow) throws RepositoryException {
        block8: {
            String resolvedRef = "(unresolved) " + hashAndSource;
            try {
                GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
                this.createLocalRepository(sourceDirectory, null, this.accessData.isLfs());
                try {
                    resolvedRef = this.resolveRef(sourceDirectory, hashAndSource, proxiedAccessData);
                    this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.fetching", new Serializable[]{resolvedRef, this.accessData.getRepositoryUrl()}) + (useShallow ? " " + this.i18nResolver.getText("repository.git.messages.doingShallowFetch") : ""));
                    String refSpec = "+" + resolvedRef + ":" + resolvedRef;
                    this.gitCommandProcessor.runFetchCommand(sourceDirectory, proxiedAccessData, refSpec, useShallow);
                    if (!this.accessData.isLfs()) break block8;
                    try {
                        this.gitCommandProcessor.runLfsFetchCommand(proxiedAccessData, sourceDirectory, resolvedRef);
                    }
                    catch (RepositoryException e) {
                        this.gitCommandProcessor.runLfsLogCommand(sourceDirectory);
                        throw e;
                    }
                }
                finally {
                    this.closeProxy(proxiedAccessData);
                }
            }
            catch (CancelException | HostKeyVerificationException e) {
                throw e;
            }
            catch (Exception e) {
                String message = this.i18nResolver.getText("repository.git.messages.fetchingFailed", new Serializable[]{this.accessData.getRepositoryUrl(), resolvedRef, sourceDirectory});
                throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private String resolveRef(@NotNull File sourceDirectory, @NotNull HashAndSource refAndHash, GitRepositoryAccessData proxiedAccessData) throws RepositoryException {
        if (StringUtils.isNotBlank((CharSequence)proxiedAccessData.getRefSpecOverride())) {
            return proxiedAccessData.getRefSpecOverride();
        }
        if (refAndHash.getRef() != null) {
            return refAndHash.getRef();
        }
        if (StringUtils.startsWithAny((CharSequence)refAndHash.getBranch(), (CharSequence[])FQREF_PREFIXES)) {
            return refAndHash.getBranch();
        }
        HashAndSource refNameAndHash = this.resolveBranch(this.accessData, proxiedAccessData, sourceDirectory, refAndHash.getBranch());
        if (refNameAndHash == null) {
            return "refs/heads/*";
        }
        return refNameAndHash.getRef();
    }

    @Nullable
    private HashAndSource resolveBranch(@NotNull GitRepositoryAccessData directAccessData, @Nullable GitRepositoryAccessData proxiedAccessData, File sourceDirectory, String branch) throws RepositoryException {
        ImmutableMap<String, String> remoteRefs = this.getRemoteRefs(sourceDirectory, directAccessData, proxiedAccessData);
        List<String> candidates = StringUtils.isBlank((CharSequence)branch) ? Arrays.asList("refs/heads/master", "HEAD") : (StringUtils.startsWithAny((CharSequence)branch, (CharSequence[])FQREF_PREFIXES) ? Collections.singletonList(branch) : Arrays.asList(branch, "refs/heads/" + branch, "refs/tags/" + branch));
        for (String refName : candidates) {
            String hash = (String)remoteRefs.get((Object)refName);
            if (hash == null) continue;
            return HashAndSource.hashAndRef(hash, refName);
        }
        log.info((Object)("Could not find [" + branch + "] in remote refs."));
        return null;
    }

    @Override
    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull GitRepositoryAccessData repositoryData, File workingDir) throws RepositoryException {
        ImmutableMap<String, String> refs = this.getRemoteRefs(workingDir, repositoryData, null);
        ArrayList<VcsBranch> openBranches = new ArrayList<VcsBranch>();
        for (String refSymbolicName : refs.keySet()) {
            if (!refSymbolicName.startsWith("refs/heads/")) continue;
            openBranches.add((VcsBranch)new VcsBranchImpl(refSymbolicName.substring("refs/heads/".length())));
        }
        return openBranches;
    }

    private ImmutableMap<String, String> getRemoteRefs(File workingDir, @NotNull GitRepositoryAccessData accessData, @Nullable GitRepositoryAccessData proxiedAccessData) {
        Callable<ImmutableMap> getRemoteRefs = () -> {
            boolean createNewProxySession = proxiedAccessData == null;
            GitRepositoryAccessData accessDataToUse = createNewProxySession ? this.adjustRepositoryAccess(accessData) : proxiedAccessData;
            try {
                ImmutableMap<String, String> immutableMap = this.gitCommandProcessor.getRemoteRefs(workingDir, accessDataToUse);
                return immutableMap;
            }
            finally {
                if (createNewProxySession) {
                    this.closeProxy(accessDataToUse);
                }
            }
        };
        ImmutableMap callResult = (ImmutableMap)GET_REMOTE_REFS_CACHE.call(getRemoteRefs, new Object[]{accessData.getRepositoryUrl(), accessData.getUsername(), accessData.getSshKey()});
        if (log.isDebugEnabled()) {
            log.debug((Object)GET_REMOTE_REFS_CACHE.stats());
        }
        return callResult;
    }

    @Override
    @NotNull
    public String getBranchForSha(@NotNull File sourceDirectory, String revision, String configuredBranch) throws RepositoryException {
        return this.gitCommandProcessor.getBranchForSha(sourceDirectory, revision, configuredBranch);
    }

    @Override
    @NotNull
    public String getCurrentRevision(@NotNull File sourceDirectory) throws RepositoryException {
        return this.gitCommandProcessor.getShaOfRef(sourceDirectory, "HEAD");
    }

    @Override
    @Nullable
    public String getShaOfRefIfExists(@NotNull File sourceDirectory, @NotNull String ref) {
        try {
            return this.gitCommandProcessor.getShaOfRef(sourceDirectory, ref);
        }
        catch (RepositoryException ignored) {
            return null;
        }
    }

    @Override
    @NotNull
    public HashAndSource obtainLatestRevision() throws RepositoryException {
        File workingDir = new File(".");
        long timestamp = System.currentTimeMillis();
        HashAndSource refAndHash = this.resolveBranch(this.accessData, null, workingDir, this.accessData.getVcsBranch().getName());
        HashSet errorReliableIfAnyOfTheseIsDisabled = Sets.newHashSet((Object[])new CacheAwareness.CacheInfo[]{CacheAwareness.ANY, CacheAwareness.BRANCH_DETECTION, CacheAwareness.CHANGE_DETECTION});
        if (refAndHash != null) {
            return refAndHash;
        }
        if (Iterables.any((Iterable)((Iterable)CacheAwareness.getDisabledCachesTimestamp().getFirst()), errorReliableIfAnyOfTheseIsDisabled::contains)) {
            throw new InvalidRepositoryException("Git: " + this.i18nResolver.getText("repository.git.messages.cannotDetermineHead", new Serializable[]{PasswordMaskingUtils.mask((String)this.accessData.getRepositoryUrl(), (String)this.accessData.getPassword()), this.accessData.getVcsBranch().getName()}));
        }
        return (HashAndSource)CacheAwareness.withValuesOlderThanTimestampReloaded((BambooCallables.ThrowingX)((BambooCallables.Throwing)this::obtainLatestRevision), (long)timestamp, (CacheAwareness.CacheInfo[])new CacheAwareness.CacheInfo[]{CacheAwareness.CHANGE_DETECTION});
    }

    @Override
    public boolean checkRevisionExistsInCacheRepository(@NotNull File repositoryDirectory, @NotNull String targetRevision) throws RepositoryException {
        return targetRevision.equals(this.gitCommandProcessor.getShaOfRef(repositoryDirectory, targetRevision));
    }

    @Override
    @NotNull
    public CommitContext getCommit(File directory, String targetRevision) throws RepositoryException {
        return this.gitCommandProcessor.extractCommit(directory, targetRevision);
    }

    @Override
    public BuildRepositoryChanges extractCommits(File cacheDirectory, String lastVcsRevisionKey, String targetRevision) throws RepositoryException {
        Pair<List<CommitContext>, Integer> result = this.gitCommandProcessor.runLogCommand(cacheDirectory, lastVcsRevisionKey, targetRevision, this.getShallows(cacheDirectory), CHANGESET_LIMIT);
        BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl(targetRevision, (List)result.getFirst());
        buildChanges.setSkippedCommitsCount(((Integer)result.getSecond()).intValue());
        return buildChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getShallows(File cacheDirectory) {
        File shallowFile = new File(new File(cacheDirectory, ".git"), "shallow");
        if (shallowFile.exists()) {
            HashSet<String> hashSet;
            LineIterator shallowFileContent = FileUtils.lineIterator((File)shallowFile);
            try {
                HashSet<String> result = new HashSet<String>();
                while (shallowFileContent.hasNext()) {
                    String aShallow = shallowFileContent.nextLine();
                    if (StringUtils.isBlank((CharSequence)aShallow)) continue;
                    result.add(aShallow.trim());
                }
                hashSet = result;
            }
            catch (Throwable throwable) {
                try {
                    LineIterator.closeQuietly((LineIterator)shallowFileContent);
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn((Object)("Cannot read 'shallow' file " + shallowFile.getAbsolutePath()));
                }
            }
            LineIterator.closeQuietly((LineIterator)shallowFileContent);
            return hashSet;
        }
        return Collections.emptySet();
    }
}

