/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchDetector
extends AbstractGitExecutor
implements VcsBranchDetector {
    private static final Logger log = Logger.getLogger(GitBranchDetector.class);

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        return helper.getOpenBranches(substitutedAccessData, this.getWorkingDirectory(substitutedAccessData));
    }

    @NotNull
    public CommitContext getLastCommit(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        NullBuildLogger buildLogger = new NullBuildLogger();
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)buildLogger, this.i18nResolver, this.trustedKeyHelper);
        HashAndSource latestHashAndSource = helper.obtainLatestRevision();
        File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
        Result result = (Result)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
            try {
                CommitContext commit = helper.getCommit(cacheDirectory, latestHashAndSource.getHash());
                log.info((Object)String.format("Found %s as the last commit for %s [%d]", commit.getChangeSetId(), repositoryData.getName(), repositoryData.getId()));
                return Result.result((Object)commit);
            }
            catch (RepositoryException e) {
                try {
                    log.debug((Object)"Fetching remote repository");
                    helper.fetch(cacheDirectory, latestHashAndSource, false);
                    return Result.result((Object)helper.getCommit(cacheDirectory, latestHashAndSource.getHash()));
                }
                catch (RepositoryException e2) {
                    return Result.exception((Throwable)e2);
                }
            }
        });
        return (CommitContext)result.getResultThrowException();
    }

    @Nullable
    public ContextualVcsId<VcsBranchDetector> getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{substitutedAccessData.getRepositoryUrl(), substitutedAccessData.getUsername(), substitutedAccessData.getSshKey()});
    }
}

