/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2.configurator;

import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configurator.VcsMavenPomAccessor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMavenPomAccessor
implements VcsMavenPomAccessor {
    @NotNull
    public String getMavenScmProviderKey() {
        return "git";
    }

    public Map<String, String> parseMavenScmUrlToVcsLocation(@NotNull String mavenScmUrl, @Nullable VcsRepositoryData existingData) throws IllegalArgumentException {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        if (existingData != null) {
            cfgMap.putAll(existingData.getVcsLocation().getConfiguration());
        } else {
            cfgMap.put("repository.git.commandTimeout", Integer.toString(180));
            cfgMap.put("repository.git.useShallowClones", Boolean.TRUE.toString());
            cfgMap.put("repository.git.authenticationType", GitAuthenticationType.NONE.name());
        }
        cfgMap.put("repository.git.repositoryUrl", mavenScmUrl);
        return cfgMap;
    }

    public VcsBranch parseMavenScmUrlToVcsBranch(@NotNull String mavenScmUrl, @Nullable VcsRepositoryData existingData) throws IllegalArgumentException {
        if (existingData != null && existingData.getBranch() != null) {
            return existingData.getBranch().getVcsBranch();
        }
        return new VcsBranchImpl("");
    }
}

