/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2.converter;

import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitConfigurationConverter
implements Repository2VcsTypeConverter {
    private static final Logger log = Logger.getLogger(GitConfigurationConverter.class);
    private static final List<String> KEYS_TO_SKIP = ImmutableList.of((Object)"bambooDelimiterParsingDisabled", (Object)"[@xml:space]", (Object)"repository.git.branch", (Object)"repository.common.quietPeriod.enabled", (Object)"repository.common.quietPeriod.period", (Object)"repository.common.quietPeriod.maxRetries", (Object)"changeset.filter.pattern.regex", (Object)"commit.isolation.option", (Object)"filter.pattern.option", (Object)"filter.pattern.regex");

    public String acceptedRepositoryPluginKey() {
        return "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:git";
    }

    public String producedVcsTypePluginKey() {
        return "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2";
    }

    @NotNull
    public Map<String, String> extractServerConfiguration(@NotNull HierarchicalConfiguration repositoryConfiguration) {
        HashMap<String, String> result = new HashMap<String, String>();
        ConfigUtils.asMap((Configuration)repositoryConfiguration, null).entrySet().stream().filter(e -> !KEYS_TO_SKIP.contains(e.getKey())).forEach(e -> {
            String cfr_ignored_0 = (String)result.put((String)e.getKey(), (String)e.getValue());
        });
        return result;
    }

    @Nullable
    public Map<String, String> extractBranchConfiguration(@NotNull HierarchicalConfiguration repositoryConfiguration) {
        return ImmutableMap.of((Object)"repository.git.branch", (Object)repositoryConfiguration.getString("repository.git.branch"));
    }

    public HierarchicalConfiguration asLegacyData(@NotNull VcsRepositoryData vcsRepositoryData) {
        XMLConfiguration configuration = ConfigUtils.newConfiguration();
        Stream.concat(vcsRepositoryData.getVcsLocation().getConfiguration().entrySet().stream(), vcsRepositoryData.getBranch().getConfiguration().entrySet().stream()).forEach(arg_0 -> GitConfigurationConverter.lambda$asLegacyData$2((HierarchicalConfiguration)configuration, arg_0));
        return configuration;
    }

    private static /* synthetic */ void lambda$asLegacyData$2(HierarchicalConfiguration configuration, Map.Entry e) {
        configuration.setProperty((String)e.getKey(), e.getValue());
    }
}

