/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.util.BambooFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class GitCacheDirectoryUtils {
    private static final Logger log = Logger.getLogger(GitCacheDirectoryUtils.class);

    public void deleteCacheDirectoriesExcept(File baseCacheDirectory, final Collection<String> dirs) {
        this.deleteCacheDirectories(baseCacheDirectory, new FileFilter(){

            @Override
            public boolean accept(File pathName) {
                return !dirs.contains(pathName.getName()) && pathName.isDirectory();
            }
        });
    }

    public void deleteCacheDirectories(File baseCacheDirectory, final Collection<String> dirs) {
        this.deleteCacheDirectories(baseCacheDirectory, new FileFilter(){

            @Override
            public boolean accept(File pathName) {
                return dirs.contains(pathName.getName()) && pathName.isDirectory();
            }
        });
    }

    private void deleteCacheDirectories(File baseCacheDirectory, FileFilter filter) {
        Object[] toDelete = GitCacheDirectory.getCacheDirectoryRoot(baseCacheDirectory).listFiles(filter);
        if (ArrayUtils.isEmpty((Object[])toDelete)) {
            log.info((Object)"No cache directories to delete found.");
        } else {
            for (Object dir : toDelete) {
                try {
                    BambooFileUtils.deleteDirectory((File)dir);
                    log.info((Object)("Successfully deleted cache directory: " + dir));
                }
                catch (IOException e) {
                    log.error((Object)("Failed to delete cache directory: " + dir), (Throwable)e);
                }
            }
        }
    }
}

