/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.git.AbstractGitOperationHelper;
import com.atlassian.bamboo.plugins.git.BuildLoggerProgressMonitor;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitSshSessionFactory;
import com.atlassian.bamboo.plugins.git.TweakedUsernamePasswordCredentialsProvider;
import com.atlassian.bamboo.plugins.git.jgit.transport.TrustedKeyFetcher;
import com.atlassian.bamboo.plugins.git.jgit.transport.http.AllTrustingHttpConnectionFactory;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JGitOperationHelper
extends AbstractGitOperationHelper {
    private static final Logger log = Logger.getLogger(JGitOperationHelper.class);

    public JGitOperationHelper(GitRepositoryAccessData accessData, @NotNull BuildLogger buildLogger, @NotNull I18nResolver i18nResolver, @NotNull TrustedKeyHelper trustedKeyHelper) {
        super(accessData, buildLogger, i18nResolver, trustedKeyHelper);
    }

    @Override
    public String commit(@NotNull File sourceDirectory, @NotNull String message, @NotNull String comitterName, @NotNull String comitterEmail) throws RepositoryException {
        throw new UnsupportedOperationException("JGit implementation does not support commit, please use native Git");
    }

    private String doCheckout(@NotNull Repository localRepository, @NotNull String targetRevision, @Nullable String previousRevision, boolean useSubmodules) throws RepositoryException {
        if (useSubmodules) {
            this.buildLogger.addBuildLogEntry((LogEntry)new CommandLogEntry(this.i18nResolver.getText("repository.git.messages.jgit.submodules.not.supported")));
        }
        RevWalk revWalk = null;
        DirCache dirCache = null;
        try {
            boolean createDetachedHead;
            String branchRefSpec;
            dirCache = localRepository.lockDirCache();
            ObjectId resolvedTargetRevision = localRepository.resolve(targetRevision);
            Preconditions.checkNotNull((Object)resolvedTargetRevision, (Object)("Unable to find revision " + targetRevision + " in repository"));
            revWalk = new RevWalk(localRepository);
            RevCommit targetCommit = revWalk.parseCommit((AnyObjectId)resolvedTargetRevision);
            RevCommit previousCommit = previousRevision == null ? null : revWalk.parseCommit((AnyObjectId)localRepository.resolve(previousRevision));
            DirCacheCheckout dirCacheCheckout = new DirCacheCheckout(localRepository, (ObjectId)(previousCommit == null ? null : previousCommit.getTree()), dirCache, (ObjectId)targetCommit.getTree());
            dirCacheCheckout.setFailOnConflict(true);
            try {
                dirCacheCheckout.checkout();
            }
            catch (MissingObjectException e) {
                String message = this.i18nResolver.getText("repository.git.messages.checkoutFailedMissingObject", new Serializable[]{targetRevision, e.getObjectId().getName()});
                throw new RepositoryException(this.buildLogger.addErrorLogEntry(message));
            }
            try {
                branchRefSpec = this.withTransport(localRepository, this.accessData, new WithTransportCallback<Exception, String>(){

                    @Override
                    @Nullable
                    public String doWithTransport(@NotNull Transport transport) throws Exception {
                        return JGitOperationHelper.this.getRefSpecForName(transport, JGitOperationHelper.this.accessData.getVcsBranch().getName(), false);
                    }
                });
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RepositoryException("Unable to resolve branch name", (Throwable)e);
            }
            if (branchRefSpec.startsWith("refs/") && localRepository.resolve(branchRefSpec).equals((AnyObjectId)targetCommit)) {
                createDetachedHead = false;
                RefUpdate.Result result = localRepository.updateRef("HEAD", false).link(branchRefSpec);
            } else if (!BambooStringUtils.in((String)branchRefSpec, (String[])new String[]{"HEAD"})) {
                createDetachedHead = true;
                RefUpdate refUpdate = localRepository.updateRef("HEAD", createDetachedHead);
                refUpdate.setNewObjectId((AnyObjectId)targetCommit);
                refUpdate.forceUpdate();
            }
            String string = targetCommit.getId().getName();
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.checkoutFailed", new Serializable[]{targetRevision})) + e.getMessage(), (Throwable)e);
        }
        finally {
            if (revWalk != null) {
                revWalk.release();
            }
            if (dirCache != null) {
                dirCache.unlock();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
    }

    @Override
    public boolean merge(@NotNull File workspaceDir, @NotNull String targetRevision, @NotNull String committerName, @NotNull String committerEmail) {
        throw new UnsupportedOperationException("JGit implementation does not support merging, please use native Git");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushRevision(@NotNull File sourceDirectory, @NotNull String revision) throws RepositoryException {
        try (Repository localRepository = this.createLocalRepository(sourceDirectory, null);){
            this.withFetchConnection(localRepository, this.accessData, new WithFetchConnectionCallback<IOException, Void>(){

                @Override
                public Void doWithFetchConnection(@NotNull Transport transport, @NotNull FetchConnection connection) throws IOException {
                    String resolvedBranch = JGitOperationHelper.resolveRefSpec(JGitOperationHelper.this.accessData.getVcsBranch().getName(), connection).getName();
                    RefSpec refSpec = new RefSpec().setForceUpdate(true).setSource(resolvedBranch).setDestination(resolvedBranch);
                    PushResult pushResult = transport.push((ProgressMonitor)new BuildLoggerProgressMonitor(JGitOperationHelper.this.buildLogger), transport.findRemoteRefUpdatesFor(Arrays.asList(refSpec)));
                    JGitOperationHelper.this.buildLogger.addBuildLogEntry("Git: " + pushResult.getMessages());
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.pushFailed", new Serializable[]{revision})) + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String checkout(@Nullable File cacheDirectory, @NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String previousRevision) throws RepositoryException {
        String string;
        this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.checkingOutRevision", new Serializable[]{targetRevision}));
        Repository localRepository = this.createLocalRepository(sourceDirectory, cacheDirectory);
        try {
            File lck = new File(localRepository.getIndexFile().getParentFile(), localRepository.getIndexFile().getName() + ".lock");
            BambooFileUtils.deleteQuietly((File)lck);
            string = this.doCheckout(localRepository, targetRevision, previousRevision, this.accessData.isUseSubmodules());
        }
        catch (Throwable throwable) {
            try {
                localRepository.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.checkoutFailed", new Serializable[]{targetRevision})) + e.getMessage(), (Throwable)e);
            }
        }
        localRepository.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(final @NotNull File sourceDirectory, final @NotNull String targetRevision, final boolean useShallow) throws RepositoryException {
        final AtomicReference<String> refSpecDescription = new AtomicReference<String>("(unresolved) " + targetRevision);
        try (final Repository localRepository = this.createLocalRepository(sourceDirectory, null);){
            this.withTransport(localRepository, this.accessData, new WithTransportCallback<Exception, Void>(){

                @Override
                public Void doWithTransport(@NotNull Transport transport) throws Exception {
                    String resolvedRefSpec = JGitOperationHelper.this.getRefSpecForName(transport, targetRevision, true);
                    refSpecDescription.set(resolvedRefSpec);
                    JGitOperationHelper.this.buildLogger.addBuildLogEntry(JGitOperationHelper.this.i18nResolver.getText("repository.git.messages.fetching", new Serializable[]{resolvedRefSpec, JGitOperationHelper.this.accessData.getRepositoryUrl()}) + (useShallow ? " " + JGitOperationHelper.this.i18nResolver.getText("repository.git.messages.doingShallowFetch") : ""));
                    RefSpec refSpec = new RefSpec().setForceUpdate(true).setSourceDestination(resolvedRefSpec, resolvedRefSpec);
                    try {
                        transport.setTagOpt(TagOpt.AUTO_FOLLOW);
                        FetchResult fetchResult = transport.fetch((ProgressMonitor)new BuildLoggerProgressMonitor(JGitOperationHelper.this.buildLogger), Collections.singletonList(refSpec), useShallow ? 1 : 0);
                        JGitOperationHelper.this.buildLogger.addBuildLogEntry("Git: " + fetchResult.getMessages());
                    }
                    catch (IOException e) {
                        String message = JGitOperationHelper.this.i18nResolver.getText("repository.git.messages.fetchingFailed", new Serializable[]{JGitOperationHelper.this.accessData.getRepositoryUrl(), (Serializable)refSpecDescription.get(), sourceDirectory});
                        throw new RepositoryException(JGitOperationHelper.this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
                    }
                    finally {
                        transport.close();
                    }
                    if (resolvedRefSpec.startsWith("refs/heads/")) {
                        localRepository.updateRef("HEAD").link(resolvedRefSpec);
                    }
                    return null;
                }
            });
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            String message = TextProviderUtils.getText((I18nResolver)this.i18nResolver, (String)"repository.git.messages.fetchingFailed", (String[])new String[]{this.accessData.getRepositoryUrl(), refSpecDescription.get(), sourceDirectory.getAbsolutePath()});
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public String getCurrentRevision(@NotNull File sourceDirectory) throws RepositoryException {
        return this.getRevision(sourceDirectory, "HEAD");
    }

    protected String getRevision(File sourceDirectory, @NotNull String revision) throws RepositoryException {
        File gitDirectory = new File(sourceDirectory, ".git");
        if (!gitDirectory.exists()) {
            throw new RepositoryException(sourceDirectory + " does not exist");
        }
        try (Repository localRepository = null;){
            localRepository = FileRepositoryBuilder.create((File)new File(sourceDirectory, ".git"));
            ObjectId objId = localRepository.resolve(revision);
            if (objId == null) {
                throw new RepositoryException("Cannot resolve " + revision);
            }
            String string = objId.getName();
            return string;
        }
    }

    @Override
    @Nullable
    public String getRevisionIfExists(@NotNull File sourceDirectory, @NotNull String revision) {
        try {
            return this.getRevision(sourceDirectory, revision);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String obtainLatestRevision() throws RepositoryException {
        try {
            Repository repository = FileRepositoryBuilder.create((File)new File(""));
            return this.withRepository(repository, new WithRepositoryCallback<RepositoryException, String>(){

                @Override
                @NotNull
                public String doWithRepository(@NotNull Repository repository) throws RepositoryException {
                    return JGitOperationHelper.this.obtainLatestRevision(repository);
                }
            });
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.failedToCreateFileRepository")), (Throwable)e);
        }
    }

    private String obtainLatestRevision(@NotNull Repository repository) throws RepositoryException {
        try {
            return this.withFetchConnection(repository, this.accessData, new WithFetchConnectionCallback<RepositoryException, String>(){

                @Override
                public String doWithFetchConnection(@NotNull Transport transport, @NotNull FetchConnection connection) throws RepositoryException {
                    Ref headRef = JGitOperationHelper.resolveRefSpec(JGitOperationHelper.this.accessData.getVcsBranch().getName(), connection);
                    if (headRef == null) {
                        throw new InvalidRepositoryException(JGitOperationHelper.this.i18nResolver.getText("repository.git.messages.cannotDetermineHead", new Serializable[]{JGitOperationHelper.this.accessData.getRepositoryUrl(), JGitOperationHelper.this.accessData.getVcsBranch().getName()}));
                    }
                    return headRef.getObjectId().getName();
                }
            });
        }
        catch (NotSupportedException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.protocolUnsupported", new Serializable[]{this.accessData.getRepositoryUrl()})), (Throwable)e);
        }
        catch (TransportException e) {
            if (e.getMessage().contains("reject HostKey:")) {
                TrustedKey trustedKey = this.tryToFetchTrustedKey(repository);
                throw new HostKeyVerificationException(this.buildLogger.addErrorLogEntry(e.getMessage()), (Throwable)e, e.getMessage(), e.getMessage(), Collections.emptyList(), trustedKey);
            }
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(e.getMessage()), (Throwable)e);
        }
    }

    @Nullable
    private TrustedKey tryToFetchTrustedKey(@NotNull Repository repository) {
        final TrustedKeyFetcher hostKeyRepository = new TrustedKeyFetcher();
        try {
            this.withTransport(repository, this.accessData, transport -> {
                SshTransport sshTransport;
                SshSessionFactory sshSessionFactory;
                if (transport instanceof SshTransport && (sshSessionFactory = (sshTransport = (SshTransport)transport).getSshSessionFactory()) instanceof GitSshSessionFactory) {
                    GitSshSessionFactory gitSshSessionFactory = (GitSshSessionFactory)sshSessionFactory;
                    sshTransport.setSshSessionFactory((SshSessionFactory)new GitSshSessionFactory(gitSshSessionFactory){

                        @Override
                        protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
                            JSch jSch = super.getJSch(hc, fs);
                            jSch.setHostKeyRepository((HostKeyRepository)hostKeyRepository);
                            return jSch;
                        }
                    });
                    transport.openFetch();
                }
                return "";
            });
        }
        catch (RepositoryException | IOException e) {
            log.info((Object)"Can't read server public key, return null");
            log.info((Object)e.getMessage(), e);
            return null;
        }
        return hostKeyRepository.getKey();
    }

    @Override
    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull GitRepositoryAccessData repositoryData, File workingDir) throws RepositoryException {
        try {
            return this.withFetchConnection(FileRepositoryBuilder.create((File)new File("")), this.accessData, new WithFetchConnectionCallback<RepositoryException, List<VcsBranch>>(){

                @Override
                public List<VcsBranch> doWithFetchConnection(@NotNull Transport transport, @NotNull FetchConnection connection) throws RepositoryException {
                    ArrayList openBranches = Lists.newArrayList();
                    for (Ref ref : connection.getRefs()) {
                        if (!ref.getName().startsWith("refs/heads/")) continue;
                        openBranches.add(new VcsBranchImpl(ref.getName().substring("refs/heads/".length())));
                    }
                    return openBranches;
                }
            });
        }
        catch (NotSupportedException e) {
            throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.protocolUnsupported", new Serializable[]{repositoryData.getRepositoryUrl()}), (Throwable)e);
        }
        catch (TransportException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.failedToCreateFileRepository"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRevisionExistsInCacheRepository(@NotNull File repositoryDirectory, @NotNull String targetRevision) throws IOException, RepositoryException {
        try (Repository localRepository = this.createLocalRepository(repositoryDirectory, null);){
            RevWalk revWalk = new RevWalk(localRepository);
            RevCommit targetCommit = revWalk.parseCommit((AnyObjectId)localRepository.resolve(targetRevision));
            boolean bl = targetCommit != null;
            return bl;
        }
    }

    @NotNull
    private String getRefSpecForName(@NotNull Transport transport, final @Nullable String name, boolean allowOverride) throws Exception {
        String resolvedBranch = allowOverride && StringUtils.isNotBlank((CharSequence)this.accessData.getRefSpecOverride()) ? this.accessData.getRefSpecOverride() : (StringUtils.startsWithAny((CharSequence)name, (CharSequence[])FQREF_PREFIXES) ? name : this.withFetchConnection(transport, new WithFetchConnectionCallback<Exception, String>(){

            @Override
            public String doWithFetchConnection(@NotNull Transport transport, @NotNull FetchConnection connection) throws Exception {
                Ref ref = JGitOperationHelper.resolveRefSpec(name, connection);
                return ref != null ? ref.getName() : "refs/heads/*";
            }
        }));
        return resolvedBranch;
    }

    @Nullable
    protected static Ref resolveRefSpec(String name, FetchConnection fetchConnection) {
        List<String> candidates = StringUtils.isBlank((CharSequence)name) ? Arrays.asList("refs/heads/master", "HEAD") : (StringUtils.startsWithAny((CharSequence)name, (CharSequence[])FQREF_PREFIXES) ? Collections.singletonList(name) : Arrays.asList(name, "refs/tags/" + name, "refs/heads/" + name));
        for (String candidate : candidates) {
            Ref headRef = fetchConnection.getRef(candidate);
            if (headRef == null) continue;
            return headRef;
        }
        return null;
    }

    protected Repository createLocalRepository(File workingDirectory, @Nullable File cacheDirectory) throws IOException {
        Object[] alternateObjectDirectories;
        File gitDirectory = new File(workingDirectory, ".git");
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setGitDir(gitDirectory);
        String headRef = null;
        File cacheGitDir = null;
        if (cacheDirectory != null && cacheDirectory.exists()) {
            FileRepositoryBuilder cacheRepoBuilder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(cacheDirectory)).setup();
            cacheGitDir = cacheRepoBuilder.getGitDir();
            File objectsCache = cacheRepoBuilder.getObjectDirectory();
            if (objectsCache != null && objectsCache.exists()) {
                builder.addAlternateObjectDirectory(objectsCache);
                headRef = FileUtils.readFileToString((File)new File(cacheRepoBuilder.getGitDir(), "HEAD"));
            }
        }
        Repository localRepository = builder.build();
        if (!gitDirectory.exists()) {
            this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.creatingGitRepository", new Serializable[]{gitDirectory}));
            localRepository.create();
        }
        if (ArrayUtils.isNotEmpty((Object[])(alternateObjectDirectories = builder.getAlternateObjectDirectories()))) {
            ArrayList<String> alternatePaths = new ArrayList<String>(alternateObjectDirectories.length);
            for (Object alternateObjectDirectory : alternateObjectDirectories) {
                alternatePaths.add(((File)alternateObjectDirectory).getAbsolutePath());
            }
            ObjectDatabase objectDatabase = localRepository.getObjectDatabase();
            if (objectDatabase instanceof ObjectDirectory) {
                ObjectDirectory objectDirectory = (ObjectDirectory)objectDatabase;
                File alternates = new File(new File(objectDirectory.getDirectory(), "info"), "alternates");
                FileUtils.writeLines((File)alternates, alternatePaths, (String)"\n");
            } else {
                throw new IllegalStateException(String.format("objectDatabase %s is of unexpected class %s", objectDatabase, objectDatabase.getClass()));
            }
        }
        if (cacheGitDir != null && cacheGitDir.isDirectory()) {
            FileUtils.copyDirectoryToDirectory((File)new File(cacheGitDir, "refs/tags/"), (File)new File(localRepository.getDirectory(), "refs/"));
            FileUtils.copyDirectoryToDirectory((File)new File(cacheGitDir, "refs/heads/"), (File)new File(localRepository.getDirectory(), "refs/"));
            File shallow = new File(cacheGitDir, "shallow");
            if (shallow.exists()) {
                FileUtils.copyFileToDirectory((File)shallow, (File)localRepository.getDirectory());
            }
        }
        if (StringUtils.startsWith(headRef, (CharSequence)"ref: ")) {
            FileUtils.writeStringToFile((File)new File(localRepository.getDirectory(), "HEAD"), headRef);
        }
        localRepository.scanForRepoChanges();
        return localRepository;
    }

    @Override
    public BuildRepositoryChanges extractCommits(@NotNull File directory, @Nullable String previousRevision, @Nullable String targetRevision) throws RepositoryException {
        ArrayList<CommitImpl> commits = new ArrayList<CommitImpl>();
        int skippedCommits = 0;
        Repository localRepository = null;
        RevWalk revWalk = null;
        TreeWalk treeWalk = null;
        boolean singleCommit = previousRevision != null && previousRevision.equals(targetRevision);
        try {
            localRepository = FileRepositoryBuilder.create((File)new File(directory, ".git"));
            ObjectDirectory objectDirectory = (ObjectDirectory)Narrow.downTo((Object)localRepository.getObjectDatabase(), ObjectDirectory.class);
            revWalk = new RevWalk(localRepository);
            if (targetRevision != null) {
                revWalk.markStart(revWalk.parseCommit((AnyObjectId)localRepository.resolve(targetRevision)));
            }
            if (previousRevision != null && !singleCommit) {
                revWalk.markUninteresting(revWalk.parseCommit((AnyObjectId)localRepository.resolve(previousRevision)));
            }
            treeWalk = new TreeWalk(localRepository);
            treeWalk.setRecursive(true);
            for (RevCommit jgitCommit : revWalk) {
                if (commits.size() >= CHANGESET_LIMIT) {
                    ++skippedCommits;
                    continue;
                }
                CommitImpl commit = new CommitImpl();
                commit.setComment(jgitCommit.getFullMessage());
                commit.setAuthor((Author)this.getAuthor(jgitCommit));
                commit.setDate(jgitCommit.getAuthorIdent().getWhen());
                commit.setChangeSetId(jgitCommit.getName());
                commits.add(commit);
                if (jgitCommit.getParentCount() >= 2 || objectDirectory.getShallowCommits().contains(jgitCommit.getId())) continue;
                treeWalk.reset();
                if (jgitCommit.getParentCount() > 0) {
                    treeWalk.addTree((AnyObjectId)jgitCommit.getParent(0).getTree());
                } else {
                    treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                treeWalk.addTree((AnyObjectId)jgitCommit.getTree());
                for (DiffEntry entry : DiffEntry.scan((TreeWalk)treeWalk)) {
                    if (entry.getOldId().equals((Object)entry.getNewId())) continue;
                    commit.addFile((CommitFile)new CommitFileImpl(jgitCommit.getId().getName(), entry.getChangeType() == DiffEntry.ChangeType.DELETE ? entry.getOldPath() : entry.getNewPath()));
                }
                if (!singleCommit) continue;
                break;
            }
        }
        catch (IOException e) {
            String message = this.i18nResolver.getText("repository.git.messages.extractingChangesetsException", new Serializable[]{directory, previousRevision, targetRevision});
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (treeWalk != null) {
                treeWalk.release();
            }
            if (revWalk != null) {
                revWalk.release();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
        BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl(targetRevision, commits);
        buildChanges.setSkippedCommitsCount(skippedCommits);
        return buildChanges;
    }

    @Override
    @NotNull
    public String getBranchForSha(@NotNull File sourceDirectory, String revision, String configuredBranch) throws RepositoryException {
        return configuredBranch;
    }

    private AuthorImpl getAuthor(RevCommit commit) {
        PersonIdent gitPerson = commit.getAuthorIdent();
        if (gitPerson == null) {
            return new AuthorImpl("[unknown]");
        }
        return new AuthorImpl(String.format("%s <%s>", gitPerson.getName(), gitPerson.getEmailAddress()), null, gitPerson.getEmailAddress());
    }

    @NotNull
    Transport open(@NotNull Repository localRepository, @NotNull GitRepositoryAccessData accessData) throws RepositoryException {
        try {
            URIish uri = new URIish(accessData.getRepositoryUrl());
            if ("ssh".equals(uri.getScheme()) && accessData.getAuthenticationType() == GitAuthenticationType.PASSWORD && StringUtils.isBlank((CharSequence)uri.getUser()) && StringUtils.isNotBlank((CharSequence)accessData.getUsername())) {
                uri = uri.setUser(accessData.getUsername());
            }
            Transport transport = Transport.open((Repository)localRepository, (URIish)uri);
            transport.setTimeout(DEFAULT_TRANSFER_TIMEOUT);
            if (transport instanceof SshTransport) {
                boolean useKey = accessData.getAuthenticationType() == GitAuthenticationType.SSH_KEYPAIR;
                String sshKey = useKey ? accessData.getSshKey() : null;
                String passphrase = useKey ? accessData.getSshPassphrase() : null;
                GitSshSessionFactory factory = new GitSshSessionFactory(sshKey, passphrase, this.trustedKeyHelper);
                ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)factory);
                if (passphrase != null) {
                    transport.setCredentialsProvider((CredentialsProvider)new TweakedUsernamePasswordCredentialsProvider("dummy", passphrase));
                }
            }
            if (accessData.getAuthenticationType() == GitAuthenticationType.PASSWORD) {
                transport.setCredentialsProvider((CredentialsProvider)new TweakedUsernamePasswordCredentialsProvider(accessData.getUsername(), accessData.getPassword()));
            }
            return transport;
        }
        catch (URISyntaxException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.invalidURI", new Serializable[]{accessData.getRepositoryUrl()})), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.failedToOpenTransport", new Serializable[]{accessData.getRepositoryUrl()})), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public CommitContext getCommit(File directory, String targetRevision) throws RepositoryException {
        Repository localRepository = null;
        RevWalk revWalk = null;
        try {
            File gitDirectory = new File(directory, ".git");
            localRepository = FileRepositoryBuilder.create((File)gitDirectory);
            revWalk = new RevWalk(localRepository);
            if (targetRevision != null) {
                RevCommit jgitCommit = revWalk.parseCommit((AnyObjectId)localRepository.resolve(targetRevision));
                CommitImpl commit = new CommitImpl();
                commit.setComment(jgitCommit.getFullMessage());
                commit.setAuthor((Author)this.getAuthor(jgitCommit));
                commit.setDate(jgitCommit.getAuthorIdent().getWhen());
                commit.setChangeSetId(jgitCommit.getName());
                CommitImpl commitImpl = commit;
                return commitImpl;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Getting commit " + targetRevision + " from " + this.accessData.getRepositoryUrl() + " failed", (Throwable)e);
        }
        finally {
            if (revWalk != null) {
                revWalk.release();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
        throw new RepositoryException("Could not find commit with revision " + targetRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Throwable, T> T withRepository(@NotNull Repository repository, @NotNull WithRepositoryCallback<E, T> withRepositoryCallback) throws E {
        try {
            T t = withRepositoryCallback.doWithRepository(repository);
            return t;
        }
        finally {
            repository.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <E extends Throwable, T> T withTransport(@NotNull Repository repository, @NotNull GitRepositoryAccessData accessData, @NotNull WithTransportCallback<E, T> callback) throws E, RepositoryException {
        try (Transport transport = this.open(repository, accessData);){
            T t = callback.doWithTransport(transport);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E extends Throwable, T> T withFetchConnection(@NotNull Transport transport, @NotNull WithFetchConnectionCallback<E, T> callback) throws E, NotSupportedException, TransportException {
        try (FetchConnection connection = transport.openFetch();){
            T t = callback.doWithFetchConnection(transport, connection);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E extends Throwable, T> T withFetchConnection(@NotNull Repository repository, @NotNull GitRepositoryAccessData accessData, @NotNull WithFetchConnectionCallback<E, T> callback) throws E, RepositoryException, NotSupportedException, TransportException {
        try (Transport transport = this.open(repository, accessData);){
            T t;
            FetchConnection connection = transport.openFetch();
            try {
                t = callback.doWithFetchConnection(transport, connection);
            }
            catch (Throwable throwable) {
                connection.close();
                throw throwable;
            }
            connection.close();
            return t;
        }
    }

    static {
        if (SystemProperty.CRYPTO_TRUST_JGIT_ALL.getTypedValue()) {
            HttpTransport.setConnectionFactory((HttpConnectionFactory)new AllTrustingHttpConnectionFactory());
        }
    }

    protected static interface WithFetchConnectionCallback<E extends Throwable, T> {
        public T doWithFetchConnection(@NotNull Transport var1, @NotNull FetchConnection var2) throws E;
    }

    protected static interface WithRepositoryCallback<E extends Throwable, V> {
        @NotNull
        public V doWithRepository(@NotNull Repository var1) throws E;
    }

    protected static interface WithTransportCallback<E extends Throwable, T> {
        @Nullable
        public T doWithTransport(@NotNull Transport var1) throws E;
    }
}

