/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.file;

import org.shaded.eclipse.jgit.lib.Config;

public class WindowCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private int packedGitOpenFiles = 128;
    private long packedGitLimit = 0xA00000L;
    private int packedGitWindowSize = 8192;
    private boolean packedGitMMAP = false;
    private int deltaBaseCacheLimit = 0xA00000;
    private int streamFileThreshold = 0x3200000;

    public int getPackedGitOpenFiles() {
        return this.packedGitOpenFiles;
    }

    public void setPackedGitOpenFiles(int fdLimit) {
        this.packedGitOpenFiles = fdLimit;
    }

    public long getPackedGitLimit() {
        return this.packedGitLimit;
    }

    public void setPackedGitLimit(long newLimit) {
        this.packedGitLimit = newLimit;
    }

    public int getPackedGitWindowSize() {
        return this.packedGitWindowSize;
    }

    public void setPackedGitWindowSize(int newSize) {
        this.packedGitWindowSize = newSize;
    }

    public boolean isPackedGitMMAP() {
        return this.packedGitMMAP;
    }

    public void setPackedGitMMAP(boolean usemmap) {
        this.packedGitMMAP = usemmap;
    }

    public int getDeltaBaseCacheLimit() {
        return this.deltaBaseCacheLimit;
    }

    public void setDeltaBaseCacheLimit(int newLimit) {
        this.deltaBaseCacheLimit = newLimit;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public void setStreamFileThreshold(int newLimit) {
        this.streamFileThreshold = newLimit;
    }

    public void fromConfig(Config rc) {
        this.setPackedGitOpenFiles(rc.getInt("core", null, "packedgitopenfiles", this.getPackedGitOpenFiles()));
        this.setPackedGitLimit(rc.getLong("core", null, "packedgitlimit", this.getPackedGitLimit()));
        this.setPackedGitWindowSize(rc.getInt("core", null, "packedgitwindowsize", this.getPackedGitWindowSize()));
        this.setPackedGitMMAP(rc.getBoolean("core", null, "packedgitmmap", this.isPackedGitMMAP()));
        this.setDeltaBaseCacheLimit(rc.getInt("core", null, "deltabasecachelimit", this.getDeltaBaseCacheLimit()));
        long maxMem = Runtime.getRuntime().maxMemory();
        long sft = rc.getLong("core", null, "streamfilethreshold", this.getStreamFileThreshold());
        sft = Math.min(sft, maxMem / 4L);
        sft = Math.min(sft, Integer.MAX_VALUE);
        this.setStreamFileThreshold((int)sft);
    }
}

