/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.util;

import java.io.IOException;
import java.util.regex.Pattern;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.ObjectInserter;
import org.shaded.eclipse.jgit.lib.PersonIdent;

public class ChangeIdUtil {
    static final String CHANGE_ID = "Change-Id:";
    private static final Pattern issuePattern = Pattern.compile("^(Bug|Issue)[a-zA-Z0-9-]*:.*$");
    private static final Pattern footerPattern = Pattern.compile("(^[a-zA-Z0-9-]+:(?!//).*$)");
    private static final Pattern includeInFooterPattern = Pattern.compile("^[ \\[].*$");

    static String clean(String msg) {
        return msg.replaceAll("(?i)(?m)^Signed-off-by:.*$\n?", "").replaceAll("(?m)^#.*$\n?", "").replaceAll("(?m)\n\n\n+", "\\\n").replaceAll("\\n*$", "").replaceAll("(?s)\ndiff --git.*", "").trim();
    }

    public static ObjectId computeChangeId(ObjectId treeId, ObjectId firstParentId, PersonIdent author, PersonIdent committer, String message) throws IOException {
        String cleanMessage = ChangeIdUtil.clean(message);
        if (cleanMessage.length() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("tree ");
        b.append(ObjectId.toString(treeId));
        b.append("\n");
        if (firstParentId != null) {
            b.append("parent ");
            b.append(ObjectId.toString(firstParentId));
            b.append("\n");
        }
        b.append("author ");
        b.append(author.toExternalString());
        b.append("\n");
        b.append("committer ");
        b.append(committer.toExternalString());
        b.append("\n\n");
        b.append(cleanMessage);
        return new ObjectInserter.Formatter().idFor(1, b.toString().getBytes("UTF-8"));
    }

    public static String insertId(String message, ObjectId changeId) {
        return ChangeIdUtil.insertId(message, changeId, false);
    }

    public static String insertId(String message, ObjectId changeId, boolean replaceExisting) {
        int i;
        if (message.indexOf(CHANGE_ID) > 0) {
            if (replaceExisting) {
                int i2 = message.indexOf(CHANGE_ID) + 10;
                while (message.charAt(i2) == ' ') {
                    ++i2;
                }
                String oldId = message.length() == i2 + 40 ? message.substring(i2) : message.substring(i2, i2 + 41);
                message = message.replace(oldId, "I" + changeId.getName());
            }
            return message;
        }
        String[] lines = message.split("\n");
        int footerFirstLine = lines.length;
        for (int i3 = lines.length - 1; i3 > 1; --i3) {
            if (footerPattern.matcher(lines[i3]).matches()) {
                footerFirstLine = i3;
                continue;
            }
            if (footerFirstLine != lines.length && lines[i3].length() == 0) break;
            if (footerFirstLine != lines.length && includeInFooterPattern.matcher(lines[i3]).matches()) {
                footerFirstLine = i3 + 1;
                continue;
            }
            footerFirstLine = lines.length;
            break;
        }
        int insertAfter = footerFirstLine;
        for (int i4 = footerFirstLine; i4 < lines.length && issuePattern.matcher(lines[i4]).matches(); ++i4) {
            insertAfter = i4 + 1;
        }
        StringBuilder ret = new StringBuilder();
        for (i = 0; i < insertAfter; ++i) {
            ret.append(lines[i]);
            ret.append("\n");
        }
        if (insertAfter == lines.length && insertAfter == footerFirstLine) {
            ret.append("\n");
        }
        ret.append(CHANGE_ID);
        ret.append(" I");
        ret.append(ObjectId.toString(changeId));
        ret.append("\n");
        while (i < lines.length) {
            ret.append(lines[i]);
            ret.append("\n");
            ++i;
        }
        return ret.toString();
    }
}

