/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class CallableResultCache<T> {
    private final Cache<CachedOperationId<T>, T> cache;

    public CallableResultCache(Cache<CachedOperationId<T>, T> cache) {
        this.cache = cache;
    }

    private static <T> CacheLoader<CachedOperationId<T>, T> loader() {
        return new CacheLoader<CachedOperationId<T>, T>(){

            public T load(CachedOperationId<T> key) throws Exception {
                return key.getCallable().call();
            }
        };
    }

    public static <T> CallableResultCache<T> build(@NotNull CacheBuilder<Object, Object> builder) {
        CacheLoader<CachedOperationId<T>, T> loader = CallableResultCache.loader();
        Cache cache = builder.build(loader);
        return new CallableResultCache<T>(cache);
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public T call(@NotNull Callable<T> callable, Object ... keys) {
        return (T)this.cache.getUnchecked(new CachedOperationId<T>(callable, keys));
    }

    public static final class CachedOperationId<T> {
        private final Callable<T> callable;
        private final Object[] keys;

        public CachedOperationId(Callable<T> callable, Object ... keys) {
            this.callable = callable;
            this.keys = keys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedOperationId that = (CachedOperationId)o;
            return Arrays.equals(this.keys, that.keys);
        }

        public Callable<T> getCallable() {
            return this.callable;
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }
    }
}

