/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.Constants;
import org.shaded.eclipse.jgit.lib.MutableObjectId;
import org.shaded.eclipse.jgit.lib.ObjectInserter;
import org.shaded.eclipse.jgit.lib.ObjectReader;
import org.shaded.eclipse.jgit.lib.PersonIdent;
import org.shaded.eclipse.jgit.revwalk.FooterKey;
import org.shaded.eclipse.jgit.revwalk.FooterLine;
import org.shaded.eclipse.jgit.revwalk.RevFlag;
import org.shaded.eclipse.jgit.revwalk.RevObject;
import org.shaded.eclipse.jgit.revwalk.RevTree;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevCommit
extends RevObject {
    static final RevCommit[] NO_PARENTS = new RevCommit[0];
    private RevTree tree;
    RevCommit[] parents;
    int commitTime;
    int inDegree;
    private byte[] buffer;

    public static RevCommit parse(byte[] raw) {
        return RevCommit.parse(new RevWalk((ObjectReader)null), raw);
    }

    public static RevCommit parse(RevWalk rw, byte[] raw) {
        ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();
        boolean retain = rw.isRetainBody();
        rw.setRetainBody(true);
        RevCommit r = rw.lookupCommit(fmt.idFor(1, raw));
        r.parseCanonical(rw, raw);
        rw.setRetainBody(retain);
        return r;
    }

    protected RevCommit(AnyObjectId id) {
        super(id);
    }

    @Override
    void parseHeaders(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.parseCanonical(walk, walk.getCachedBytes(this));
    }

    @Override
    void parseBody(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.buffer == null) {
            this.buffer = walk.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(walk, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk walk, byte[] raw) {
        MutableObjectId idBuffer = walk.idBuffer;
        idBuffer.fromString(raw, 5);
        this.tree = walk.lookupTree(idBuffer);
        int ptr = 46;
        if (this.parents == null) {
            RevCommit[] pList = new RevCommit[1];
            int nParents = 0;
            while (raw[ptr] == 112) {
                idBuffer.fromString(raw, ptr + 7);
                RevCommit p = walk.lookupCommit(idBuffer);
                if (nParents == 0) {
                    pList[nParents++] = p;
                } else if (nParents == 1) {
                    pList = new RevCommit[]{pList[0], p};
                    nParents = 2;
                } else {
                    if (pList.length <= nParents) {
                        RevCommit[] old = pList;
                        pList = new RevCommit[pList.length + 32];
                        System.arraycopy(old, 0, pList, 0, nParents);
                    }
                    pList[nParents++] = p;
                }
                ptr += 48;
            }
            if (nParents != pList.length) {
                RevCommit[] old = pList;
                pList = new RevCommit[nParents];
                System.arraycopy(old, 0, pList, 0, nParents);
            }
            this.parents = pList;
        }
        if ((ptr = RawParseUtils.committer(raw, ptr)) > 0) {
            ptr = RawParseUtils.nextLF(raw, ptr, '>');
            this.commitTime = RawParseUtils.parseBase10(raw, ptr, null);
        }
        if (walk.isRetainBody()) {
            this.buffer = raw;
        }
        this.flags |= 1;
    }

    @Override
    public final int getType() {
        return 1;
    }

    static void carryFlags(RevCommit c, int carry) {
        RevCommit[] pList;
        while ((pList = c.parents) != null) {
            int n = pList.length;
            if (n == 0) {
                return;
            }
            for (int i = 1; i < n; ++i) {
                RevCommit p = pList[i];
                if ((p.flags & carry) == carry) continue;
                p.flags |= carry;
                RevCommit.carryFlags(p, carry);
            }
            c = pList[0];
            if ((c.flags & carry) == carry) {
                return;
            }
            c.flags |= carry;
        }
        return;
    }

    public void carry(RevFlag flag) {
        int carry = this.flags & flag.mask;
        if (carry != 0) {
            RevCommit.carryFlags(this, carry);
        }
    }

    public final int getCommitTime() {
        return this.commitTime;
    }

    public final RevTree getTree() {
        return this.tree;
    }

    public final int getParentCount() {
        return this.parents.length;
    }

    public final RevCommit getParent(int nth) {
        return this.parents[nth];
    }

    public final RevCommit[] getParents() {
        return this.parents;
    }

    public final byte[] getRawBuffer() {
        return this.buffer;
    }

    public final PersonIdent getAuthorIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.author(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final PersonIdent getCommitterIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.committer(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final String getFullMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        return RawParseUtils.decode(enc, raw, msgB, raw.length);
    }

    public final String getShortMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        int msgE = RawParseUtils.endOfParagraph(raw, msgB);
        String str = RawParseUtils.decode(enc, raw, msgB, msgE);
        if (RevCommit.hasLF(raw, msgB, msgE)) {
            str = str.replace('\n', ' ');
        }
        return str;
    }

    static boolean hasLF(byte[] r, int b, int e) {
        while (b < e) {
            if (r[b++] != 10) continue;
            return true;
        }
        return false;
    }

    public final Charset getEncoding() {
        return RawParseUtils.parseEncoding(this.buffer);
    }

    public final List<FooterLine> getFooterLines() {
        int keyStart;
        byte[] raw = this.buffer;
        int ptr = raw.length - 1;
        while (raw[ptr] == 10) {
            --ptr;
        }
        int msgB = RawParseUtils.commitMessage(raw, 0);
        ArrayList<FooterLine> r = new ArrayList<FooterLine>(4);
        Charset enc = this.getEncoding();
        while ((ptr = RawParseUtils.prevLF(raw, ptr)) > msgB && raw[keyStart = ptr + 2] != 10) {
            int valStart;
            int keyEnd = RawParseUtils.endOfFooterLineKey(raw, keyStart);
            if (keyEnd < 0) continue;
            for (valStart = keyEnd + 1; valStart < raw.length && raw[valStart] == 32; ++valStart) {
            }
            int valEnd = RawParseUtils.nextLF(raw, valStart);
            if (raw[valEnd - 1] == 10) {
                --valEnd;
            }
            r.add(new FooterLine(raw, enc, keyStart, keyEnd, valStart, valEnd));
        }
        Collections.reverse(r);
        return r;
    }

    public final List<String> getFooterLines(String keyName) {
        return this.getFooterLines(new FooterKey(keyName));
    }

    public final List<String> getFooterLines(FooterKey keyName) {
        List<FooterLine> src = this.getFooterLines();
        if (src.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>(src.size());
        for (FooterLine f : src) {
            if (!f.matches(keyName)) continue;
            r.add(f.getValue());
        }
        return r;
    }

    public void reset() {
        this.inDegree = 0;
    }

    final void disposeBody() {
        this.buffer = null;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(Constants.typeString(this.getType()));
        s.append(' ');
        s.append(this.name());
        s.append(' ');
        s.append(this.commitTime);
        s.append(' ');
        this.appendCoreFlags(s);
        return s.toString();
    }
}

