/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.git.AbstractGitOperationHelper;
import com.atlassian.bamboo.plugins.git.CallableResultCache;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCommandBuilder;
import com.atlassian.bamboo.plugins.git.GitCommandProcessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.ScpAwareUri;
import com.atlassian.bamboo.plugins.git.UriUtils;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataBuilder;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.bamboo.ssh.ProxyException;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.transport.URIish;

public class NativeGitOperationHelper
extends AbstractGitOperationHelper
implements GitOperationHelper {
    private static final Logger log = Logger.getLogger(NativeGitOperationHelper.class);
    protected SshProxyService sshProxyService;
    GitCommandProcessor gitCommandProcessor;
    private static final CallableResultCache<ImmutableMap<String, String>> GET_REMOTE_REFS_CACHE = CallableResultCache.build((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS));

    public NativeGitOperationHelper(@NotNull GitRepository repository, @NotNull GitRepositoryAccessData accessData, @NotNull SshProxyService sshProxyService, @NotNull BuildLogger buildLogger, @NotNull I18nResolver i18nResolver) throws RepositoryException {
        super(accessData, buildLogger, i18nResolver);
        this.sshProxyService = sshProxyService;
        this.gitCommandProcessor = new GitCommandProcessor(repository.getGitCapability(), buildLogger, accessData.getPassword(), accessData.getCommandTimeout(), accessData.isVerboseLogs());
        this.gitCommandProcessor.checkGitExistenceInSystem(repository.getWorkingDirectory());
        this.gitCommandProcessor.setSshCommand(repository.getSshCapability());
    }

    @Override
    public void pushRevision(@NotNull File sourceDirectory, @NotNull String revision) throws RepositoryException {
        String possibleBranch = this.gitCommandProcessor.getPossibleBranchNameForCheckout(sourceDirectory, revision, this.accessData.getVcsBranch().getName());
        if (StringUtils.isBlank((String)possibleBranch)) {
            throw new RepositoryException("Can't guess branch name for revision " + revision + " when trying to perform push.");
        }
        GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createCommandBuilder("push", proxiedAccessData.getRepositoryUrl(), possibleBranch);
        if (proxiedAccessData.isVerboseLogs()) {
            commandBuilder.verbose(true);
        }
        this.gitCommandProcessor.runCommand(commandBuilder, sourceDirectory);
    }

    @Override
    public String commit(@NotNull File sourceDirectory, @NotNull String message, @NotNull String comitterName, @NotNull String comitterEmail) throws RepositoryException {
        if (!this.containsSomethingToCommit(sourceDirectory)) {
            log.debug((Object)"Nothing to commit");
            return this.getCurrentRevision(sourceDirectory);
        }
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createCommandBuilder("commit", "--all", "-m", message).env((Map<String, String>)this.identificationVariables(comitterName, comitterEmail));
        if (this.accessData.isVerboseLogs()) {
            commandBuilder.verbose(true);
        }
        this.gitCommandProcessor.runCommand(commandBuilder, sourceDirectory);
        return this.getCurrentRevision(sourceDirectory);
    }

    public ImmutableMap<String, String> identificationVariables(@NotNull String name, @NotNull String email) {
        return ImmutableMap.of((Object)"GIT_COMMITTER_NAME", (Object)name, (Object)"GIT_COMMITTER_EMAIL", (Object)email, (Object)"GIT_AUTHOR_NAME", (Object)name, (Object)"GIT_AUTHOR_EMAIL", (Object)email);
    }

    @VisibleForTesting
    protected GitRepositoryAccessData adjustRepositoryAccess(@NotNull GitRepositoryAccessData accessData) throws RepositoryException {
        boolean needsProxy;
        boolean sshKeypair = accessData.getAuthenticationType() == GitAuthenticationType.SSH_KEYPAIR;
        boolean sshWithPassword = UriUtils.requiresSshTransport(accessData.getRepositoryUrl()) && accessData.getAuthenticationType() == GitAuthenticationType.PASSWORD;
        boolean bl = needsProxy = sshKeypair || sshWithPassword;
        if (needsProxy) {
            GitRepositoryAccessData.Builder proxyAccessDataBuilder = GitRepositoryAccessData.builder(accessData);
            GitRepositoryAccessData proxyAccessData = proxyAccessDataBuilder.build();
            ScpAwareUri repositoryUri = ScpAwareUri.create(accessData.getRepositoryUrl());
            if (UriUtils.requiresSshTransport(repositoryUri)) {
                try {
                    String username = UriUtils.extractUsername(accessData.getRepositoryUrl());
                    if (username != null) {
                        proxyAccessData.setUsername(username);
                    }
                    ProxyConnectionDataBuilder proxyConnectionDataBuilder = this.sshProxyService.createProxyConnectionDataBuilder().withRemoteHost(repositoryUri.getHost()).withRemotePort(repositoryUri.getPort() == -1 ? null : Integer.valueOf(repositoryUri.getPort())).withRemoteUserName(StringUtils.defaultIfEmpty((String)proxyAccessData.getUsername(), (String)repositoryUri.getUserInfo())).withErrorReceiver((ProxyErrorReceiver)this.gitCommandProcessor);
                    if (repositoryUri.isRelativePath()) {
                        proxyConnectionDataBuilder.withRemotePathMapping(repositoryUri.getAbsolutePath(), repositoryUri.getRawPath());
                    }
                    switch (accessData.getAuthenticationType()) {
                        case SSH_KEYPAIR: {
                            proxyConnectionDataBuilder.withKeyFromString(proxyAccessData.getSshKey(), proxyAccessData.getSshPassphrase());
                            break;
                        }
                        case PASSWORD: {
                            proxyConnectionDataBuilder.withRemotePassword(StringUtils.defaultString((String)proxyAccessData.getPassword()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Proxy does not know how to handle " + (Object)((Object)accessData.getAuthenticationType()));
                        }
                    }
                    ProxyConnectionData connectionData = proxyConnectionDataBuilder.build();
                    proxyAccessData.setProxyRegistrationInfo(this.sshProxyService.register(connectionData));
                    URI repositoryViaProxy = UriUtils.getUriViaProxy(proxyAccessData, repositoryUri);
                    proxyAccessData.setRepositoryUrl(repositoryViaProxy.toString());
                }
                catch (IOException e) {
                    if (e.getMessage().contains("exception using cipher - please check password and data.")) {
                        throw new RepositoryException(this.buildLogger.addErrorLogEntry("Encryption exception - please check ssh keyfile passphrase."), (Throwable)e);
                    }
                    throw new RepositoryException("Cannot decode connection params", (Throwable)e);
                }
                catch (ProxyException e) {
                    throw new RepositoryException("Cannot create SSH proxy", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    throw new RepositoryException("Remote repository URL invalid", (Throwable)e);
                }
                return proxyAccessData;
            }
        } else {
            GitRepositoryAccessData credentialsAwareAccessData = GitRepositoryAccessData.builder(accessData).build();
            String repositoryUrl = this.getUrlWithNormalisedCredentials(credentialsAwareAccessData);
            credentialsAwareAccessData.setRepositoryUrl(repositoryUrl);
            return credentialsAwareAccessData;
        }
        return accessData;
    }

    @Override
    public boolean merge(@NotNull File workspaceDir, @NotNull String targetRevision, @NotNull String committerName, @NotNull String committerEmail) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createCommandBuilder("merge", "--no-commit", targetRevision).env((Map<String, String>)this.identificationVariables(committerName, committerEmail));
        String headRevisionBeforeMerge = this.getCurrentRevision(workspaceDir);
        this.gitCommandProcessor.runMergeCommand(commandBuilder, workspaceDir);
        if (this.containsSomethingToCommit(workspaceDir)) {
            return true;
        }
        String headRevisionAfterMerge = this.getCurrentRevision(workspaceDir);
        log.debug((Object)("Revision before merge: " + headRevisionBeforeMerge + ", after merge: " + headRevisionAfterMerge));
        return !headRevisionAfterMerge.equals(headRevisionBeforeMerge);
    }

    private boolean containsSomethingToCommit(@NotNull File workspaceDir) throws RepositoryException {
        boolean hasModifiedFiles;
        String mergeHead = this.getRevisionIfExists(workspaceDir, "MERGE_HEAD");
        if (mergeHead != null) {
            log.debug((Object)"Has modified index");
            return true;
        }
        List<String> strings = this.gitCommandProcessor.runStatusCommand(workspaceDir);
        boolean bl = hasModifiedFiles = !strings.isEmpty();
        if (hasModifiedFiles) {
            log.debug((Object)"Has modified files");
        }
        return hasModifiedFiles;
    }

    @NotNull
    private String getUrlWithNormalisedCredentials(GitRepositoryAccessData repositoryAccessData) {
        try {
            URIish repositoryLocation = new URIish(repositoryAccessData.getRepositoryUrl());
            URIish normalisedUri = UriUtils.normaliseRepositoryLocation(repositoryAccessData.getUsername(), repositoryAccessData.getPassword(), repositoryLocation, false);
            return normalisedUri.toPrivateString();
        }
        catch (URISyntaxException e) {
            String message = "Cannot parse remote URI: " + repositoryAccessData.getRepositoryUrl();
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void createLocalRepository(File sourceDirectory, File cacheDirectory) throws RepositoryException, IOException {
        File objectsCache;
        if (!sourceDirectory.exists()) {
            sourceDirectory.mkdirs();
        }
        File gitDirectory = new File(sourceDirectory, ".git");
        String headRef = null;
        File cacheGitDir = null;
        File alternateObjectDir = null;
        if (cacheDirectory != null && cacheDirectory.exists() && (objectsCache = new File(cacheGitDir = new File(cacheDirectory, ".git"), "objects")).exists()) {
            alternateObjectDir = objectsCache;
            headRef = FileUtils.readFileToString((File)new File(cacheGitDir, "HEAD"));
        }
        if (!gitDirectory.exists()) {
            this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.creatingGitRepository", new Serializable[]{gitDirectory}));
            this.gitCommandProcessor.runInitCommand(sourceDirectory);
        }
        if (alternateObjectDir != null) {
            ArrayList<String> alternatePaths = new ArrayList<String>(1);
            alternatePaths.add(alternateObjectDir.getAbsolutePath());
            File alternates = new File(new File(new File(gitDirectory, "objects"), "info"), "alternates");
            FileUtils.writeLines((File)alternates, alternatePaths, (String)"\n");
        }
        if (cacheGitDir != null && cacheGitDir.isDirectory()) {
            FileUtils.copyDirectoryToDirectory((File)new File(cacheGitDir, "refs/tags/"), (File)new File(gitDirectory, "refs/"));
            FileUtils.copyDirectoryToDirectory((File)new File(cacheGitDir, "refs/heads/"), (File)new File(gitDirectory, "refs/"));
            File shallow = new File(cacheGitDir, "shallow");
            if (shallow.exists()) {
                FileUtils.copyFileToDirectory((File)shallow, (File)gitDirectory);
            }
        }
        if (StringUtils.startsWith(headRef, (String)"ref: ")) {
            FileUtils.writeStringToFile((File)new File(gitDirectory, "HEAD"), headRef);
        }
    }

    protected void closeProxy(@NotNull GitRepositoryAccessData accessData) {
        this.sshProxyService.unregister(accessData.getProxyRegistrationInfo());
    }

    @Override
    @NotNull
    public String checkout(@Nullable File cacheDirectory, @NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String previousRevision) throws RepositoryException {
        this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.checkingOutRevision", new Serializable[]{targetRevision}));
        try {
            this.createLocalRepository(sourceDirectory, cacheDirectory);
            File lck = new File(sourceDirectory, "index.lock");
            FileUtils.deleteQuietly((File)lck);
            this.gitCommandProcessor.runCheckoutCommand(sourceDirectory, targetRevision, this.accessData.getVcsBranch().getName());
            if (this.accessData.isUseSubmodules()) {
                this.gitCommandProcessor.runSubmoduleUpdateCommand(sourceDirectory);
            }
            return targetRevision;
        }
        catch (Exception e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.i18nResolver.getText("repository.git.messages.checkoutFailed", new Serializable[]{targetRevision})) + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(@NotNull File sourceDirectory, @NotNull String targetBranchOrRevision, boolean useShallow) throws RepositoryException {
        String[] refSpecDescription = new String[]{"(unresolved) " + targetBranchOrRevision};
        try {
            this.createLocalRepository(sourceDirectory, null);
            GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
            try {
                Pair<String, String> symbolicRefAndHash;
                String resolvedRefSpec = StringUtils.startsWithAny((String)targetBranchOrRevision, (String[])FQREF_PREFIXES) ? targetBranchOrRevision : ((symbolicRefAndHash = this.resolveBranch(this.accessData, proxiedAccessData, sourceDirectory, targetBranchOrRevision)) == null ? "refs/heads/*" : (String)symbolicRefAndHash.first);
                refSpecDescription[0] = resolvedRefSpec;
                this.buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.fetching", new Serializable[]{resolvedRefSpec, this.accessData.getRepositoryUrl()}) + (useShallow ? " " + this.i18nResolver.getText("repository.git.messages.doingShallowFetch") : ""));
                this.gitCommandProcessor.runFetchCommand(sourceDirectory, proxiedAccessData, "+" + resolvedRefSpec + ":" + resolvedRefSpec, useShallow);
            }
            finally {
                this.closeProxy(proxiedAccessData);
            }
        }
        catch (Exception e) {
            String message = this.i18nResolver.getText("repository.git.messages.fetchingFailed", new Serializable[]{this.accessData.getRepositoryUrl(), refSpecDescription[0], sourceDirectory});
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
    }

    @Nullable
    private Pair<String, String> resolveBranch(@NotNull GitRepositoryAccessData directAccessData, @Nullable GitRepositoryAccessData proxiedAccessData, File sourceDirectory, String branch) throws RepositoryException {
        ImmutableMap<String, String> remoteRefs = this.getRemoteRefs(sourceDirectory, directAccessData, proxiedAccessData);
        List<String> candidates = StringUtils.isBlank((String)branch) ? Arrays.asList("refs/heads/master", "HEAD") : (StringUtils.startsWithAny((String)branch, (String[])FQREF_PREFIXES) ? Collections.singletonList(branch) : Arrays.asList(branch, "refs/heads/" + branch, "refs/tags/" + branch));
        for (String symbolicName : candidates) {
            String hash = (String)remoteRefs.get((Object)symbolicName);
            if (hash == null) continue;
            return Pair.make((Object)symbolicName, (Object)hash);
        }
        return null;
    }

    @Override
    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull GitRepositoryAccessData repositoryData, File workingDir) throws RepositoryException {
        ImmutableMap<String, String> refs = this.getRemoteRefs(workingDir, repositoryData, null);
        ArrayList openBranches = Lists.newArrayList();
        for (String refSymbolicName : refs.keySet()) {
            if (!refSymbolicName.startsWith("refs/heads/")) continue;
            openBranches.add(new VcsBranchImpl(refSymbolicName.substring("refs/heads/".length())));
        }
        return openBranches;
    }

    private ImmutableMap<String, String> getRemoteRefs(final File workingDir, final @NotNull GitRepositoryAccessData accessData, final @Nullable GitRepositoryAccessData proxiedAccessData) throws RepositoryException {
        Callable<ImmutableMap<String, String>> getRemoteRefs = new Callable<ImmutableMap<String, String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImmutableMap<String, String> call() throws Exception {
                boolean createNewProxySession = proxiedAccessData == null;
                GitRepositoryAccessData accessDataToUse = createNewProxySession ? NativeGitOperationHelper.this.adjustRepositoryAccess(accessData) : proxiedAccessData;
                try {
                    ImmutableMap<String, String> immutableMap = NativeGitOperationHelper.this.gitCommandProcessor.getRemoteRefs(workingDir, accessDataToUse);
                    return immutableMap;
                }
                finally {
                    if (createNewProxySession) {
                        NativeGitOperationHelper.this.closeProxy(accessDataToUse);
                    }
                }
            }
        };
        ImmutableMap<String, String> callResult = GET_REMOTE_REFS_CACHE.call(getRemoteRefs, accessData.getRepositoryUrl(), accessData.getUsername(), accessData.getSshKey());
        if (log.isDebugEnabled()) {
            log.debug((Object)GET_REMOTE_REFS_CACHE.stats());
        }
        return callResult;
    }

    @Override
    @NotNull
    public String getCurrentRevision(@NotNull File sourceDirectory) throws RepositoryException {
        return this.gitCommandProcessor.getRevisionHash(sourceDirectory, "HEAD");
    }

    @Override
    public String getRevisionIfExists(@NotNull File sourceDirectory, @NotNull String revision) {
        try {
            return this.gitCommandProcessor.getRevisionHash(sourceDirectory, revision);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String obtainLatestRevision() throws RepositoryException {
        File workingDir = new File(".");
        Pair<String, String> branchRef = this.resolveBranch(this.accessData, null, workingDir, this.accessData.getVcsBranch().getName());
        if (branchRef == null) {
            throw new InvalidRepositoryException(this.i18nResolver.getText("repository.git.messages.cannotDetermineHead", new Serializable[]{PasswordMaskingUtils.mask((String)this.accessData.getRepositoryUrl(), (String)this.accessData.getPassword()), this.accessData.getVcsBranch().getName()}));
        }
        return (String)branchRef.second;
    }

    @Override
    public boolean checkRevisionExistsInCacheRepository(@NotNull File repositoryDirectory, @NotNull String targetRevision) throws RepositoryException {
        return targetRevision.equals(this.gitCommandProcessor.getRevisionHash(repositoryDirectory, targetRevision));
    }

    @Override
    @NotNull
    public CommitContext getCommit(File directory, String targetRevision) throws RepositoryException {
        return this.gitCommandProcessor.extractCommit(directory, targetRevision);
    }

    @Override
    public BuildRepositoryChanges extractCommits(File cacheDirectory, String lastVcsRevisionKey, String targetRevision) throws RepositoryException {
        Pair<List<CommitContext>, Integer> result = this.gitCommandProcessor.runLogCommand(cacheDirectory, lastVcsRevisionKey, targetRevision, this.getShallows(cacheDirectory), CHANGESET_LIMIT);
        BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl(targetRevision, (List)result.getFirst());
        buildChanges.setSkippedCommitsCount(((Integer)result.getSecond()).intValue());
        return buildChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getShallows(File cacheDirectory) {
        File shallowFile = new File(new File(cacheDirectory, ".git"), "shallow");
        if (shallowFile.exists()) {
            HashSet hashSet;
            LineIterator shallowFileContent = FileUtils.lineIterator((File)shallowFile);
            try {
                HashSet result = Sets.newHashSet();
                while (shallowFileContent.hasNext()) {
                    String aShallow = shallowFileContent.nextLine();
                    if (StringUtils.isBlank((String)aShallow)) continue;
                    result.add(aShallow.trim());
                }
                hashSet = result;
            }
            catch (Throwable throwable) {
                try {
                    LineIterator.closeQuietly((LineIterator)shallowFileContent);
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn((Object)("Cannot read 'shallow' file " + shallowFile.getAbsolutePath()));
                }
            }
            LineIterator.closeQuietly((LineIterator)shallowFileContent);
            return hashSet;
        }
        return Collections.emptySet();
    }
}

