/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;

public class MockGitCommand
implements Command {
    static final String GIT_EOM_STRING = "0000";
    private OutputStream outputStream;
    private ExitCallback callback;
    private OutputStream err;
    private InputStream in;
    private final String command;

    public MockGitCommand(String command) {
        this.command = command;
    }

    public void setInputStream(final InputStream in) {
        this.in = in;
        new Thread(){

            @Override
            public void run() {
                try {
                    int i;
                    byte[] bytes = new byte[4096];
                    while ((i = in.read(bytes)) != -1) {
                        String s = new String(bytes, 0, i);
                        if (!s.equals(MockGitCommand.GIT_EOM_STRING)) continue;
                        MockGitCommand.this.callback.onExit(0);
                        break;
                    }
                }
                catch (IOException ignored) {
                    MockGitCommand.this.callback.onExit(1);
                }
                IOUtils.closeQuietly((OutputStream)MockGitCommand.this.outputStream);
                IOUtils.closeQuietly((OutputStream)MockGitCommand.this.err);
            }
        }.start();
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        String str = "009b63170cebd46281904c800c12bded0e22c6b56770 HEAD\u0000multi_ack thin-pack side-band side-band-64k ofs-delta shallow no-progress include-tag multi_ack_detailed\n003f63170cebd46281904c800c12bded0e22c6b56770 refs/heads/master\n0000";
        this.outputStream.write(str.getBytes());
        this.outputStream.flush();
    }

    public void destroy() {
        this.callback.onExit(0);
    }
}

