/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.IOException;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.notes.Note;
import org.shaded.eclipse.jgit.notes.NoteMap;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevObject;
import org.shaded.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected ShowNoteCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Note call() throws JGitInternalException {
        this.checkCallable();
        RevWalk walk = new RevWalk(this.repo);
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try {
            Ref ref = this.repo.getRef(this.notesRef);
            if (ref != null) {
                notesCommit = walk.parseCommit(ref.getObjectId());
                map = NoteMap.read(walk.getObjectReader(), notesCommit);
            }
            Note note = map.getNote(this.id);
            Object var7_7 = null;
            walk.release();
            return note;
        }
        catch (IOException e) {
            try {
                throw new JGitInternalException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                walk.release();
                throw throwable;
            }
        }
    }

    public ShowNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public ShowNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

