/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.Ref;

public abstract class ObjectIdRef
implements Ref {
    private final String name;
    private final Ref.Storage storage;
    private final ObjectId objectId;

    protected ObjectIdRef(Ref.Storage st, String name, ObjectId id) {
        this.name = name;
        this.storage = st;
        this.objectId = id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSymbolic() {
        return false;
    }

    public Ref getLeaf() {
        return this;
    }

    public Ref getTarget() {
        return this;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public Ref.Storage getStorage() {
        return this.storage;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Ref[");
        r.append(this.getName());
        r.append('=');
        r.append(ObjectId.toString(this.getObjectId()));
        r.append(']');
        return r.toString();
    }

    public static class PeeledNonTag
    extends ObjectIdRef {
        public PeeledNonTag(Ref.Storage st, String name, ObjectId id) {
            super(st, name, id);
        }

        public ObjectId getPeeledObjectId() {
            return null;
        }

        public boolean isPeeled() {
            return true;
        }
    }

    public static class PeeledTag
    extends ObjectIdRef {
        private final ObjectId peeledObjectId;

        public PeeledTag(Ref.Storage st, String name, ObjectId id, ObjectId p) {
            super(st, name, id);
            this.peeledObjectId = p;
        }

        public ObjectId getPeeledObjectId() {
            return this.peeledObjectId;
        }

        public boolean isPeeled() {
            return true;
        }
    }

    public static class Unpeeled
    extends ObjectIdRef {
        public Unpeeled(Ref.Storage st, String name, ObjectId id) {
            super(st, name, id);
        }

        public ObjectId getPeeledObjectId() {
            return null;
        }

        public boolean isPeeled() {
            return false;
        }
    }
}

