/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.ScpAwareUri;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.transport.URIish;

public class UriUtils {
    static final String SSH_SCHEME = "ssh";
    static final String SCHEME_DELIMITER = "://";
    public static final String SSH_PREFIX = "ssh://";

    private UriUtils() {
    }

    @Nullable
    public static String extractUsername(String repositoryUrl) throws URISyntaxException {
        URIish uri = new URIish(repositoryUrl);
        String auth = uri.getUser();
        if (auth == null) {
            return null;
        }
        return auth;
    }

    public static boolean requiresSshTransport(@NotNull ScpAwareUri repositoryUri) {
        String scheme = repositoryUri.getScheme();
        return scheme != null && scheme.equals(SSH_SCHEME);
    }

    public static boolean requiresSshTransport(@NotNull String repositoryUrl) {
        return repositoryUrl.startsWith(SSH_PREFIX) || UriUtils.hasScpSyntax(repositoryUrl);
    }

    public static boolean hasScpSyntax(@NotNull String url) {
        if (UriUtils.hasScheme(url)) {
            return false;
        }
        int pathDefinitelyStartsHere = url.indexOf("/");
        if (pathDefinitelyStartsHere != -1) {
            url = url.substring(0, pathDefinitelyStartsHere);
        }
        return url.contains(":");
    }

    private static boolean hasScheme(@NotNull String url) {
        int scheme = url.indexOf(SCHEME_DELIMITER);
        return scheme != -1;
    }

    public static URI getUriViaProxy(GitRepository.GitRepositoryAccessData proxyAccessData, ScpAwareUri repositoryUri) throws URISyntaxException {
        return new URI(repositoryUri.getScheme(), proxyAccessData.proxyRegistrationInfo.getProxyUserName(), proxyAccessData.proxyRegistrationInfo.getProxyHost(), proxyAccessData.proxyRegistrationInfo.getProxyPort(), repositoryUri.getAbsolutePath(), repositoryUri.getRawQuery(), repositoryUri.getRawFragment());
    }
}

